/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.os.AsyncTask;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.devsupport.BundleDownloader;
import com.facebook.react.devsupport.DevInternalSettings;
import com.facebook.react.devsupport.InspectorPackagerConnection;
import com.facebook.react.devsupport.PackagerStatusCheck;
import com.facebook.react.devsupport.StackTraceHelper;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.devsupport.interfaces.StackFrame;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.packagerconnection.FileIoHandler;
import com.facebook.react.packagerconnection.JSPackagerClient;
import com.facebook.react.packagerconnection.NotificationOnlyHandler;
import com.facebook.react.packagerconnection.ReconnectingWebSocket;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.packagerconnection.RequestOnlyHandler;
import com.facebook.react.packagerconnection.Responder;
import com.facebook.react.util.RNLog;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DevServerHelper {
    public static final String RELOAD_APP_EXTRA_JS_PROXY = "jsproxy";
    private static final int HTTP_CONNECT_TIMEOUT_MS = 5000;
    private static final String DEBUGGER_MSG_DISABLE = "{ \"id\":1,\"method\":\"Debugger.disable\" }";
    private final DevInternalSettings mSettings;
    private final OkHttpClient mClient;
    private final BundleDownloader mBundleDownloader;
    private final PackagerStatusCheck mPackagerStatusCheck;
    private final String mPackageName;
    @Nullable
    private JSPackagerClient mPackagerClient;
    @Nullable
    private InspectorPackagerConnection mInspectorPackagerConnection;
    private InspectorPackagerConnection.BundleStatusProvider mBundlerStatusProvider;

    public DevServerHelper(DevInternalSettings settings, String packageName, InspectorPackagerConnection.BundleStatusProvider bundleStatusProvider) {
        this.mSettings = settings;
        this.mBundlerStatusProvider = bundleStatusProvider;
        this.mClient = new OkHttpClient.Builder().connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).build();
        this.mBundleDownloader = new BundleDownloader(this.mClient);
        this.mPackagerStatusCheck = new PackagerStatusCheck(this.mClient);
        this.mPackageName = packageName;
    }

    public void openPackagerConnection(final String clientId, final PackagerCommandListener commandListener) {
        if (this.mPackagerClient != null) {
            FLog.w((String)"ReactNative", (String)"Packager connection already open, nooping.");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... backgroundParams) {
                HashMap<String, RequestHandler> handlers = new HashMap<String, RequestHandler>();
                handlers.put("reload", new NotificationOnlyHandler(){

                    @Override
                    public void onNotification(@Nullable Object params) {
                        commandListener.onPackagerReloadCommand();
                    }
                });
                handlers.put("devMenu", new NotificationOnlyHandler(){

                    @Override
                    public void onNotification(@Nullable Object params) {
                        commandListener.onPackagerDevMenuCommand();
                    }
                });
                handlers.put("captureHeap", new RequestOnlyHandler(){

                    @Override
                    public void onRequest(@Nullable Object params, Responder responder) {
                        commandListener.onCaptureHeapCommand(responder);
                    }
                });
                Map<String, RequestHandler> customHandlers = commandListener.customCommandHandlers();
                if (customHandlers != null) {
                    handlers.putAll(customHandlers);
                }
                handlers.putAll(new FileIoHandler().handlers());
                ReconnectingWebSocket.ConnectionCallback onPackagerConnectedCallback = new ReconnectingWebSocket.ConnectionCallback(){

                    @Override
                    public void onConnected() {
                        commandListener.onPackagerConnected();
                    }

                    @Override
                    public void onDisconnected() {
                        commandListener.onPackagerDisconnected();
                    }
                };
                DevServerHelper.this.mPackagerClient = new JSPackagerClient(clientId, DevServerHelper.this.mSettings.getPackagerConnectionSettings(), handlers, onPackagerConnectedCallback);
                DevServerHelper.this.mPackagerClient.init();
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void closePackagerConnection() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                if (DevServerHelper.this.mPackagerClient != null) {
                    DevServerHelper.this.mPackagerClient.close();
                    DevServerHelper.this.mPackagerClient = null;
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void openInspectorConnection() {
        if (this.mInspectorPackagerConnection != null) {
            FLog.w((String)"ReactNative", (String)"Inspector connection already open, nooping.");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                DevServerHelper.this.mInspectorPackagerConnection = new InspectorPackagerConnection(DevServerHelper.this.getInspectorDeviceUrl(), DevServerHelper.this.mPackageName, DevServerHelper.this.mBundlerStatusProvider);
                DevServerHelper.this.mInspectorPackagerConnection.connect();
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void disableDebugger() {
        if (this.mInspectorPackagerConnection != null) {
            this.mInspectorPackagerConnection.sendEventToAllConnections(DEBUGGER_MSG_DISABLE);
        }
    }

    public void closeInspectorConnection() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                if (DevServerHelper.this.mInspectorPackagerConnection != null) {
                    DevServerHelper.this.mInspectorPackagerConnection.closeQuietly();
                    DevServerHelper.this.mInspectorPackagerConnection = null;
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void openUrl(final ReactContext context, final String url, final String errorMessage) {
        new AsyncTask<Void, String, Boolean>(){

            protected Boolean doInBackground(Void ... ignore) {
                return this.doSync();
            }

            public boolean doSync() {
                try {
                    String openUrlEndpoint = DevServerHelper.this.getOpenUrlEndpoint((Context)context);
                    String jsonString = new JSONObject().put("url", (Object)url).toString();
                    RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jsonString);
                    Request request = new Request.Builder().url(openUrlEndpoint).post(body).build();
                    OkHttpClient client = new OkHttpClient();
                    client.newCall(request).execute();
                    return true;
                }
                catch (IOException | JSONException e) {
                    FLog.e((String)"ReactNative", (String)("Failed to open URL" + url), (Throwable)e);
                    return false;
                }
            }

            protected void onPostExecute(Boolean result) {
                if (!result.booleanValue()) {
                    RNLog.w(context, errorMessage);
                }
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    public void symbolicateStackTrace(Iterable<StackFrame> stackFrames, final SymbolicationListener listener) {
        try {
            String symbolicateURL = DevServerHelper.createSymbolicateURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
            JSONArray jsonStackFrames = new JSONArray();
            for (StackFrame stackFrame : stackFrames) {
                jsonStackFrames.put((Object)stackFrame.toJSON());
            }
            Request request = new Request.Builder().url(symbolicateURL).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)new JSONObject().put("stack", (Object)jsonStackFrames).toString())).build();
            Call symbolicateCall = (Call)Assertions.assertNotNull((Object)this.mClient.newCall(request));
            symbolicateCall.enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    FLog.w((String)"ReactNative", (String)("Got IOException when attempting symbolicate stack trace: " + e.getMessage()));
                    listener.onSymbolicationComplete(null);
                }

                public void onResponse(Call call, Response response) throws IOException {
                    try {
                        listener.onSymbolicationComplete(Arrays.asList(StackTraceHelper.convertJsStackTrace(new JSONObject(response.body().string()).getJSONArray("stack"))));
                    }
                    catch (JSONException exception) {
                        listener.onSymbolicationComplete(null);
                    }
                }
            });
        }
        catch (JSONException e) {
            FLog.w((String)"ReactNative", (String)("Got JSONException when attempting symbolicate stack trace: " + e.getMessage()));
        }
    }

    public void openStackFrameCall(StackFrame stackFrame) {
        String openStackFrameURL = DevServerHelper.createOpenStackFrameURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
        Request request = new Request.Builder().url(openStackFrameURL).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)stackFrame.toJSON().toString())).build();
        Call symbolicateCall = (Call)Assertions.assertNotNull((Object)this.mClient.newCall(request));
        symbolicateCall.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                FLog.w((String)"ReactNative", (String)("Got IOException when attempting to open stack frame: " + e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
            }
        });
    }

    public String getWebsocketProxyURL() {
        return String.format(Locale.US, "ws://%s/debugger-proxy?role=client", this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    private String getInspectorDeviceUrl() {
        return String.format(Locale.US, "http://%s/inspector/device?name=%s&app=%s", this.mSettings.getPackagerConnectionSettings().getInspectorServerHost(), AndroidInfoHelpers.getFriendlyDeviceName(), this.mPackageName);
    }

    public void downloadBundleFromURL(DevBundleDownloadListener callback, File outputFile, String bundleURL, BundleDownloader.BundleInfo bundleInfo) {
        this.mBundleDownloader.downloadBundleFromURL(callback, outputFile, bundleURL, bundleInfo);
    }

    private String getOpenUrlEndpoint(Context context) {
        return String.format(Locale.US, "http://%s/open-url", AndroidInfoHelpers.getServerHost(context));
    }

    public void downloadBundleFromURL(DevBundleDownloadListener callback, File outputFile, String bundleURL, BundleDownloader.BundleInfo bundleInfo, Request.Builder requestBuilder) {
        this.mBundleDownloader.downloadBundleFromURL(callback, outputFile, bundleURL, bundleInfo, requestBuilder);
    }

    private String getHostForJSProxy() {
        String host = (String)Assertions.assertNotNull((Object)this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
        int portOffset = host.lastIndexOf(58);
        if (portOffset > -1) {
            return "localhost" + host.substring(portOffset);
        }
        return "localhost";
    }

    private boolean getDevMode() {
        return this.mSettings.isJSDevModeEnabled();
    }

    private boolean getJSMinifyMode() {
        return this.mSettings.isJSMinifyEnabled();
    }

    private String createBundleURL(String mainModuleID, BundleType type, String host) {
        return this.createBundleURL(mainModuleID, type, host, false, true);
    }

    private String createSplitBundleURL(String mainModuleID, String host) {
        return this.createBundleURL(mainModuleID, BundleType.BUNDLE, host, true, false);
    }

    private String createBundleURL(String mainModuleID, BundleType type, String host, boolean modulesOnly, boolean runModule) {
        String runtimeBytecodeVersion = "";
        return String.format(Locale.US, "http://%s/%s.%s?platform=android&dev=%s&minify=%s&app=%s&modulesOnly=%s&runModule=%s%s", host, mainModuleID, type.typeID(), this.getDevMode(), this.getJSMinifyMode(), this.mPackageName, modulesOnly ? "true" : "false", runModule ? "true" : "false", runtimeBytecodeVersion);
    }

    private String createBundleURL(String mainModuleID, BundleType type) {
        return this.createBundleURL(mainModuleID, type, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    private static String createResourceURL(String host, String resourcePath) {
        return String.format(Locale.US, "http://%s/%s", host, resourcePath);
    }

    private static String createSymbolicateURL(String host) {
        return String.format(Locale.US, "http://%s/symbolicate", host);
    }

    private static String createOpenStackFrameURL(String host) {
        return String.format(Locale.US, "http://%s/open-stack-frame", host);
    }

    public String getDevServerBundleURL(String jsModulePath) {
        return this.createBundleURL(jsModulePath, BundleType.BUNDLE, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    public String getDevServerSplitBundleURL(String jsModulePath) {
        return this.createSplitBundleURL(jsModulePath, this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    public void isPackagerRunning(PackagerStatusCallback callback) {
        String host = this.mSettings.getPackagerConnectionSettings().getDebugServerHost();
        if (host == null) {
            FLog.w((String)"ReactNative", (String)"No packager host configured.");
            callback.onPackagerStatusFetched(false);
        } else {
            this.mPackagerStatusCheck.run(host, callback);
        }
    }

    private String createLaunchJSDevtoolsCommandUrl() {
        return String.format(Locale.US, "http://%s/launch-js-devtools", this.mSettings.getPackagerConnectionSettings().getDebugServerHost());
    }

    public void launchJSDevtools() {
        Request request = new Request.Builder().url(this.createLaunchJSDevtoolsCommandUrl()).build();
        this.mClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
            }

            public void onResponse(Call call, Response response) throws IOException {
            }
        });
    }

    public String getSourceMapUrl(String mainModuleName) {
        return this.createBundleURL(mainModuleName, BundleType.MAP);
    }

    public String getSourceUrl(String mainModuleName) {
        return this.createBundleURL(mainModuleName, BundleType.BUNDLE);
    }

    public String getJSBundleURLForRemoteDebugging(String mainModuleName) {
        return this.createBundleURL(mainModuleName, BundleType.BUNDLE, this.getHostForJSProxy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public File downloadBundleResourceFromUrlSync(String resourcePath, File outputFile) {
        String resourceURL = DevServerHelper.createResourceURL(this.mSettings.getPackagerConnectionSettings().getDebugServerHost(), resourcePath);
        Request request = new Request.Builder().url(resourceURL).build();
        try (Response response = this.mClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                File file2 = null;
                return file2;
            }
            try (Sink output = null;){
                output = Okio.sink((File)outputFile);
                Okio.buffer((Source)response.body().source()).readAll(output);
            }
            File file = outputFile;
            return file;
        }
        catch (Exception ex) {
            FLog.e((String)"ReactNative", (String)"Failed to fetch resource synchronously - resourcePath: \"%s\", outputFile: \"%s\"", (Object[])new Object[]{resourcePath, outputFile.getAbsolutePath(), ex});
            return null;
        }
    }

    private static enum BundleType {
        BUNDLE("bundle"),
        MAP("map");

        private final String mTypeID;

        private BundleType(String typeID) {
            this.mTypeID = typeID;
        }

        public String typeID() {
            return this.mTypeID;
        }
    }

    public static interface SymbolicationListener {
        public void onSymbolicationComplete(@Nullable Iterable<StackFrame> var1);
    }

    public static interface PackagerCustomCommandProvider {
    }

    public static interface PackagerCommandListener {
        public void onPackagerConnected();

        public void onPackagerDisconnected();

        public void onPackagerReloadCommand();

        public void onPackagerDevMenuCommand();

        public void onCaptureHeapCommand(Responder var1);

        @Nullable
        public Map<String, RequestHandler> customCommandHandlers();
    }

    public static interface OnServerContentChangeListener {
        public void onServerContentChanged();
    }
}

