/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.defaults;

import com.facebook.react.ReactNativeHost;
import com.facebook.react.bridge.JSIModulePackage;
import com.facebook.react.bridge.JSIModuleProvider;
import com.facebook.react.bridge.JSIModuleSpec;
import com.facebook.react.bridge.JSIModuleType;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.defaults.DefaultComponentsRegistry;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricJSIModuleProvider;
import com.facebook.react.fabric.ReactNativeConfig;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/defaults/DefaultJSIModulePackage;", "Lcom/facebook/react/bridge/JSIModulePackage;", "reactNativeHost", "Lcom/facebook/react/ReactNativeHost;", "(Lcom/facebook/react/ReactNativeHost;)V", "getJSIModules", "", "Lcom/facebook/react/bridge/JSIModuleSpec;", "Lcom/facebook/react/bridge/UIManager;", "reactApplicationContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "jsContext", "Lcom/facebook/react/bridge/JavaScriptContextHolder;", "JSIModuleForFabric", "ReactAndroid_release"})
public final class DefaultJSIModulePackage
implements JSIModulePackage {
    @NotNull
    private final ReactNativeHost reactNativeHost;

    public DefaultJSIModulePackage(@NotNull ReactNativeHost reactNativeHost) {
        Intrinsics.checkNotNullParameter((Object)reactNativeHost, (String)"reactNativeHost");
        this.reactNativeHost = reactNativeHost;
    }

    @NotNull
    public List<JSIModuleSpec<UIManager>> getJSIModules(@NotNull ReactApplicationContext reactApplicationContext, @NotNull JavaScriptContextHolder jsContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        Intrinsics.checkNotNullParameter((Object)jsContext, (String)"jsContext");
        return CollectionsKt.listOf((Object)new JSIModuleForFabric(reactApplicationContext, this.reactNativeHost));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/defaults/DefaultJSIModulePackage$JSIModuleForFabric;", "Lcom/facebook/react/bridge/JSIModuleSpec;", "Lcom/facebook/react/bridge/UIManager;", "reactApplicationContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "reactNativeHost", "Lcom/facebook/react/ReactNativeHost;", "(Lcom/facebook/react/defaults/DefaultJSIModulePackage;Lcom/facebook/react/bridge/ReactApplicationContext;Lcom/facebook/react/ReactNativeHost;)V", "getJSIModuleProvider", "Lcom/facebook/react/bridge/JSIModuleProvider;", "getJSIModuleType", "Lcom/facebook/react/bridge/JSIModuleType;", "ReactAndroid_release"})
    private final class JSIModuleForFabric
    implements JSIModuleSpec<UIManager> {
        @NotNull
        private final ReactApplicationContext reactApplicationContext;
        @NotNull
        private final ReactNativeHost reactNativeHost;

        public JSIModuleForFabric(@NotNull ReactApplicationContext reactApplicationContext, ReactNativeHost reactNativeHost) {
            Intrinsics.checkNotNullParameter((Object)DefaultJSIModulePackage.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
            Intrinsics.checkNotNullParameter((Object)reactNativeHost, (String)"reactNativeHost");
            this.reactApplicationContext = reactApplicationContext;
            this.reactNativeHost = reactNativeHost;
        }

        @Override
        @NotNull
        public JSIModuleType getJSIModuleType() {
            return JSIModuleType.UIManager;
        }

        @Override
        @NotNull
        public JSIModuleProvider<UIManager> getJSIModuleProvider() {
            ComponentFactory componentFactory = new ComponentFactory();
            DefaultComponentsRegistry.Companion.register(componentFactory);
            List<ViewManager> viewManagers = this.reactNativeHost.getReactInstanceManager().getOrCreateViewManagers(this.reactApplicationContext);
            ViewManagerRegistry viewManagerRegistry = new ViewManagerRegistry(viewManagers);
            return new FabricJSIModuleProvider(this.reactApplicationContext, componentFactory, ReactNativeConfig.DEFAULT_CONFIG, viewManagerRegistry);
        }
    }
}

