/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import androidx.annotation.Nullable;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class InterpolationAnimatedNode
extends ValueAnimatedNode {
    public static final String EXTRAPOLATE_TYPE_IDENTITY = "identity";
    public static final String EXTRAPOLATE_TYPE_CLAMP = "clamp";
    public static final String EXTRAPOLATE_TYPE_EXTEND = "extend";
    private static final String fpRegex = "[+-]?(\\d+\\.?\\d*|\\.\\d+)([eE][+-]?\\d+)?";
    private static final Pattern fpPattern = Pattern.compile("[+-]?(\\d+\\.?\\d*|\\.\\d+)([eE][+-]?\\d+)?");
    private final double[] mInputRange;
    private final double[] mOutputRange;
    private String mPattern;
    private double[][] mOutputs;
    private final boolean mHasStringOutput;
    private final Matcher mSOutputMatcher;
    private final String mExtrapolateLeft;
    private final String mExtrapolateRight;
    @Nullable
    private ValueAnimatedNode mParent;
    private boolean mShouldRound;
    private int mNumVals;

    private static double[] fromDoubleArray(ReadableArray ary) {
        double[] res = new double[ary.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = ary.getDouble(i);
        }
        return res;
    }

    private static double interpolate(double value, double inputMin, double inputMax, double outputMin, double outputMax, String extrapolateLeft, String extrapolateRight) {
        double result = value;
        if (result < inputMin) {
            switch (extrapolateLeft) {
                case "identity": {
                    return result;
                }
                case "clamp": {
                    result = inputMin;
                    break;
                }
                case "extend": {
                    break;
                }
                default: {
                    throw new JSApplicationIllegalArgumentException("Invalid extrapolation type " + extrapolateLeft + "for left extrapolation");
                }
            }
        }
        if (result > inputMax) {
            switch (extrapolateRight) {
                case "identity": {
                    return result;
                }
                case "clamp": {
                    result = inputMax;
                    break;
                }
                case "extend": {
                    break;
                }
                default: {
                    throw new JSApplicationIllegalArgumentException("Invalid extrapolation type " + extrapolateRight + "for right extrapolation");
                }
            }
        }
        if (outputMin == outputMax) {
            return outputMin;
        }
        if (inputMin == inputMax) {
            if (value <= inputMin) {
                return outputMin;
            }
            return outputMax;
        }
        return outputMin + (outputMax - outputMin) * (result - inputMin) / (inputMax - inputMin);
    }

    static double interpolate(double value, double[] inputRange, double[] outputRange, String extrapolateLeft, String extrapolateRight) {
        int rangeIndex = InterpolationAnimatedNode.findRangeIndex(value, inputRange);
        return InterpolationAnimatedNode.interpolate(value, inputRange[rangeIndex], inputRange[rangeIndex + 1], outputRange[rangeIndex], outputRange[rangeIndex + 1], extrapolateLeft, extrapolateRight);
    }

    private static int findRangeIndex(double value, double[] ranges) {
        int index;
        for (index = 1; index < ranges.length - 1 && !(ranges[index] >= value); ++index) {
        }
        return index - 1;
    }

    public InterpolationAnimatedNode(ReadableMap config) {
        this.mInputRange = InterpolationAnimatedNode.fromDoubleArray(config.getArray("inputRange"));
        ReadableArray output = config.getArray("outputRange");
        boolean bl = this.mHasStringOutput = output.getType(0) == ReadableType.String;
        if (this.mHasStringOutput) {
            int size = output.size();
            this.mOutputRange = new double[size];
            this.mPattern = output.getString(0);
            this.mShouldRound = this.mPattern.startsWith("rgb");
            this.mSOutputMatcher = fpPattern.matcher(this.mPattern);
            ArrayList mOutputRanges = new ArrayList();
            for (int i = 0; i < size; ++i) {
                String val = output.getString(i);
                Matcher m = fpPattern.matcher(val);
                ArrayList<Double> outputRange = new ArrayList<Double>();
                mOutputRanges.add(outputRange);
                while (m.find()) {
                    Double parsed = Double.parseDouble(m.group());
                    outputRange.add(parsed);
                }
                this.mOutputRange[i] = (Double)outputRange.get(0);
            }
            this.mNumVals = ((ArrayList)mOutputRanges.get(0)).size();
            this.mOutputs = new double[this.mNumVals][];
            for (int j = 0; j < this.mNumVals; ++j) {
                double[] arr = new double[size];
                this.mOutputs[j] = arr;
                for (int i = 0; i < size; ++i) {
                    arr[i] = (Double)((ArrayList)mOutputRanges.get(i)).get(j);
                }
            }
        } else {
            this.mOutputRange = InterpolationAnimatedNode.fromDoubleArray(output);
            this.mSOutputMatcher = null;
        }
        this.mExtrapolateLeft = config.getString("extrapolateLeft");
        this.mExtrapolateRight = config.getString("extrapolateRight");
    }

    @Override
    public void onAttachedToNode(AnimatedNode parent) {
        if (this.mParent != null) {
            throw new IllegalStateException("Parent already attached");
        }
        if (!(parent instanceof ValueAnimatedNode)) {
            throw new IllegalArgumentException("Parent is of an invalid type");
        }
        this.mParent = (ValueAnimatedNode)parent;
    }

    @Override
    public void onDetachedFromNode(AnimatedNode parent) {
        if (parent != this.mParent) {
            throw new IllegalArgumentException("Invalid parent node provided");
        }
        this.mParent = null;
    }

    @Override
    public void update() {
        if (this.mParent == null) {
            return;
        }
        double value = this.mParent.getValue();
        this.mValue = InterpolationAnimatedNode.interpolate(value, this.mInputRange, this.mOutputRange, this.mExtrapolateLeft, this.mExtrapolateRight);
        if (this.mHasStringOutput) {
            if (this.mNumVals > 1) {
                StringBuffer sb = new StringBuffer(this.mPattern.length());
                int i = 0;
                this.mSOutputMatcher.reset();
                while (this.mSOutputMatcher.find()) {
                    double val = InterpolationAnimatedNode.interpolate(value, this.mInputRange, this.mOutputs[i++], this.mExtrapolateLeft, this.mExtrapolateRight);
                    if (this.mShouldRound) {
                        boolean isAlpha = i == 4;
                        int rounded = (int)Math.round(isAlpha ? val * 1000.0 : val);
                        String num = isAlpha ? Double.toString((double)rounded / 1000.0) : Integer.toString(rounded);
                        this.mSOutputMatcher.appendReplacement(sb, num);
                        continue;
                    }
                    int intVal = (int)val;
                    String num = (double)intVal != val ? Double.toString(val) : Integer.toString(intVal);
                    this.mSOutputMatcher.appendReplacement(sb, num);
                }
                this.mSOutputMatcher.appendTail(sb);
                this.mAnimatedObject = sb.toString();
            } else {
                this.mAnimatedObject = this.mSOutputMatcher.replaceFirst(String.valueOf(this.mValue));
            }
        }
    }

    @Override
    public String prettyPrint() {
        return "InterpolationAnimatedNode[" + this.mTag + "] super: " + super.prettyPrint();
    }
}

