/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.ReadableMap;

class DiffClampAnimatedNode
extends ValueAnimatedNode {
    private final NativeAnimatedNodesManager mNativeAnimatedNodesManager;
    private final int mInputNodeTag;
    private final double mMin;
    private final double mMax;
    private double mLastValue;

    public DiffClampAnimatedNode(ReadableMap config, NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        this.mNativeAnimatedNodesManager = nativeAnimatedNodesManager;
        this.mInputNodeTag = config.getInt("input");
        this.mMin = config.getDouble("min");
        this.mMax = config.getDouble("max");
        this.mLastValue = 0.0;
        this.mValue = 0.0;
    }

    @Override
    public void update() {
        double value = this.getInputNodeValue();
        double diff = value - this.mLastValue;
        this.mLastValue = value;
        this.mValue = Math.min(Math.max(this.mValue + diff, this.mMin), this.mMax);
    }

    private double getInputNodeValue() {
        AnimatedNode animatedNode = this.mNativeAnimatedNodesManager.getNodeById(this.mInputNodeTag);
        if (animatedNode == null || !(animatedNode instanceof ValueAnimatedNode)) {
            throw new JSApplicationCausedNativeException("Illegal node ID set as an input for Animated.DiffClamp node");
        }
        return ((ValueAnimatedNode)animatedNode).getValue();
    }

    @Override
    public String prettyPrint() {
        return "DiffClampAnimatedNode[" + this.mTag + "]: InputNodeTag: " + this.mInputNodeTag + " min: " + this.mMin + " max: " + this.mMax + " lastValue: " + this.mLastValue + " super: " + super.prettyPrint();
    }
}

