/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.text.Spannable;
import android.text.style.ClickableSpan;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.R;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.IViewManagerWithChildren;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.views.text.ReactClickableSpan;
import com.facebook.react.views.text.ReactTextAnchorViewManager;
import com.facebook.react.views.text.ReactTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextView;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.react.views.text.TextLayoutManagerMapBuffer;
import com.facebook.yoga.YogaMeasureMode;
import java.util.HashMap;
import java.util.Map;

@ReactModule(name="RCTText")
public class ReactTextViewManager
extends ReactTextAnchorViewManager<ReactTextView, ReactTextShadowNode>
implements IViewManagerWithChildren {
    private static final short TX_STATE_KEY_ATTRIBUTED_STRING = 0;
    private static final short TX_STATE_KEY_PARAGRAPH_ATTRIBUTES = 1;
    private static final short TX_STATE_KEY_HASH = 2;
    private static final short TX_STATE_KEY_MOST_RECENT_EVENT_COUNT = 3;
    @VisibleForTesting
    public static final String REACT_CLASS = "RCTText";
    @Nullable
    protected ReactTextViewManagerCallback mReactTextViewManagerCallback;

    public ReactTextViewManager() {
        this(null);
    }

    public ReactTextViewManager(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        this.mReactTextViewManagerCallback = reactTextViewManagerCallback;
        this.setupViewRecycling();
    }

    @Override
    protected ReactTextView prepareToRecycleView(@NonNull ThemedReactContext reactContext, ReactTextView view) {
        super.prepareToRecycleView(reactContext, view);
        view.recycleView();
        this.setSelectionColor(view, null);
        return view;
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactTextView createViewInstance(ThemedReactContext context) {
        return new ReactTextView((Context)context);
    }

    @Override
    public void updateExtraData(ReactTextView view, Object extraData) {
        ReactTextUpdate update = (ReactTextUpdate)extraData;
        Spannable spannable = update.getText();
        if (update.containsImages()) {
            TextInlineImageSpan.possiblyUpdateInlineImageSpans(spannable, (TextView)view);
        }
        view.setText(update);
        ClickableSpan[] clickableSpans = (ReactClickableSpan[])spannable.getSpans(0, update.getText().length(), ReactClickableSpan.class);
        if (clickableSpans.length > 0) {
            view.setTag(R.id.accessibility_links, new ReactAccessibilityDelegate.AccessibilityLinks(clickableSpans, spannable));
            ReactAccessibilityDelegate.resetDelegate((View)view, view.isFocusable(), view.getImportantForAccessibility());
        }
    }

    @Override
    public ReactTextShadowNode createShadowNodeInstance() {
        return new ReactTextShadowNode(this.mReactTextViewManagerCallback);
    }

    public ReactTextShadowNode createShadowNodeInstance(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        return new ReactTextShadowNode(reactTextViewManagerCallback);
    }

    @Override
    public Class<ReactTextShadowNode> getShadowNodeClass() {
        return ReactTextShadowNode.class;
    }

    @Override
    protected void onAfterUpdateTransaction(ReactTextView view) {
        super.onAfterUpdateTransaction(view);
        view.updateView();
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    @Override
    public Object updateState(ReactTextView view, ReactStylesDiffMap props, StateWrapper stateWrapper) {
        ReadableMapBuffer stateMapBuffer = stateWrapper.getStateDataMapBuffer();
        if (stateMapBuffer != null) {
            return this.getReactTextUpdate(view, props, stateMapBuffer);
        }
        ReadableNativeMap state = stateWrapper.getStateData();
        if (state == null) {
            return null;
        }
        ReadableNativeMap attributedString = state.getMap("attributedString");
        ReadableNativeMap paragraphAttributes = state.getMap("paragraphAttributes");
        Spannable spanned = TextLayoutManager.getOrCreateSpannableForText(view.getContext(), attributedString, this.mReactTextViewManagerCallback);
        view.setSpanned(spanned);
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString("textBreakStrategy"));
        return new ReactTextUpdate(spanned, state.hasKey("mostRecentEventCount") ? state.getInt("mostRecentEventCount") : -1, false, TextAttributeProps.getTextAlignment(props, TextLayoutManager.isRTL(attributedString)), textBreakStrategy, TextAttributeProps.getJustificationMode(props));
    }

    private Object getReactTextUpdate(ReactTextView view, ReactStylesDiffMap props, MapBuffer state) {
        MapBuffer attributedString = state.getMapBuffer(0);
        MapBuffer paragraphAttributes = state.getMapBuffer(1);
        Spannable spanned = TextLayoutManagerMapBuffer.getOrCreateSpannableForText(view.getContext(), attributedString, this.mReactTextViewManagerCallback);
        view.setSpanned(spanned);
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString(2));
        return new ReactTextUpdate(spanned, -1, false, TextAttributeProps.getTextAlignment(props, TextLayoutManagerMapBuffer.isRTL(attributedString)), textBreakStrategy, TextAttributeProps.getJustificationMode(props));
    }

    @Override
    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        HashMap<String, Map<String, String>> baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        HashMap<String, Map<String, String>> eventTypeConstants = baseEventTypeConstants == null ? new HashMap<String, Map<String, String>>() : baseEventTypeConstants;
        eventTypeConstants.putAll(MapBuilder.of("topTextLayout", MapBuilder.of("registrationName", "onTextLayout"), "topInlineViewLayout", MapBuilder.of("registrationName", "onInlineViewLayout")));
        return eventTypeConstants;
    }

    @Override
    public long measure(Context context, ReadableMap localData, ReadableMap props, ReadableMap state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode, @Nullable float[] attachmentsPositions) {
        return TextLayoutManager.measureText(context, localData, props, width, widthMode, height, heightMode, this.mReactTextViewManagerCallback, attachmentsPositions);
    }

    @Override
    public long measure(Context context, MapBuffer localData, MapBuffer props, @Nullable MapBuffer state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode, @Nullable float[] attachmentsPositions) {
        return TextLayoutManagerMapBuffer.measureText(context, localData, props, width, widthMode, height, heightMode, this.mReactTextViewManagerCallback, attachmentsPositions);
    }

    @Override
    public void setPadding(ReactTextView view, int left, int top, int right, int bottom) {
        view.setPadding(left, top, right, bottom);
    }
}

