/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ReactClippingViewGroupHelper {
    public static final String PROP_REMOVE_CLIPPED_SUBVIEWS = "removeClippedSubviews";
    private static final Rect sHelperRect = new Rect();

    public static void calculateClippingRect(View view, Rect outputRect) {
        ReactClippingViewGroup clippingViewGroup;
        ViewParent parent = view.getParent();
        if (parent == null) {
            outputRect.setEmpty();
            return;
        }
        if (parent instanceof ReactClippingViewGroup && (clippingViewGroup = (ReactClippingViewGroup)parent).getRemoveClippedSubviews()) {
            clippingViewGroup.getClippingRect(sHelperRect);
            if (!sHelperRect.intersect(view.getLeft(), view.getTop() + (int)view.getTranslationY(), view.getRight(), view.getBottom() + (int)view.getTranslationY())) {
                outputRect.setEmpty();
                return;
            }
            sHelperRect.offset(-view.getLeft(), -view.getTop());
            sHelperRect.offset(-((int)view.getTranslationX()), -((int)view.getTranslationY()));
            sHelperRect.offset(view.getScrollX(), view.getScrollY());
            outputRect.set(sHelperRect);
            return;
        }
        view.getDrawingRect(outputRect);
    }
}

