/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.fbreact.specs.NativeLogBoxSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.SurfaceDelegate;
import com.facebook.react.devsupport.LogBoxDialogSurfaceDelegate;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;

@ReactModule(name="LogBox")
public class LogBoxModule
extends NativeLogBoxSpec {
    public static final String NAME = "LogBox";
    private final DevSupportManager mDevSupportManager;
    private final SurfaceDelegate mSurfaceDelegate;

    public LogBoxModule(ReactApplicationContext reactContext, DevSupportManager devSupportManager) {
        super(reactContext);
        this.mDevSupportManager = devSupportManager;
        SurfaceDelegate surfaceDelegate = devSupportManager.createSurfaceDelegate(NAME);
        this.mSurfaceDelegate = surfaceDelegate != null ? surfaceDelegate : new LogBoxDialogSurfaceDelegate(devSupportManager);
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                LogBoxModule.this.mSurfaceDelegate.createContentView(LogBoxModule.NAME);
            }
        });
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void show() {
        if (!this.mSurfaceDelegate.isContentViewReady()) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                LogBoxModule.this.mSurfaceDelegate.show();
            }
        });
    }

    @Override
    public void hide() {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                LogBoxModule.this.mSurfaceDelegate.hide();
            }
        });
    }

    @Override
    public void invalidate() {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                LogBoxModule.this.mSurfaceDelegate.destroyContentView();
            }
        });
    }
}

