/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.SensorManager;
import android.util.Pair;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.bridge.DefaultJSExceptionHandler;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.DebugServerException;
import com.facebook.react.common.ShakeDetector;
import com.facebook.react.common.SurfaceDelegate;
import com.facebook.react.common.SurfaceDelegateFactory;
import com.facebook.react.devsupport.BundleDownloader;
import com.facebook.react.devsupport.DebugOverlayController;
import com.facebook.react.devsupport.DevInternalSettings;
import com.facebook.react.devsupport.DevLoadingViewController;
import com.facebook.react.devsupport.DevServerHelper;
import com.facebook.react.devsupport.DevSettingsActivity;
import com.facebook.react.devsupport.HMRClient;
import com.facebook.react.devsupport.InspectorPackagerConnection;
import com.facebook.react.devsupport.JSCHeapCapture;
import com.facebook.react.devsupport.JSException;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.RedBoxDialogSurfaceDelegate;
import com.facebook.react.devsupport.StackTraceHelper;
import com.facebook.react.devsupport.interfaces.BundleLoadCallback;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevOptionHandler;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.ErrorCustomizer;
import com.facebook.react.devsupport.interfaces.ErrorType;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import com.facebook.react.devsupport.interfaces.StackFrame;
import com.facebook.react.modules.core.RCTNativeAppEventEmitter;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.packagerconnection.Responder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class DevSupportManagerBase
implements DevSupportManager {
    private static final int JAVA_ERROR_COOKIE = -1;
    private static final int JSEXCEPTION_ERROR_COOKIE = -1;
    private static final String RELOAD_APP_ACTION_SUFFIX = ".RELOAD_APP_ACTION";
    private static final String FLIPPER_DEBUGGER_URL = "flipper://null/Hermesdebuggerrn?device=React%20Native";
    private static final String FLIPPER_DEVTOOLS_URL = "flipper://null/React?device=React%20Native";
    private static final String EXOPACKAGE_LOCATION_FORMAT = "/data/local/tmp/exopackage/%s//secondary-dex";
    public static final String EMOJI_HUNDRED_POINTS_SYMBOL = " \ud83d\udcaf";
    public static final String EMOJI_FACE_WITH_NO_GOOD_GESTURE = " \ud83d\ude45";
    private final Context mApplicationContext;
    private final ShakeDetector mShakeDetector;
    private final BroadcastReceiver mReloadAppBroadcastReceiver;
    private final DevServerHelper mDevServerHelper;
    private final LinkedHashMap<String, DevOptionHandler> mCustomDevOptions = new LinkedHashMap();
    private final ReactInstanceDevHelper mReactInstanceDevHelper;
    @Nullable
    private final String mJSAppBundleName;
    private final File mJSBundleDownloadedFile;
    private final File mJSSplitBundlesDir;
    private final DefaultJSExceptionHandler mDefaultJSExceptionHandler;
    private final DevLoadingViewController mDevLoadingViewController;
    @Nullable
    private SurfaceDelegate mRedBoxSurfaceDelegate;
    @Nullable
    private AlertDialog mDevOptionsDialog;
    @Nullable
    private DebugOverlayController mDebugOverlayController;
    private boolean mDevLoadingViewVisible = false;
    private int mPendingJSSplitBundleRequests = 0;
    @Nullable
    private ReactContext mCurrentContext;
    private DevInternalSettings mDevSettings;
    private boolean mIsReceiverRegistered = false;
    private boolean mIsShakeDetectorStarted = false;
    private boolean mIsDevSupportEnabled = false;
    @Nullable
    private RedBoxHandler mRedBoxHandler;
    @Nullable
    private String mLastErrorTitle;
    @Nullable
    private StackFrame[] mLastErrorStack;
    @Nullable
    private ErrorType mLastErrorType;
    private int mLastErrorCookie = 0;
    @Nullable
    private DevBundleDownloadListener mBundleDownloadListener;
    @Nullable
    private List<ErrorCustomizer> mErrorCustomizers;
    @Nullable
    private DevSupportManager.PackagerLocationCustomizer mPackagerLocationCustomizer;
    private InspectorPackagerConnection.BundleStatus mBundleStatus;
    @Nullable
    private Map<String, RequestHandler> mCustomPackagerCommandHandlers;
    @Nullable
    private Activity currentActivity;
    @Nullable
    private final SurfaceDelegateFactory mSurfaceDelegateFactory;

    public DevSupportManagerBase(Context applicationContext, ReactInstanceDevHelper reactInstanceDevHelper, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, @Nullable RedBoxHandler redBoxHandler, @Nullable DevBundleDownloadListener devBundleDownloadListener, int minNumShakes, @Nullable Map<String, RequestHandler> customPackagerCommandHandlers, @Nullable SurfaceDelegateFactory surfaceDelegateFactory) {
        this.mReactInstanceDevHelper = reactInstanceDevHelper;
        this.mApplicationContext = applicationContext;
        this.mJSAppBundleName = packagerPathForJSBundleName;
        this.mDevSettings = new DevInternalSettings(applicationContext, new DevInternalSettings.Listener(){

            @Override
            public void onInternalSettingsChanged() {
                DevSupportManagerBase.this.reloadSettings();
            }
        });
        this.mBundleStatus = new InspectorPackagerConnection.BundleStatus();
        this.mDevServerHelper = new DevServerHelper(this.mDevSettings, this.mApplicationContext.getPackageName(), new InspectorPackagerConnection.BundleStatusProvider(){

            @Override
            public InspectorPackagerConnection.BundleStatus getBundleStatus() {
                return DevSupportManagerBase.this.mBundleStatus;
            }
        });
        this.mBundleDownloadListener = devBundleDownloadListener;
        this.mShakeDetector = new ShakeDetector(new ShakeDetector.ShakeListener(){

            @Override
            public void onShake() {
                DevSupportManagerBase.this.showDevOptionsDialog();
            }
        }, minNumShakes);
        this.mCustomPackagerCommandHandlers = customPackagerCommandHandlers;
        this.mReloadAppBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (DevSupportManagerBase.getReloadAppAction(context).equals(action)) {
                    if (intent.getBooleanExtra("jsproxy", false)) {
                        DevSupportManagerBase.this.mDevSettings.setRemoteJSDebugEnabled(true);
                        DevSupportManagerBase.this.mDevServerHelper.launchJSDevtools();
                    } else {
                        DevSupportManagerBase.this.mDevSettings.setRemoteJSDebugEnabled(false);
                    }
                    DevSupportManagerBase.this.handleReloadJS();
                }
            }
        };
        String subclassTag = this.getUniqueTag();
        String bundleFile = subclassTag + "ReactNativeDevBundle.js";
        this.mJSBundleDownloadedFile = new File(applicationContext.getFilesDir(), bundleFile);
        String splitBundlesDir = subclassTag.toLowerCase(Locale.ROOT) + "_dev_js_split_bundles";
        this.mJSSplitBundlesDir = this.mApplicationContext.getDir(splitBundlesDir, 0);
        this.mDefaultJSExceptionHandler = new DefaultJSExceptionHandler();
        this.setDevSupportEnabled(enableOnCreate);
        this.mRedBoxHandler = redBoxHandler;
        this.mDevLoadingViewController = new DevLoadingViewController(reactInstanceDevHelper);
        this.mSurfaceDelegateFactory = surfaceDelegateFactory;
    }

    protected abstract String getUniqueTag();

    @Override
    public void handleException(Exception e) {
        if (this.mIsDevSupportEnabled) {
            this.logJSException(e);
        } else {
            this.mDefaultJSExceptionHandler.handleException(e);
        }
    }

    private void logJSException(Exception e) {
        StringBuilder message = new StringBuilder(e.getMessage() == null ? "Exception in native call from JS" : e.getMessage());
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            message.append("\n\n").append(cause.getMessage());
        }
        if (e instanceof JSException) {
            FLog.e((String)"ReactNative", (String)"Exception in native call from JS", (Throwable)e);
            String stack = ((JSException)e).getStack();
            message.append("\n\n").append(stack);
            this.showNewError(message.toString(), new StackFrame[0], -1, ErrorType.JS);
        } else {
            this.showNewJavaError(message.toString(), e);
        }
    }

    @Override
    public void showNewJavaError(@Nullable String message, Throwable e) {
        FLog.e((String)"ReactNative", (String)"Exception in native call", (Throwable)e);
        this.showNewError(message, StackTraceHelper.convertJavaStackTrace(e), -1, ErrorType.NATIVE);
    }

    @Override
    public void addCustomDevOption(String optionName, DevOptionHandler optionHandler) {
        this.mCustomDevOptions.put(optionName, optionHandler);
    }

    @Override
    public void showNewJSError(String message, ReadableArray details, int errorCookie) {
        this.showNewError(message, StackTraceHelper.convertJsStackTrace(details), errorCookie, ErrorType.JS);
    }

    @Override
    public void registerErrorCustomizer(ErrorCustomizer errorCustomizer) {
        if (this.mErrorCustomizers == null) {
            this.mErrorCustomizers = new ArrayList<ErrorCustomizer>();
        }
        this.mErrorCustomizers.add(errorCustomizer);
    }

    @Override
    public Pair<String, StackFrame[]> processErrorCustomizers(Pair<String, StackFrame[]> errorInfo) {
        if (this.mErrorCustomizers == null) {
            return errorInfo;
        }
        for (ErrorCustomizer errorCustomizer : this.mErrorCustomizers) {
            Pair<String, StackFrame[]> result = errorCustomizer.customizeErrorInfo(errorInfo);
            if (result == null) continue;
            errorInfo = result;
        }
        return errorInfo;
    }

    @Override
    public void updateJSError(final String message, final ReadableArray details, final int errorCookie) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!DevSupportManagerBase.this.mRedBoxSurfaceDelegate.isShowing() || errorCookie != DevSupportManagerBase.this.mLastErrorCookie) {
                    return;
                }
                DevSupportManagerBase.this.updateLastErrorInfo(message, StackTraceHelper.convertJsStackTrace(details), errorCookie, ErrorType.JS);
                DevSupportManagerBase.this.mRedBoxSurfaceDelegate.show();
            }
        });
    }

    @Override
    public void hideRedboxDialog() {
        if (this.mRedBoxSurfaceDelegate == null) {
            return;
        }
        this.mRedBoxSurfaceDelegate.hide();
    }

    @Override
    @Nullable
    public View createRootView(String appKey) {
        return this.mReactInstanceDevHelper.createRootView(appKey);
    }

    @Override
    public void destroyRootView(View rootView) {
        this.mReactInstanceDevHelper.destroyRootView(rootView);
    }

    private void hideDevOptionsDialog() {
        if (this.mDevOptionsDialog != null) {
            this.mDevOptionsDialog.dismiss();
            this.mDevOptionsDialog = null;
        }
    }

    private void showNewError(final @Nullable String message, final StackFrame[] stack, final int errorCookie, final ErrorType errorType) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerBase.this.updateLastErrorInfo(message, stack, errorCookie, errorType);
                if (DevSupportManagerBase.this.mRedBoxSurfaceDelegate == null) {
                    SurfaceDelegate redBoxSurfaceDelegate = DevSupportManagerBase.this.createSurfaceDelegate("RedBox");
                    if (redBoxSurfaceDelegate != null) {
                        DevSupportManagerBase.this.mRedBoxSurfaceDelegate = redBoxSurfaceDelegate;
                    } else {
                        DevSupportManagerBase.this.mRedBoxSurfaceDelegate = new RedBoxDialogSurfaceDelegate(DevSupportManagerBase.this);
                    }
                    DevSupportManagerBase.this.mRedBoxSurfaceDelegate.createContentView("RedBox");
                }
                if (DevSupportManagerBase.this.mRedBoxSurfaceDelegate.isShowing()) {
                    return;
                }
                DevSupportManagerBase.this.mRedBoxSurfaceDelegate.show();
            }
        });
    }

    @Override
    public void showDevOptionsDialog() {
        if (this.mDevOptionsDialog != null || !this.mIsDevSupportEnabled || ActivityManager.isUserAMonkey()) {
            return;
        }
        LinkedHashMap<String, DevOptionHandler> options = new LinkedHashMap<String, DevOptionHandler>();
        options.put(this.mApplicationContext.getString(R.string.catalyst_reload), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                if (!DevSupportManagerBase.this.mDevSettings.isJSDevModeEnabled() && DevSupportManagerBase.this.mDevSettings.isHotModuleReplacementEnabled()) {
                    Toast.makeText((Context)DevSupportManagerBase.this.mApplicationContext, (CharSequence)DevSupportManagerBase.this.mApplicationContext.getString(R.string.catalyst_hot_reloading_auto_disable), (int)1).show();
                    DevSupportManagerBase.this.mDevSettings.setHotModuleReplacementEnabled(false);
                }
                DevSupportManagerBase.this.handleReloadJS();
            }
        });
        if (this.mDevSettings.isDeviceDebugEnabled()) {
            if (this.mDevSettings.isRemoteJSDebugEnabled()) {
                this.mDevSettings.setRemoteJSDebugEnabled(false);
                this.handleReloadJS();
            }
            options.put(this.mApplicationContext.getString(R.string.catalyst_debug_open), new DevOptionHandler(){

                @Override
                public void onOptionSelected() {
                    DevSupportManagerBase.this.mDevServerHelper.openUrl(DevSupportManagerBase.this.mCurrentContext, DevSupportManagerBase.FLIPPER_DEBUGGER_URL, DevSupportManagerBase.this.mApplicationContext.getString(R.string.catalyst_open_flipper_error));
                }
            });
            options.put(this.mApplicationContext.getString(R.string.catalyst_devtools_open), new DevOptionHandler(){

                @Override
                public void onOptionSelected() {
                    DevSupportManagerBase.this.mDevServerHelper.openUrl(DevSupportManagerBase.this.mCurrentContext, DevSupportManagerBase.FLIPPER_DEVTOOLS_URL, DevSupportManagerBase.this.mApplicationContext.getString(R.string.catalyst_open_flipper_error));
                }
            });
        }
        options.put(this.mApplicationContext.getString(R.string.catalyst_change_bundle_location), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                Activity context = DevSupportManagerBase.this.mReactInstanceDevHelper.getCurrentActivity();
                if (context == null || context.isFinishing()) {
                    FLog.e((String)"ReactNative", (String)"Unable to launch change bundle location because react activity is not available");
                    return;
                }
                final EditText input = new EditText((Context)context);
                input.setHint((CharSequence)"localhost:8081");
                AlertDialog bundleLocationDialog = new AlertDialog.Builder((Context)context).setTitle((CharSequence)DevSupportManagerBase.this.mApplicationContext.getString(R.string.catalyst_change_bundle_location)).setView((View)input).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        String host = input.getText().toString();
                        DevSupportManagerBase.this.mDevSettings.getPackagerConnectionSettings().setDebugServerHost(host);
                        DevSupportManagerBase.this.handleReloadJS();
                    }
                }).create();
                bundleLocationDialog.show();
            }
        });
        options.put(this.mDevSettings.isElementInspectorEnabled() ? this.mApplicationContext.getString(R.string.catalyst_inspector_stop) : this.mApplicationContext.getString(R.string.catalyst_inspector), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerBase.this.mDevSettings.setElementInspectorEnabled(!DevSupportManagerBase.this.mDevSettings.isElementInspectorEnabled());
                DevSupportManagerBase.this.mReactInstanceDevHelper.toggleElementInspector();
            }
        });
        options.put(this.mDevSettings.isHotModuleReplacementEnabled() ? this.mApplicationContext.getString(R.string.catalyst_hot_reloading_stop) : this.mApplicationContext.getString(R.string.catalyst_hot_reloading), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                boolean nextEnabled = !DevSupportManagerBase.this.mDevSettings.isHotModuleReplacementEnabled();
                DevSupportManagerBase.this.mDevSettings.setHotModuleReplacementEnabled(nextEnabled);
                if (DevSupportManagerBase.this.mCurrentContext != null) {
                    if (nextEnabled) {
                        DevSupportManagerBase.this.mCurrentContext.getJSModule(HMRClient.class).enable();
                    } else {
                        DevSupportManagerBase.this.mCurrentContext.getJSModule(HMRClient.class).disable();
                    }
                }
                if (nextEnabled && !DevSupportManagerBase.this.mDevSettings.isJSDevModeEnabled()) {
                    Toast.makeText((Context)DevSupportManagerBase.this.mApplicationContext, (CharSequence)DevSupportManagerBase.this.mApplicationContext.getString(R.string.catalyst_hot_reloading_auto_enable), (int)1).show();
                    DevSupportManagerBase.this.mDevSettings.setJSDevModeEnabled(true);
                    DevSupportManagerBase.this.handleReloadJS();
                }
            }
        });
        options.put(this.mDevSettings.isFpsDebugEnabled() ? this.mApplicationContext.getString(R.string.catalyst_perf_monitor_stop) : this.mApplicationContext.getString(R.string.catalyst_perf_monitor), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                if (!DevSupportManagerBase.this.mDevSettings.isFpsDebugEnabled()) {
                    Activity context = DevSupportManagerBase.this.mReactInstanceDevHelper.getCurrentActivity();
                    if (context == null) {
                        FLog.e((String)"ReactNative", (String)"Unable to get reference to react activity");
                    } else {
                        DebugOverlayController.requestPermission((Context)context);
                    }
                }
                DevSupportManagerBase.this.mDevSettings.setFpsDebugEnabled(!DevSupportManagerBase.this.mDevSettings.isFpsDebugEnabled());
            }
        });
        options.put(this.mApplicationContext.getString(R.string.catalyst_settings), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                Intent intent = new Intent(DevSupportManagerBase.this.mApplicationContext, DevSettingsActivity.class);
                intent.setFlags(0x10000000);
                DevSupportManagerBase.this.mApplicationContext.startActivity(intent);
            }
        });
        if (this.mCustomDevOptions.size() > 0) {
            options.putAll(this.mCustomDevOptions);
        }
        final DevOptionHandler[] optionHandlers = options.values().toArray(new DevOptionHandler[0]);
        Activity context = this.mReactInstanceDevHelper.getCurrentActivity();
        if (context == null || context.isFinishing()) {
            FLog.e((String)"ReactNative", (String)"Unable to launch dev options menu because react activity isn't available");
            return;
        }
        TextView textView = new TextView(this.getApplicationContext());
        textView.setText((CharSequence)("React Native DevMenu (" + this.getUniqueTag() + ")"));
        textView.setPadding(0, 50, 0, 0);
        textView.setGravity(17);
        textView.setTextColor(-16777216);
        textView.setTextSize(17.0f);
        textView.setTypeface(textView.getTypeface(), 1);
        this.mDevOptionsDialog = new AlertDialog.Builder((Context)context).setCustomTitle((View)textView).setItems((CharSequence[])options.keySet().toArray(new String[0]), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                optionHandlers[which].onOptionSelected();
                DevSupportManagerBase.this.mDevOptionsDialog = null;
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                DevSupportManagerBase.this.mDevOptionsDialog = null;
            }
        }).create();
        this.mDevOptionsDialog.show();
        if (this.mCurrentContext != null) {
            this.mCurrentContext.getJSModule(RCTNativeAppEventEmitter.class).emit("RCTDevMenuShown", null);
        }
    }

    @Override
    public void setDevSupportEnabled(boolean isDevSupportEnabled) {
        this.mIsDevSupportEnabled = isDevSupportEnabled;
        this.reloadSettings();
    }

    @Override
    public boolean getDevSupportEnabled() {
        return this.mIsDevSupportEnabled;
    }

    @Override
    public DevInternalSettings getDevSettings() {
        return this.mDevSettings;
    }

    @Override
    public RedBoxHandler getRedBoxHandler() {
        return this.mRedBoxHandler;
    }

    @Override
    public void onNewReactContextCreated(ReactContext reactContext) {
        this.resetCurrentContext(reactContext);
    }

    @Override
    public void onReactInstanceDestroyed(ReactContext reactContext) {
        if (reactContext == this.mCurrentContext) {
            this.resetCurrentContext(null);
        }
    }

    @Override
    public String getSourceMapUrl() {
        if (this.mJSAppBundleName == null) {
            return "";
        }
        return this.mDevServerHelper.getSourceMapUrl((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getSourceUrl() {
        if (this.mJSAppBundleName == null) {
            return "";
        }
        return this.mDevServerHelper.getSourceUrl((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getJSBundleURLForRemoteDebugging() {
        return this.mDevServerHelper.getJSBundleURLForRemoteDebugging((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getDownloadedJSBundleFile() {
        return this.mJSBundleDownloadedFile.getAbsolutePath();
    }

    @Override
    public boolean hasUpToDateJSBundleInCache() {
        if (this.mIsDevSupportEnabled && this.mJSBundleDownloadedFile.exists()) {
            try {
                String packageName = this.mApplicationContext.getPackageName();
                PackageInfo thisPackage = this.mApplicationContext.getPackageManager().getPackageInfo(packageName, 0);
                if (this.mJSBundleDownloadedFile.lastModified() > thisPackage.lastUpdateTime) {
                    File exopackageDir = new File(String.format(Locale.US, EXOPACKAGE_LOCATION_FORMAT, packageName));
                    if (exopackageDir.exists()) {
                        return this.mJSBundleDownloadedFile.lastModified() > exopackageDir.lastModified();
                    }
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                FLog.e((String)"ReactNative", (String)"DevSupport is unable to get current app info");
            }
        }
        return false;
    }

    private void resetCurrentContext(@Nullable ReactContext reactContext) {
        if (this.mCurrentContext == reactContext) {
            return;
        }
        this.mCurrentContext = reactContext;
        if (this.mDebugOverlayController != null) {
            this.mDebugOverlayController.setFpsDebugViewVisible(false);
        }
        if (reactContext != null) {
            this.mDebugOverlayController = new DebugOverlayController(reactContext);
        }
        if (this.mCurrentContext != null) {
            try {
                URL sourceUrl = new URL(this.getSourceUrl());
                String path = sourceUrl.getPath().substring(1);
                String host = sourceUrl.getHost();
                int port = sourceUrl.getPort() != -1 ? sourceUrl.getPort() : sourceUrl.getDefaultPort();
                this.mCurrentContext.getJSModule(HMRClient.class).setup("android", path, host, port, this.mDevSettings.isHotModuleReplacementEnabled());
            }
            catch (MalformedURLException e) {
                this.showNewJavaError(e.getMessage(), e);
            }
        }
        this.reloadSettings();
    }

    @Override
    public void reloadSettings() {
        if (UiThreadUtil.isOnUiThread()) {
            this.reload();
        } else {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DevSupportManagerBase.this.reload();
                }
            });
        }
    }

    @Nullable
    protected ReactContext getCurrentContext() {
        return this.mCurrentContext;
    }

    @Nullable
    protected String getJSAppBundleName() {
        return this.mJSAppBundleName;
    }

    protected Context getApplicationContext() {
        return this.mApplicationContext;
    }

    protected DevServerHelper getDevServerHelper() {
        return this.mDevServerHelper;
    }

    protected ReactInstanceDevHelper getReactInstanceDevHelper() {
        return this.mReactInstanceDevHelper;
    }

    @UiThread
    private void showDevLoadingViewForUrl(String bundleUrl) {
        this.mDevLoadingViewController.showForUrl(bundleUrl);
        this.mDevLoadingViewVisible = true;
    }

    @UiThread
    protected void showDevLoadingViewForRemoteJSEnabled() {
        this.mDevLoadingViewController.showForRemoteJSEnabled();
        this.mDevLoadingViewVisible = true;
    }

    @UiThread
    protected void hideDevLoadingView() {
        this.mDevLoadingViewController.hide();
        this.mDevLoadingViewVisible = false;
    }

    public void fetchSplitBundleAndCreateBundleLoader(String bundlePath, final CallbackWithBundleLoader callback) {
        final String bundleUrl = this.mDevServerHelper.getDevServerSplitBundleURL(bundlePath);
        final File bundleFile = new File(this.mJSSplitBundlesDir, bundlePath.replaceAll("/", "_") + ".jsbundle");
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerBase.this.showSplitBundleDevLoadingView(bundleUrl);
                DevSupportManagerBase.this.mDevServerHelper.downloadBundleFromURL(new DevBundleDownloadListener(){

                    @Override
                    public void onSuccess() {
                        UiThreadUtil.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                DevSupportManagerBase.this.hideSplitBundleDevLoadingView();
                            }
                        });
                        ReactContext context = DevSupportManagerBase.this.mCurrentContext;
                        if (context == null || !context.hasActiveReactInstance()) {
                            return;
                        }
                        JSBundleLoader bundleLoader = JSBundleLoader.createCachedSplitBundleFromNetworkLoader(bundleUrl, bundleFile.getAbsolutePath());
                        callback.onSuccess(bundleLoader);
                    }

                    @Override
                    public void onProgress(@Nullable String status, @Nullable Integer done, @Nullable Integer total) {
                        DevSupportManagerBase.this.mDevLoadingViewController.updateProgress(status, done, total);
                    }

                    @Override
                    public void onFailure(Exception cause) {
                        UiThreadUtil.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                DevSupportManagerBase.this.hideSplitBundleDevLoadingView();
                            }
                        });
                        callback.onError(bundleUrl, cause);
                    }
                }, bundleFile, bundleUrl, null);
            }
        });
    }

    @UiThread
    private void showSplitBundleDevLoadingView(String bundleUrl) {
        this.showDevLoadingViewForUrl(bundleUrl);
        ++this.mPendingJSSplitBundleRequests;
    }

    @UiThread
    private void hideSplitBundleDevLoadingView() {
        if (--this.mPendingJSSplitBundleRequests == 0) {
            this.hideDevLoadingView();
        }
    }

    @Override
    public void isPackagerRunning(final PackagerStatusCallback callback) {
        Runnable checkPackagerRunning = new Runnable(){

            @Override
            public void run() {
                DevSupportManagerBase.this.mDevServerHelper.isPackagerRunning(callback);
            }
        };
        if (this.mPackagerLocationCustomizer != null) {
            this.mPackagerLocationCustomizer.run(checkPackagerRunning);
        } else {
            checkPackagerRunning.run();
        }
    }

    @Override
    @Nullable
    public File downloadBundleResourceFromUrlSync(String resourceURL, File outputFile) {
        return this.mDevServerHelper.downloadBundleResourceFromUrlSync(resourceURL, outputFile);
    }

    @Override
    @Nullable
    public String getLastErrorTitle() {
        return this.mLastErrorTitle;
    }

    @Override
    @Nullable
    public StackFrame[] getLastErrorStack() {
        return this.mLastErrorStack;
    }

    @Override
    public int getLastErrorCookie() {
        return this.mLastErrorCookie;
    }

    @Override
    @Nullable
    public ErrorType getLastErrorType() {
        return this.mLastErrorType;
    }

    private void handleCaptureHeap(final Responder responder) {
        if (this.mCurrentContext == null) {
            return;
        }
        JSCHeapCapture heapCapture = this.mCurrentContext.getNativeModule(JSCHeapCapture.class);
        if (heapCapture != null) {
            heapCapture.captureHeap(this.mApplicationContext.getCacheDir().getPath(), new JSCHeapCapture.CaptureCallback(){

                @Override
                public void onSuccess(File capture) {
                    responder.respond(capture.toString());
                }

                @Override
                public void onFailure(JSCHeapCapture.CaptureException error) {
                    responder.error(error.toString());
                }
            });
        }
    }

    private void updateLastErrorInfo(@Nullable String message, StackFrame[] stack, int errorCookie, ErrorType errorType) {
        this.mLastErrorTitle = message;
        this.mLastErrorStack = stack;
        this.mLastErrorCookie = errorCookie;
        this.mLastErrorType = errorType;
    }

    @Override
    public void reloadJSFromServer(String bundleURL) {
        this.reloadJSFromServer(bundleURL, new BundleLoadCallback(){

            @Override
            public void onSuccess() {
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DevSupportManagerBase.this.mReactInstanceDevHelper.onJSBundleLoadedFromServer();
                    }
                });
            }
        });
    }

    @Override
    public void reloadJSFromServer(String bundleURL, final BundleLoadCallback callback) {
        ReactMarker.logMarker(ReactMarkerConstants.DOWNLOAD_START);
        this.showDevLoadingViewForUrl(bundleURL);
        final BundleDownloader.BundleInfo bundleInfo = new BundleDownloader.BundleInfo();
        this.mDevServerHelper.downloadBundleFromURL(new DevBundleDownloadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess() {
                DevSupportManagerBase.this.hideDevLoadingView();
                DevSupportManagerBase devSupportManagerBase = DevSupportManagerBase.this;
                synchronized (devSupportManagerBase) {
                    ((DevSupportManagerBase)DevSupportManagerBase.this).mBundleStatus.isLastDownloadSucess = true;
                    ((DevSupportManagerBase)DevSupportManagerBase.this).mBundleStatus.updateTimestamp = System.currentTimeMillis();
                }
                if (DevSupportManagerBase.this.mBundleDownloadListener != null) {
                    DevSupportManagerBase.this.mBundleDownloadListener.onSuccess();
                }
                ReactMarker.logMarker(ReactMarkerConstants.DOWNLOAD_END, bundleInfo.toJSONString());
                callback.onSuccess();
            }

            @Override
            public void onProgress(@Nullable String status, @Nullable Integer done, @Nullable Integer total) {
                DevSupportManagerBase.this.mDevLoadingViewController.updateProgress(status, done, total);
                if (DevSupportManagerBase.this.mBundleDownloadListener != null) {
                    DevSupportManagerBase.this.mBundleDownloadListener.onProgress(status, done, total);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Exception cause) {
                DevSupportManagerBase.this.hideDevLoadingView();
                DevSupportManagerBase devSupportManagerBase = DevSupportManagerBase.this;
                synchronized (devSupportManagerBase) {
                    ((DevSupportManagerBase)DevSupportManagerBase.this).mBundleStatus.isLastDownloadSucess = false;
                }
                if (DevSupportManagerBase.this.mBundleDownloadListener != null) {
                    DevSupportManagerBase.this.mBundleDownloadListener.onFailure(cause);
                }
                FLog.e((String)"ReactNative", (String)"Unable to download JS bundle", (Throwable)cause);
                DevSupportManagerBase.this.reportBundleLoadingFailure(cause);
            }
        }, this.mJSBundleDownloadedFile, bundleURL, bundleInfo);
    }

    private void reportBundleLoadingFailure(final Exception cause) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (cause instanceof DebugServerException) {
                    DebugServerException debugServerException = (DebugServerException)cause;
                    DevSupportManagerBase.this.showNewJavaError(debugServerException.getMessage(), cause);
                } else {
                    DevSupportManagerBase.this.showNewJavaError(DevSupportManagerBase.this.mApplicationContext.getString(R.string.catalyst_reload_error), cause);
                }
            }
        });
    }

    @Override
    public void startInspector() {
        if (this.mIsDevSupportEnabled) {
            this.mDevServerHelper.openInspectorConnection();
        }
    }

    @Override
    public void stopInspector() {
        this.mDevServerHelper.closeInspectorConnection();
    }

    @Override
    public void setHotModuleReplacementEnabled(final boolean isHotModuleReplacementEnabled) {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerBase.this.mDevSettings.setHotModuleReplacementEnabled(isHotModuleReplacementEnabled);
                DevSupportManagerBase.this.handleReloadJS();
            }
        });
    }

    @Override
    public void setRemoteJSDebugEnabled(final boolean isRemoteJSDebugEnabled) {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerBase.this.mDevSettings.setRemoteJSDebugEnabled(isRemoteJSDebugEnabled);
                DevSupportManagerBase.this.handleReloadJS();
            }
        });
    }

    @Override
    public void setFpsDebugEnabled(final boolean isFpsDebugEnabled) {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerBase.this.mDevSettings.setFpsDebugEnabled(isFpsDebugEnabled);
            }
        });
    }

    @Override
    public void toggleElementInspector() {
        if (!this.mIsDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DevSupportManagerBase.this.mDevSettings.setElementInspectorEnabled(!DevSupportManagerBase.this.mDevSettings.isElementInspectorEnabled());
                DevSupportManagerBase.this.mReactInstanceDevHelper.toggleElementInspector();
            }
        });
    }

    private void reload() {
        UiThreadUtil.assertOnUiThread();
        if (this.mIsDevSupportEnabled) {
            if (this.mDebugOverlayController != null) {
                this.mDebugOverlayController.setFpsDebugViewVisible(this.mDevSettings.isFpsDebugEnabled());
            }
            if (!this.mIsShakeDetectorStarted) {
                this.mShakeDetector.start((SensorManager)this.mApplicationContext.getSystemService("sensor"));
                this.mIsShakeDetectorStarted = true;
            }
            if (!this.mIsReceiverRegistered) {
                IntentFilter filter = new IntentFilter();
                filter.addAction(DevSupportManagerBase.getReloadAppAction(this.mApplicationContext));
                this.mApplicationContext.registerReceiver(this.mReloadAppBroadcastReceiver, filter);
                this.mIsReceiverRegistered = true;
            }
            if (this.mDevLoadingViewVisible) {
                this.mDevLoadingViewController.showMessage("Reloading...");
            }
            this.mDevServerHelper.openPackagerConnection(this.getClass().getSimpleName(), new DevServerHelper.PackagerCommandListener(){

                @Override
                public void onPackagerConnected() {
                }

                @Override
                public void onPackagerDisconnected() {
                }

                @Override
                public void onPackagerReloadCommand() {
                    DevSupportManagerBase.this.mDevServerHelper.disableDebugger();
                    UiThreadUtil.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            DevSupportManagerBase.this.handleReloadJS();
                        }
                    });
                }

                @Override
                public void onPackagerDevMenuCommand() {
                    UiThreadUtil.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            DevSupportManagerBase.this.showDevOptionsDialog();
                        }
                    });
                }

                @Override
                public void onCaptureHeapCommand(final Responder responder) {
                    UiThreadUtil.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            DevSupportManagerBase.this.handleCaptureHeap(responder);
                        }
                    });
                }

                @Override
                @Nullable
                public Map<String, RequestHandler> customCommandHandlers() {
                    return DevSupportManagerBase.this.mCustomPackagerCommandHandlers;
                }
            });
        } else {
            if (this.mDebugOverlayController != null) {
                this.mDebugOverlayController.setFpsDebugViewVisible(false);
            }
            if (this.mIsShakeDetectorStarted) {
                this.mShakeDetector.stop();
                this.mIsShakeDetectorStarted = false;
            }
            if (this.mIsReceiverRegistered) {
                this.mApplicationContext.unregisterReceiver(this.mReloadAppBroadcastReceiver);
                this.mIsReceiverRegistered = false;
            }
            this.hideRedboxDialog();
            this.hideDevOptionsDialog();
            this.mDevLoadingViewController.hide();
            this.mDevServerHelper.closePackagerConnection();
        }
    }

    private static String getReloadAppAction(Context context) {
        return context.getPackageName() + RELOAD_APP_ACTION_SUFFIX;
    }

    @Override
    public void setPackagerLocationCustomizer(DevSupportManager.PackagerLocationCustomizer packagerLocationCustomizer) {
        this.mPackagerLocationCustomizer = packagerLocationCustomizer;
    }

    @Override
    @Nullable
    public Activity getCurrentActivity() {
        return this.mReactInstanceDevHelper.getCurrentActivity();
    }

    @Override
    @Nullable
    public SurfaceDelegate createSurfaceDelegate(String moduleName) {
        if (this.mSurfaceDelegateFactory == null) {
            return null;
        }
        return this.mSurfaceDelegateFactory.createSurfaceDelegate(moduleName);
    }

    public static interface CallbackWithBundleLoader {
        public void onSuccess(JSBundleLoader var1);

        public void onError(String var1, Throwable var2);
    }
}

