/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.defaults;

import android.app.Application;
import com.facebook.react.JSEngineResolutionAlgorithm;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.bridge.JSIModulePackage;
import com.facebook.react.defaults.DefaultJSIModulePackage;
import com.facebook.react.defaults.DefaultTurboModuleManagerDelegate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/defaults/DefaultReactNativeHost;", "Lcom/facebook/react/ReactNativeHost;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "isHermesEnabled", "", "()Ljava/lang/Boolean;", "isNewArchEnabled", "()Z", "getJSEngineResolutionAlgorithm", "Lcom/facebook/react/JSEngineResolutionAlgorithm;", "getJSIModulePackage", "Lcom/facebook/react/bridge/JSIModulePackage;", "getReactPackageTurboModuleManagerDelegateBuilder", "Lcom/facebook/react/ReactPackageTurboModuleManagerDelegate$Builder;", "ReactAndroid_debug"})
public abstract class DefaultReactNativeHost
extends ReactNativeHost {
    protected DefaultReactNativeHost(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
    }

    @Override
    @Nullable
    protected ReactPackageTurboModuleManagerDelegate.Builder getReactPackageTurboModuleManagerDelegateBuilder() {
        return this.isNewArchEnabled() ? (ReactPackageTurboModuleManagerDelegate.Builder)new DefaultTurboModuleManagerDelegate.Builder() : (ReactPackageTurboModuleManagerDelegate.Builder)null;
    }

    @Override
    @Nullable
    protected JSIModulePackage getJSIModulePackage() {
        return this.isNewArchEnabled() ? (JSIModulePackage)new DefaultJSIModulePackage(this) : (JSIModulePackage)null;
    }

    @Override
    @Nullable
    protected JSEngineResolutionAlgorithm getJSEngineResolutionAlgorithm() {
        JSEngineResolutionAlgorithm jSEngineResolutionAlgorithm;
        Boolean bl = this.isHermesEnabled();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            jSEngineResolutionAlgorithm = JSEngineResolutionAlgorithm.HERMES;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            jSEngineResolutionAlgorithm = JSEngineResolutionAlgorithm.JSC;
        } else if (bl == null) {
            jSEngineResolutionAlgorithm = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jSEngineResolutionAlgorithm;
    }

    protected boolean isNewArchEnabled() {
        return false;
    }

    @Nullable
    protected Boolean isHermesEnabled() {
        return null;
    }
}

