/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromMap;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.NoSuchKeyException;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.UnexpectedNativeTypeException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@DoNotStrip
public class ReadableNativeMap
extends NativeMap
implements ReadableMap {
    @Nullable
    private String[] mKeys;
    @Nullable
    private HashMap<String, Object> mLocalMap;
    @Nullable
    private HashMap<String, ReadableType> mLocalTypeMap;
    private static int mJniCallCounter;

    protected ReadableNativeMap(HybridData hybridData) {
        super(hybridData);
    }

    public static int getJNIPassCounter() {
        return mJniCallCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, Object> getLocalMap() {
        if (this.mLocalMap != null) {
            return this.mLocalMap;
        }
        ReadableNativeMap readableNativeMap = this;
        synchronized (readableNativeMap) {
            if (this.mKeys == null) {
                this.mKeys = (String[])Assertions.assertNotNull((Object)this.importKeys());
                ++mJniCallCounter;
            }
            if (this.mLocalMap == null) {
                Object[] values = (Object[])Assertions.assertNotNull((Object)this.importValues());
                ++mJniCallCounter;
                int length = this.mKeys.length;
                this.mLocalMap = new HashMap(length);
                for (int i = 0; i < length; ++i) {
                    this.mLocalMap.put(this.mKeys[i], values[i]);
                }
            }
        }
        return this.mLocalMap;
    }

    private native String[] importKeys();

    private native Object[] importValues();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private HashMap<String, ReadableType> getLocalTypeMap() {
        if (this.mLocalTypeMap != null) {
            return this.mLocalTypeMap;
        }
        ReadableNativeMap readableNativeMap = this;
        synchronized (readableNativeMap) {
            if (this.mKeys == null) {
                this.mKeys = (String[])Assertions.assertNotNull((Object)this.importKeys());
                ++mJniCallCounter;
            }
            if (this.mLocalTypeMap == null) {
                Object[] types = (Object[])Assertions.assertNotNull((Object)this.importTypes());
                ++mJniCallCounter;
                int length = this.mKeys.length;
                this.mLocalTypeMap = new HashMap(length);
                for (int i = 0; i < length; ++i) {
                    this.mLocalTypeMap.put(this.mKeys[i], (ReadableType)((Object)types[i]));
                }
            }
        }
        return this.mLocalTypeMap;
    }

    private native Object[] importTypes();

    @Override
    public boolean hasKey(@NonNull String name) {
        return this.getLocalMap().containsKey(name);
    }

    @Override
    public boolean isNull(@NonNull String name) {
        if (this.getLocalMap().containsKey(name)) {
            return this.getLocalMap().get(name) == null;
        }
        throw new NoSuchKeyException(name);
    }

    @NonNull
    private Object getValue(@NonNull String name) {
        if (this.hasKey(name) && !this.isNull(name)) {
            return Assertions.assertNotNull((Object)this.getLocalMap().get(name));
        }
        throw new NoSuchKeyException(name);
    }

    private <T> T getValue(String name, Class<T> type) {
        Object value = this.getValue(name);
        this.checkInstance(name, value, type);
        return (T)value;
    }

    @Nullable
    private Object getNullableValue(String name) {
        if (this.hasKey(name)) {
            return this.getLocalMap().get(name);
        }
        return null;
    }

    @Nullable
    private <T> T getNullableValue(String name, Class<T> type) {
        Object value = this.getNullableValue(name);
        this.checkInstance(name, value, type);
        return (T)value;
    }

    private void checkInstance(String name, Object value, Class type) {
        if (value != null && !type.isInstance(value)) {
            throw new UnexpectedNativeTypeException("Value for " + name + " cannot be cast from " + value.getClass().getSimpleName() + " to " + type.getSimpleName());
        }
    }

    @Override
    public boolean getBoolean(@NonNull String name) {
        return this.getValue(name, Boolean.class);
    }

    @Override
    public double getDouble(@NonNull String name) {
        return this.getValue(name, Double.class);
    }

    @Override
    public int getInt(@NonNull String name) {
        return this.getValue(name, Double.class).intValue();
    }

    @Override
    @Nullable
    public String getString(@NonNull String name) {
        return this.getNullableValue(name, String.class);
    }

    @Override
    @Nullable
    public ReadableArray getArray(@NonNull String name) {
        return this.getNullableValue(name, ReadableArray.class);
    }

    @Override
    @Nullable
    public ReadableNativeMap getMap(@NonNull String name) {
        return this.getNullableValue(name, ReadableNativeMap.class);
    }

    @Override
    @NonNull
    public ReadableType getType(@NonNull String name) {
        if (this.getLocalTypeMap().containsKey(name)) {
            return (ReadableType)((Object)Assertions.assertNotNull((Object)((Object)this.getLocalTypeMap().get(name))));
        }
        throw new NoSuchKeyException(name);
    }

    @Override
    @NonNull
    public Dynamic getDynamic(@NonNull String name) {
        return DynamicFromMap.create(this, name);
    }

    @Override
    @NonNull
    public Iterator<Map.Entry<String, Object>> getEntryIterator() {
        if (this.mKeys == null) {
            this.mKeys = (String[])Assertions.assertNotNull((Object)this.importKeys());
        }
        final String[] iteratorKeys = this.mKeys;
        final Object[] iteratorValues = (Object[])Assertions.assertNotNull((Object)this.importValues());
        return new Iterator<Map.Entry<String, Object>>(){
            int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < iteratorKeys.length;
            }

            @Override
            public Map.Entry<String, Object> next() {
                final int index = this.currentIndex++;
                return new Map.Entry<String, Object>(){

                    @Override
                    public String getKey() {
                        return iteratorKeys[index];
                    }

                    @Override
                    public Object getValue() {
                        return iteratorValues[index];
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException("Can't set a value while iterating over a ReadableNativeMap");
                    }
                };
            }
        };
    }

    @Override
    @NonNull
    public ReadableMapKeySetIterator keySetIterator() {
        if (this.mKeys == null) {
            this.mKeys = (String[])Assertions.assertNotNull((Object)this.importKeys());
        }
        final String[] iteratorKeys = this.mKeys;
        return new ReadableMapKeySetIterator(){
            int currentIndex = 0;

            @Override
            public boolean hasNextKey() {
                return this.currentIndex < iteratorKeys.length;
            }

            @Override
            public String nextKey() {
                return iteratorKeys[this.currentIndex++];
            }
        };
    }

    public int hashCode() {
        return this.getLocalMap().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReadableNativeMap)) {
            return false;
        }
        ReadableNativeMap other = (ReadableNativeMap)obj;
        return this.getLocalMap().equals(other.getLocalMap());
    }

    @Override
    @NonNull
    public HashMap<String, Object> toHashMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.getLocalMap());
        block5: for (String key : hashMap.keySet()) {
            switch (this.getType(key)) {
                case Null: 
                case Boolean: 
                case Number: 
                case String: {
                    continue block5;
                }
                case Map: {
                    hashMap.put(key, ((ReadableNativeMap)Assertions.assertNotNull((Object)this.getMap(key))).toHashMap());
                    continue block5;
                }
                case Array: {
                    hashMap.put(key, ((ReadableArray)Assertions.assertNotNull((Object)this.getArray(key))).toArrayList());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Could not convert object with key: " + key + ".");
        }
        return hashMap;
    }

    static {
        ReactBridge.staticInit();
    }

    private static class ReadableNativeMapKeySetIterator
    implements ReadableMapKeySetIterator {
        private final Iterator<String> mIterator;

        public ReadableNativeMapKeySetIterator(ReadableNativeMap readableNativeMap) {
            this.mIterator = readableNativeMap.getLocalMap().keySet().iterator();
        }

        @Override
        public boolean hasNextKey() {
            return this.mIterator.hasNext();
        }

        @Override
        public String nextKey() {
            return this.mIterator.next();
        }
    }
}

