/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.infer.annotation.Assertions;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.CxxModuleWrapper;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.systrace.SystraceMessage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Provider;

@DoNotStrip
public class ModuleHolder {
    private static final AtomicInteger sInstanceKeyCounter = new AtomicInteger(1);
    private final int mInstanceKey = sInstanceKeyCounter.getAndIncrement();
    private final String mName;
    private final ReactModuleInfo mReactModuleInfo;
    @Nullable
    private Provider<? extends NativeModule> mProvider;
    @Nullable
    @GuardedBy(value="this")
    private NativeModule mModule;
    @GuardedBy(value="this")
    private boolean mInitializable;
    @GuardedBy(value="this")
    private boolean mIsCreating;
    @GuardedBy(value="this")
    private boolean mIsInitializing;

    public ModuleHolder(ReactModuleInfo moduleInfo, Provider<? extends NativeModule> provider) {
        this.mName = moduleInfo.name();
        this.mProvider = provider;
        this.mReactModuleInfo = moduleInfo;
        if (moduleInfo.needsEagerInit()) {
            this.mModule = this.create();
        }
    }

    public ModuleHolder(NativeModule nativeModule) {
        this.mName = nativeModule.getName();
        this.mReactModuleInfo = new ReactModuleInfo(nativeModule.getName(), nativeModule.getClass().getSimpleName(), nativeModule.canOverrideExistingModule(), true, true, CxxModuleWrapper.class.isAssignableFrom(nativeModule.getClass()), TurboModule.class.isAssignableFrom(nativeModule.getClass()));
        this.mModule = nativeModule;
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.NATIVE_MODULE, "NativeModule init: %s", this.mName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markInitializable() {
        boolean shouldInitializeNow = false;
        NativeModule module = null;
        ModuleHolder moduleHolder = this;
        synchronized (moduleHolder) {
            this.mInitializable = true;
            if (this.mModule != null) {
                Assertions.assertCondition((!this.mIsInitializing ? 1 : 0) != 0);
                shouldInitializeNow = true;
                module = this.mModule;
            }
        }
        if (shouldInitializeNow) {
            this.doInitialize(module);
        }
    }

    synchronized boolean hasInstance() {
        return this.mModule != null;
    }

    public synchronized void destroy() {
        if (this.mModule != null) {
            this.mModule.invalidate();
        }
    }

    @DoNotStrip
    public String getName() {
        return this.mName;
    }

    public boolean getCanOverrideExistingModule() {
        return this.mReactModuleInfo.canOverrideExistingModule();
    }

    public boolean getHasConstants() {
        return this.mReactModuleInfo.hasConstants();
    }

    public boolean isTurboModule() {
        return this.mReactModuleInfo.isTurboModule();
    }

    public boolean isCxxModule() {
        return this.mReactModuleInfo.isCxxModule();
    }

    public String getClassName() {
        return this.mReactModuleInfo.className();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public NativeModule getModule() {
        boolean shouldCreate = false;
        ModuleHolder moduleHolder = this;
        synchronized (moduleHolder) {
            if (this.mModule != null) {
                return this.mModule;
            }
            if (!this.mIsCreating) {
                shouldCreate = true;
                this.mIsCreating = true;
            }
        }
        if (shouldCreate) {
            NativeModule module = this.create();
            moduleHolder = this;
            synchronized (moduleHolder) {
                this.mIsCreating = false;
                this.notifyAll();
            }
            return module;
        }
        moduleHolder = this;
        synchronized (moduleHolder) {
            while (this.mModule == null && this.mIsCreating) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            return (NativeModule)Assertions.assertNotNull((Object)this.mModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeModule create() {
        NativeModule module;
        SoftAssertions.assertCondition(this.mModule == null, "Creating an already created module.");
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_MODULE_START, this.mName, this.mInstanceKey);
        SystraceMessage.beginSection(0L, "ModuleHolder.createModule").arg("name", this.mName).flush();
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.NATIVE_MODULE, "NativeModule init: %s", this.mName);
        try {
            module = (NativeModule)((Provider)Assertions.assertNotNull(this.mProvider)).get();
            this.mProvider = null;
            boolean shouldInitializeNow = false;
            ModuleHolder moduleHolder = this;
            synchronized (moduleHolder) {
                this.mModule = module;
                if (this.mInitializable && !this.mIsInitializing) {
                    shouldInitializeNow = true;
                }
            }
            if (shouldInitializeNow) {
                this.doInitialize(module);
            }
        }
        catch (Throwable ex) {
            FLog.e((String)"NativeModuleInitError", (String)("Failed to create NativeModule \"" + this.getName() + "\""), (Throwable)ex);
            throw ex;
        }
        finally {
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_MODULE_END, this.mName, this.mInstanceKey);
            SystraceMessage.endSection(0L).flush();
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialize(NativeModule module) {
        block10: {
            SystraceMessage.beginSection(0L, "ModuleHolder.initialize").arg("name", this.mName).flush();
            ReactMarker.logMarker(ReactMarkerConstants.INITIALIZE_MODULE_START, this.mName, this.mInstanceKey);
            try {
                boolean shouldInitialize = false;
                ModuleHolder moduleHolder = this;
                synchronized (moduleHolder) {
                    if (this.mInitializable && !this.mIsInitializing) {
                        shouldInitialize = true;
                        this.mIsInitializing = true;
                    }
                }
                if (!shouldInitialize) break block10;
                module.initialize();
                moduleHolder = this;
                synchronized (moduleHolder) {
                    this.mIsInitializing = false;
                }
            }
            finally {
                ReactMarker.logMarker(ReactMarkerConstants.INITIALIZE_MODULE_END, this.mName, this.mInstanceKey);
                SystraceMessage.endSection(0L).flush();
            }
        }
    }
}

