/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.switchview;

import android.content.Context;
import android.os.SystemClock;
import android.view.View;
import android.widget.CompoundButton;
import com.facebook.csslayout.CSSNode;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.views.switchview.ReactSwitch;
import com.facebook.react.views.switchview.ReactSwitchEvent;

public class ReactSwitchManager
extends SimpleViewManager<ReactSwitch> {
    private static final String REACT_CLASS = "AndroidSwitch";
    private static final CompoundButton.OnCheckedChangeListener ON_CHECKED_CHANGE_LISTENER = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            ReactContext reactContext = (ReactContext)buttonView.getContext();
            reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new ReactSwitchEvent(buttonView.getId(), SystemClock.uptimeMillis(), isChecked));
        }
    };

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public LayoutShadowNode createShadowNodeInstance() {
        return new ReactSwitchShadowNode();
    }

    @Override
    public Class getShadowNodeClass() {
        return ReactSwitchShadowNode.class;
    }

    @Override
    protected ReactSwitch createViewInstance(ThemedReactContext context) {
        ReactSwitch view = new ReactSwitch((Context)context);
        view.setShowText(false);
        return view;
    }

    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(ReactSwitch view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @ReactProp(name="on")
    public void setOn(ReactSwitch view, boolean on) {
        view.setOnCheckedChangeListener(null);
        view.setOn(on);
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactSwitch view) {
        view.setOnCheckedChangeListener(ON_CHECKED_CHANGE_LISTENER);
    }

    private static class ReactSwitchShadowNode
    extends LayoutShadowNode
    implements CSSNode.MeasureFunction {
        private int mWidth;
        private int mHeight;
        private boolean mMeasured;

        private ReactSwitchShadowNode() {
            this.setMeasureFunction(this);
        }

        @Override
        public void measure(CSSNode node, float width, float height, MeasureOutput measureOutput) {
            if (!this.mMeasured) {
                ReactSwitch reactSwitch = new ReactSwitch((Context)this.getThemedContext());
                int spec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
                reactSwitch.measure(spec, spec);
                this.mWidth = reactSwitch.getMeasuredWidth();
                this.mHeight = reactSwitch.getMeasuredHeight();
                this.mMeasured = true;
            }
            measureOutput.width = this.mWidth;
            measureOutput.height = this.mHeight;
        }
    }
}

