/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.scroll.OnScrollDispatchHelper;
import com.facebook.react.views.scroll.ReactScrollViewHelper;

public class ReactHorizontalScrollView
extends HorizontalScrollView {
    private final OnScrollDispatchHelper mOnScrollDispatchHelper = new OnScrollDispatchHelper();
    private boolean mSendMomentumEvents;
    private boolean mDragging;
    private boolean mFlinging;
    private boolean mDoneFlinging;

    public ReactHorizontalScrollView(Context context) {
        super(context);
    }

    public void setSendMomentumEvents(boolean sendMomentumEvents) {
        this.mSendMomentumEvents = sendMomentumEvents;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.scrollTo(this.getScrollX(), this.getScrollY());
    }

    protected void onScrollChanged(int x, int y, int oldX, int oldY) {
        super.onScrollChanged(x, y, oldX, oldY);
        if (this.mOnScrollDispatchHelper.onScrollChanged(x, y)) {
            if (this.mFlinging) {
                this.mDoneFlinging = false;
            }
            ReactScrollViewHelper.emitScrollEvent((ViewGroup)this);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
            ReactScrollViewHelper.emitScrollBeginDragEvent((ViewGroup)this);
            this.mDragging = true;
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 1 && this.mDragging) {
            ReactScrollViewHelper.emitScrollEndDragEvent((ViewGroup)this);
            this.mDragging = false;
        }
        return super.onTouchEvent(ev);
    }

    public void fling(int velocityX) {
        super.fling(velocityX);
        if (this.mSendMomentumEvents) {
            this.mFlinging = true;
            ReactScrollViewHelper.emitScrollMomentumBeginEvent((ViewGroup)this);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (ReactHorizontalScrollView.this.mDoneFlinging) {
                        ReactHorizontalScrollView.this.mFlinging = false;
                        ReactScrollViewHelper.emitScrollMomentumEndEvent((ViewGroup)ReactHorizontalScrollView.this);
                    } else {
                        ReactHorizontalScrollView.this.mDoneFlinging = true;
                        ReactHorizontalScrollView.this.postOnAnimationDelayed(this, 20L);
                    }
                }
            };
            this.postOnAnimationDelayed(r, 20L);
        }
    }
}

