/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.content.Context;
import com.facebook.react.bridge.ReactBridge;

public abstract class JSBundleLoader {
    public static JSBundleLoader createFileLoader(final Context context, final String fileName) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(ReactBridge bridge) {
                if (fileName.startsWith("assets://")) {
                    bridge.loadScriptFromAssets(context.getAssets(), fileName.replaceFirst("assets://", ""));
                } else {
                    bridge.loadScriptFromFile(fileName, fileName);
                }
            }

            @Override
            public String getSourceUrl() {
                return fileName;
            }
        };
    }

    public static JSBundleLoader createCachedBundleFromNetworkLoader(final String sourceURL, final String cachedFileLocation) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(ReactBridge bridge) {
                bridge.loadScriptFromFile(cachedFileLocation, sourceURL);
            }

            @Override
            public String getSourceUrl() {
                return sourceURL;
            }
        };
    }

    public static JSBundleLoader createRemoteDebuggerBundleLoader(final String proxySourceURL, final String realSourceURL) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(ReactBridge bridge) {
                bridge.loadScriptFromFile(null, proxySourceURL);
            }

            @Override
            public String getSourceUrl() {
                return realSourceURL;
            }
        };
    }

    public abstract void loadScript(ReactBridge var1);

    public abstract String getSourceUrl();
}

