/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import com.facebook.common.logging.FLog;
import com.facebook.react.LifecycleState;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactRootView;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import java.util.List;
import javax.annotation.Nullable;

public abstract class ReactActivity
extends Activity
implements DefaultHardwareBackBtnHandler {
    private static final String REDBOX_PERMISSION_MESSAGE = "Overlay permissions needs to be granted in order for react native apps to run in dev mode";
    @Nullable
    private ReactInstanceManager mReactInstanceManager;
    private LifecycleState mLifecycleState = LifecycleState.BEFORE_RESUME;
    private boolean mDoRefresh = false;

    @Nullable
    protected String getBundleAssetName() {
        return "index.android.bundle";
    }

    @Nullable
    protected String getJSBundleFile() {
        return null;
    }

    protected String getJSMainModuleName() {
        return "index.android";
    }

    protected abstract String getMainComponentName();

    protected abstract boolean getUseDeveloperSupport();

    protected abstract List<ReactPackage> getPackages();

    protected ReactInstanceManager createReactInstanceManager() {
        ReactInstanceManager.Builder builder = ReactInstanceManager.builder().setApplication(this.getApplication()).setJSMainModuleName(this.getJSMainModuleName()).setUseDeveloperSupport(this.getUseDeveloperSupport()).setInitialLifecycleState(this.mLifecycleState);
        for (ReactPackage reactPackage : this.getPackages()) {
            builder.addPackage(reactPackage);
        }
        String jsBundleFile = this.getJSBundleFile();
        if (jsBundleFile != null) {
            builder.setJSBundleFile(jsBundleFile);
        } else {
            builder.setBundleAssetName(this.getBundleAssetName());
        }
        return builder.build();
    }

    protected ReactRootView createRootView() {
        return new ReactRootView((Context)this);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getUseDeveloperSupport() && Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)this)) {
            Intent serviceIntent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
            this.startActivity(serviceIntent);
            FLog.w((String)"React", (String)REDBOX_PERMISSION_MESSAGE);
            Toast.makeText((Context)this, (CharSequence)REDBOX_PERMISSION_MESSAGE, (int)1).show();
        }
        this.mReactInstanceManager = this.createReactInstanceManager();
        ReactRootView mReactRootView = this.createRootView();
        mReactRootView.startReactApplication(this.mReactInstanceManager, this.getMainComponentName());
        this.setContentView((View)mReactRootView);
    }

    protected void onPause() {
        super.onPause();
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
        if (this.mReactInstanceManager != null) {
            this.mReactInstanceManager.onPause();
        }
    }

    protected void onResume() {
        super.onResume();
        this.mLifecycleState = LifecycleState.RESUMED;
        if (this.mReactInstanceManager != null) {
            this.mReactInstanceManager.onResume(this, this);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mReactInstanceManager != null) {
            this.mReactInstanceManager.onDestroy();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.mReactInstanceManager != null) {
            this.mReactInstanceManager.onActivityResult(requestCode, resultCode, data);
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mReactInstanceManager != null && this.mReactInstanceManager.getDevSupportManager().getDevSupportEnabled()) {
            if (keyCode == 82) {
                this.mReactInstanceManager.showDevOptionsDialog();
                return true;
            }
            if (keyCode == 46 && !(this.getCurrentFocus() instanceof EditText)) {
                if (this.mDoRefresh) {
                    this.mReactInstanceManager.getDevSupportManager().handleReloadJS();
                    this.mDoRefresh = false;
                } else {
                    this.mDoRefresh = true;
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ReactActivity.this.mDoRefresh = false;
                        }
                    }, 200L);
                }
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public void onBackPressed() {
        if (this.mReactInstanceManager != null) {
            this.mReactInstanceManager.onBackPressed();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    public void invokeDefaultOnBackPressed() {
        super.onBackPressed();
    }
}

