/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.text.Spannable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.facebook.csslayout.CSSNode;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.csslayout.Spacing;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.views.text.ReactTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import javax.annotation.Nullable;

@VisibleForTesting
public class ReactTextInputShadowNode
extends ReactTextShadowNode
implements CSSNode.MeasureFunction {
    private static final int MEASURE_SPEC = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
    @Nullable
    private EditText mEditText;
    @Nullable
    private float[] mComputedPadding;
    private int mJsEventCount = -1;

    public ReactTextInputShadowNode() {
        super(false);
        this.setMeasureFunction(this);
    }

    @Override
    protected void setThemedContext(ThemedReactContext themedContext) {
        super.setThemedContext(themedContext);
        this.mEditText = new EditText((Context)this.getThemedContext());
        this.mEditText.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.setDefaultPadding(0, this.mEditText.getPaddingLeft());
        this.setDefaultPadding(1, this.mEditText.getPaddingTop());
        this.setDefaultPadding(2, this.mEditText.getPaddingRight());
        this.setDefaultPadding(3, this.mEditText.getPaddingBottom());
        this.mComputedPadding = ReactTextInputShadowNode.spacingToFloatArray(this.getPadding());
    }

    @Override
    public void measure(CSSNode node, float width, MeasureOutput measureOutput) {
        EditText editText = (EditText)Assertions.assertNotNull((Object)this.mEditText);
        measureOutput.width = width;
        editText.setTextSize(0, this.mFontSize == -1 ? (float)((int)Math.ceil(PixelUtil.toPixelFromSP(14.0f))) : (float)this.mFontSize);
        this.mComputedPadding = ReactTextInputShadowNode.spacingToFloatArray(this.getPadding());
        editText.setPadding((int)Math.ceil(this.getPadding().get(0)), (int)Math.ceil(this.getPadding().get(1)), (int)Math.ceil(this.getPadding().get(2)), (int)Math.ceil(this.getPadding().get(3)));
        if (this.mNumberOfLines != -1) {
            editText.setLines(this.mNumberOfLines);
        }
        editText.measure(MEASURE_SPEC, MEASURE_SPEC);
        measureOutput.height = editText.getMeasuredHeight();
    }

    @Override
    public void onBeforeLayout() {
    }

    @ReactProp(name="mostRecentEventCount")
    public void setMostRecentEventCount(int mostRecentEventCount) {
        this.mJsEventCount = mostRecentEventCount;
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mComputedPadding != null) {
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), this.mComputedPadding);
            this.mComputedPadding = null;
        }
        if (this.mJsEventCount != -1) {
            Spannable preparedSpannableText = ReactTextInputShadowNode.fromTextCSSNode(this);
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(preparedSpannableText, this.mJsEventCount, this.mContainsImages);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        super.setPadding(spacingType, padding);
        this.mComputedPadding = ReactTextInputShadowNode.spacingToFloatArray(this.getPadding());
        this.markUpdated();
    }

    private static float[] spacingToFloatArray(Spacing spacing) {
        return new float[]{spacing.get(0), spacing.get(1), spacing.get(2), spacing.get(3)};
    }
}

