/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.views.scroll.ReactScrollView;
import com.facebook.react.views.scroll.ReactScrollViewCommandHelper;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactScrollViewManager
extends ViewGroupManager<ReactScrollView>
implements ReactScrollViewCommandHelper.ScrollCommandHandler<ReactScrollView> {
    private static final String REACT_CLASS = "RCTScrollView";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactScrollView createViewInstance(ThemedReactContext context) {
        return new ReactScrollView((Context)context);
    }

    @ReactProp(name="showsVerticalScrollIndicator")
    public void setShowsVerticalScrollIndicator(ReactScrollView view, boolean value) {
        view.setVerticalScrollBarEnabled(value);
    }

    @ReactProp(name="removeClippedSubviews")
    public void setRemoveClippedSubviews(ReactScrollView view, boolean removeClippedSubviews) {
        view.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return ReactScrollViewCommandHelper.getCommandsMap();
    }

    @Override
    public void receiveCommand(ReactScrollView scrollView, int commandId, @Nullable ReadableArray args) {
        ReactScrollViewCommandHelper.receiveCommand(this, scrollView, commandId, args);
    }

    @Override
    public void scrollTo(ReactScrollView scrollView, ReactScrollViewCommandHelper.ScrollToCommandData data) {
        scrollView.smoothScrollTo(data.mDestX, data.mDestY);
    }

    @Override
    public void scrollWithoutAnimationTo(ReactScrollView scrollView, ReactScrollViewCommandHelper.ScrollToCommandData data) {
        scrollView.scrollTo(data.mDestX, data.mDestY);
    }

    @Override
    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return ReactScrollViewManager.createExportedCustomDirectEventTypeConstants();
    }

    public static Map createExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put("topScroll", MapBuilder.of("registrationName", "onScroll")).put("topScrollBeginDrag", MapBuilder.of("registrationName", "onScrollBeginDrag")).put("topScrollEndDrag", MapBuilder.of("registrationName", "onScrollEndDrag")).put("topScrollAnimationEnd", MapBuilder.of("registrationName", "onScrollAnimationEnd")).put("topMomentumScrollBegin", MapBuilder.of("registrationName", "onMomentumScrollBegin")).put("topMomentumScrollEnd", MapBuilder.of("registrationName", "onMomentumScrollEnd")).build();
    }
}

