/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.graphics.PorterDuff;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.textinput.ReactEditText;
import com.facebook.react.views.textinput.ReactTextChangedEvent;
import com.facebook.react.views.textinput.ReactTextInputBlurEvent;
import com.facebook.react.views.textinput.ReactTextInputEndEditingEvent;
import com.facebook.react.views.textinput.ReactTextInputEvent;
import com.facebook.react.views.textinput.ReactTextInputFocusEvent;
import com.facebook.react.views.textinput.ReactTextInputShadowNode;
import com.facebook.react.views.textinput.ReactTextInputSubmitEditingEvent;
import com.facebook.react.views.textinput.ReactTextUpdate;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactTextInputManager
extends BaseViewManager<ReactEditText, ReactTextInputShadowNode> {
    static final String REACT_CLASS = "AndroidTextInput";
    private static final int FOCUS_TEXT_INPUT = 1;
    private static final int BLUR_TEXT_INPUT = 2;
    private static final String KEYBOARD_TYPE_EMAIL_ADDRESS = "email-address";
    private static final String KEYBOARD_TYPE_NUMERIC = "numeric";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactEditText createViewInstance(ThemedReactContext context) {
        ReactEditText editText = new ReactEditText((Context)context);
        int inputType = editText.getInputType();
        editText.setInputType(inputType & 0xFFFDFFFF);
        editText.setImeOptions(6);
        editText.setTextSize(0, (int)Math.ceil(PixelUtil.toPixelFromSP(14.0f)));
        return editText;
    }

    @Override
    public ReactTextInputShadowNode createShadowNodeInstance() {
        return new ReactTextInputShadowNode();
    }

    @Override
    public Class<ReactTextInputShadowNode> getShadowNodeClass() {
        return ReactTextInputShadowNode.class;
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return MapBuilder.builder().put("topSubmitEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onSubmitEditing", "captured", "onSubmitEditingCapture"))).put("topEndEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onEndEditing", "captured", "onEndEditingCapture"))).put("topTextInput", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTextInput", "captured", "onTextInputCapture"))).put("topFocus", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onFocus", "captured", "onFocusCapture"))).put("topBlur", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onBlur", "captured", "onBlurCapture"))).build();
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("focusTextInput", 1, "blurTextInput", 2);
    }

    @Override
    public void receiveCommand(ReactEditText reactEditText, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                reactEditText.requestFocusFromJS();
                break;
            }
            case 2: {
                reactEditText.clearFocusFromJS();
            }
        }
    }

    @Override
    public void updateExtraData(ReactEditText view, Object extraData) {
        if (extraData instanceof float[]) {
            float[] padding = (float[])extraData;
            view.setPadding((int)Math.ceil(padding[0]), (int)Math.ceil(padding[1]), (int)Math.ceil(padding[2]), (int)Math.ceil(padding[3]));
        } else if (extraData instanceof ReactTextUpdate) {
            view.maybeSetText((ReactTextUpdate)extraData);
        }
    }

    @ReactProp(name="fontSize", defaultFloat=14.0f)
    public void setFontSize(ReactEditText view, float fontSize) {
        view.setTextSize(0, (int)Math.ceil(PixelUtil.toPixelFromSP(fontSize)));
    }

    @ReactProp(name="placeholder")
    public void setPlaceholder(ReactEditText view, @Nullable String placeholder) {
        view.setHint(placeholder);
    }

    @ReactProp(name="placeholderTextColor", customType="Color")
    public void setPlaceholderTextColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setHintTextColor(DefaultStyleValuesUtil.getDefaultTextColorHint(view.getContext()));
        } else {
            view.setHintTextColor(color);
        }
    }

    @ReactProp(name="underlineColorAndroid", customType="Color")
    public void setUnderlineColor(ReactEditText view, @Nullable Integer underlineColor) {
        if (underlineColor == null) {
            view.getBackground().clearColorFilter();
        } else {
            view.getBackground().setColorFilter(underlineColor.intValue(), PorterDuff.Mode.SRC_IN);
        }
    }

    @ReactProp(name="textAlign")
    public void setTextAlign(ReactEditText view, int gravity) {
        view.setGravityHorizontal(gravity);
    }

    @ReactProp(name="textAlignVertical")
    public void setTextAlignVertical(ReactEditText view, int gravity) {
        view.setGravityVertical(gravity);
    }

    @ReactProp(name="editable", defaultBoolean=true)
    public void setEditable(ReactEditText view, boolean editable) {
        view.setEnabled(editable);
    }

    @ReactProp(name="numberOfLines", defaultInt=1)
    public void setNumLines(ReactEditText view, int numLines) {
        view.setLines(numLines);
    }

    @ReactProp(name="autoCorrect")
    public void setAutoCorrect(ReactEditText view, @Nullable Boolean autoCorrect) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, 557056, autoCorrect != null ? (autoCorrect.booleanValue() ? 32768 : 524288) : 0);
    }

    @ReactProp(name="multiline", defaultBoolean=false)
    public void setMultiline(ReactEditText view, boolean multiline) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, multiline ? 0 : 131072, multiline ? 131072 : 0);
    }

    @ReactProp(name="password", defaultBoolean=false)
    public void setPassword(ReactEditText view, boolean password) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, password ? 0 : 128, password ? 128 : 0);
    }

    @ReactProp(name="autoCapitalize", defaultInt=1)
    public void setAutoCapitalize(ReactEditText view, int autoCapitalize) {
        int flagsToSet = 0;
        switch (autoCapitalize) {
            case 1: 
            case 4096: 
            case 8192: 
            case 16384: {
                flagsToSet = autoCapitalize;
                break;
            }
            default: {
                throw new JSApplicationCausedNativeException("Invalid autoCapitalize value: " + autoCapitalize);
            }
        }
        ReactTextInputManager.updateStagedInputTypeFlag(view, 28672, flagsToSet);
    }

    @ReactProp(name="keyboardType")
    public void setKeyboardType(ReactEditText view, @Nullable String keyboardType) {
        int flagsToSet = 0;
        if (KEYBOARD_TYPE_NUMERIC.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 2;
        } else if (KEYBOARD_TYPE_EMAIL_ADDRESS.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 32;
        }
        ReactTextInputManager.updateStagedInputTypeFlag(view, 34, flagsToSet);
    }

    @Override
    protected void onAfterUpdateTransaction(ReactEditText view) {
        super.onAfterUpdateTransaction(view);
        view.commitStagedInputType();
    }

    private static void updateStagedInputTypeFlag(ReactEditText view, int flagsToUnset, int flagsToSet) {
        view.setStagedInputType(view.getStagedInputType() & ~flagsToUnset | flagsToSet);
    }

    @Override
    protected void addEventEmitters(final ThemedReactContext reactContext, final ReactEditText editText) {
        editText.addTextChangedListener(new ReactTextInputTextWatcher(reactContext, editText));
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
                if (hasFocus) {
                    eventDispatcher.dispatchEvent(new ReactTextInputFocusEvent(editText.getId(), SystemClock.uptimeMillis()));
                } else {
                    eventDispatcher.dispatchEvent(new ReactTextInputBlurEvent(editText.getId(), SystemClock.uptimeMillis()));
                    eventDispatcher.dispatchEvent(new ReactTextInputEndEditingEvent(editText.getId(), SystemClock.uptimeMillis(), editText.getText().toString()));
                }
            }
        });
        editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent keyEvent) {
                if ((actionId & 0xFF) > 0 || actionId == 0) {
                    EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
                    eventDispatcher.dispatchEvent(new ReactTextInputSubmitEditingEvent(editText.getId(), SystemClock.uptimeMillis(), editText.getText().toString()));
                }
                return false;
            }
        });
    }

    @Override
    @Nullable
    public Map getExportedViewConstants() {
        return MapBuilder.of("TextAlign", MapBuilder.of("start", 0x800003, "center", 1, "end", 0x800005), "TextAlignVertical", MapBuilder.of("top", 48, "center", 16, "bottom", 80));
    }

    private class ReactTextInputTextWatcher
    implements TextWatcher {
        private EventDispatcher mEventDispatcher;
        private ReactEditText mEditText;
        private String mPreviousText;

        public ReactTextInputTextWatcher(ReactContext reactContext, ReactEditText editText) {
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
            this.mEditText = editText;
            this.mPreviousText = null;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            this.mPreviousText = s.toString();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (count > 0 || before > 0) {
                Assertions.assertNotNull((Object)this.mPreviousText);
                int contentWidth = this.mEditText.getWidth();
                int contentHeight = this.mEditText.getHeight();
                if (this.mEditText.getLayout() != null) {
                    contentWidth = this.mEditText.getCompoundPaddingLeft() + this.mEditText.getLayout().getWidth() + this.mEditText.getCompoundPaddingRight();
                    contentHeight = this.mEditText.getCompoundPaddingTop() + this.mEditText.getLayout().getHeight() + this.mEditText.getCompoundPaddingTop();
                }
                this.mEventDispatcher.dispatchEvent(new ReactTextChangedEvent(this.mEditText.getId(), SystemClock.uptimeMillis(), s.toString(), (int)PixelUtil.toDIPFromPixel(contentWidth), (int)PixelUtil.toDIPFromPixel(contentHeight), this.mEditText.incrementAndGetEventCounter()));
                this.mEventDispatcher.dispatchEvent(new ReactTextInputEvent(this.mEditText.getId(), SystemClock.uptimeMillis(), count > 0 ? s.toString().substring(start, start + count) : "", before > 0 ? this.mPreviousText.substring(start, start + before) : "", start, count > 0 ? start + count - 1 : start + before));
            }
        }

        public void afterTextChanged(Editable s) {
        }
    }
}

