/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class CustomStyleSpan
extends MetricAffectingSpan {
    private static final Map<String, Typeface> sTypefaceCache = new HashMap<String, Typeface>();
    private final int mStyle;
    private final int mWeight;
    @Nullable
    private final String mFontFamily;

    public CustomStyleSpan(int fontStyle, int fontWeight, @Nullable String fontFamily) {
        this.mStyle = fontStyle;
        this.mWeight = fontWeight;
        this.mFontFamily = fontFamily;
    }

    public void updateDrawState(TextPaint ds) {
        CustomStyleSpan.apply((Paint)ds, this.mStyle, this.mWeight, this.mFontFamily);
    }

    public void updateMeasureState(TextPaint paint) {
        CustomStyleSpan.apply((Paint)paint, this.mStyle, this.mWeight, this.mFontFamily);
    }

    public int getStyle() {
        return this.mStyle == -1 ? 0 : this.mStyle;
    }

    public int getWeight() {
        return this.mWeight == -1 ? 0 : this.mWeight;
    }

    @Nullable
    public String getFontFamily() {
        return this.mFontFamily;
    }

    private static void apply(Paint paint, int style2, int weight, @Nullable String family) {
        Typeface typeface = paint.getTypeface();
        int oldStyle = typeface == null ? 0 : typeface.getStyle();
        int want = 0;
        if (weight == 1 || (oldStyle & 1) != 0 && weight == -1) {
            want |= 1;
        }
        if (style2 == 2 || (oldStyle & 2) != 0 && style2 == -1) {
            want |= 2;
        }
        if (family != null) {
            typeface = CustomStyleSpan.getOrCreateTypeface(family, want);
        }
        if (typeface != null) {
            paint.setTypeface(Typeface.create((Typeface)typeface, (int)want));
        } else {
            paint.setTypeface(Typeface.defaultFromStyle((int)want));
        }
    }

    private static Typeface getOrCreateTypeface(String family, int style2) {
        if (sTypefaceCache.get(family) != null) {
            return sTypefaceCache.get(family);
        }
        Typeface typeface = Typeface.create((String)family, (int)style2);
        sTypefaceCache.put(family, typeface);
        return typeface;
    }
}

