/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.net.Uri;
import com.facebook.common.util.UriUtil;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.view.GenericDraweeView;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.request.BasePostprocessor;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.request.Postprocessor;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.views.image.ImageResizeMode;
import javax.annotation.Nullable;

public class ReactImageView
extends GenericDraweeView {
    private static final int REMOTE_IMAGE_FADE_DURATION_MS = 300;
    public static final String TAG = ReactImageView.class.getSimpleName();
    private static final Matrix sMatrix = new Matrix();
    private static final Matrix sInverse = new Matrix();
    @Nullable
    private Uri mUri;
    private int mBorderColor;
    private float mBorderWidth;
    private float mBorderRadius;
    private ScalingUtils.ScaleType mScaleType = ImageResizeMode.defaultValue();
    private boolean mIsDirty;
    private boolean mIsLocalImage;
    private final AbstractDraweeControllerBuilder mDraweeControllerBuilder;
    private final RoundedCornerPostprocessor mRoundedCornerPostprocessor;
    @Nullable
    private final Object mCallerContext;
    @Nullable
    private ControllerListener mControllerListener;
    private int mImageFadeDuration = -1;

    private static GenericDraweeHierarchy buildHierarchy(Context context) {
        return new GenericDraweeHierarchyBuilder(context.getResources()).setRoundingParams(RoundingParams.fromCornersRadius((float)0.0f)).build();
    }

    public ReactImageView(Context context, AbstractDraweeControllerBuilder draweeControllerBuilder, @Nullable Object callerContext) {
        super(context, ReactImageView.buildHierarchy(context));
        this.mDraweeControllerBuilder = draweeControllerBuilder;
        this.mRoundedCornerPostprocessor = new RoundedCornerPostprocessor();
        this.mCallerContext = callerContext;
    }

    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
        this.mIsDirty = true;
    }

    public void setBorderWidth(float borderWidth) {
        this.mBorderWidth = PixelUtil.toPixelFromDIP(borderWidth);
        this.mIsDirty = true;
    }

    public void setBorderRadius(float borderRadius) {
        this.mBorderRadius = PixelUtil.toPixelFromDIP(borderRadius);
        this.mIsDirty = true;
    }

    public void setScaleType(ScalingUtils.ScaleType scaleType) {
        this.mScaleType = scaleType;
        this.mIsDirty = true;
    }

    public void setSource(@Nullable String source) {
        this.mUri = null;
        if (source != null) {
            try {
                this.mUri = Uri.parse((String)source);
                if (this.mUri.getScheme() == null) {
                    this.mUri = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.mUri == null) {
                this.mUri = ReactImageView.getResourceDrawableUri(this.getContext(), source);
                this.mIsLocalImage = true;
            } else {
                this.mIsLocalImage = false;
            }
        }
        this.mIsDirty = true;
    }

    public void maybeUpdateView() {
        if (!this.mIsDirty) {
            return;
        }
        boolean doResize = ReactImageView.shouldResize(this.mUri);
        if (doResize && (this.getWidth() <= 0 || this.getHeight() <= 0)) {
            return;
        }
        GenericDraweeHierarchy hierarchy = (GenericDraweeHierarchy)this.getHierarchy();
        hierarchy.setActualImageScaleType(this.mScaleType);
        boolean usePostprocessorScaling = this.mScaleType != ScalingUtils.ScaleType.CENTER_CROP && this.mScaleType != ScalingUtils.ScaleType.FOCUS_CROP;
        float hierarchyRadius = usePostprocessorScaling ? 0.0f : this.mBorderRadius;
        RoundingParams roundingParams = hierarchy.getRoundingParams();
        roundingParams.setCornersRadius(hierarchyRadius);
        roundingParams.setBorder(this.mBorderColor, this.mBorderWidth);
        hierarchy.setRoundingParams(roundingParams);
        hierarchy.setFadeDuration(this.mImageFadeDuration >= 0 ? this.mImageFadeDuration : (this.mIsLocalImage ? 0 : 300));
        RoundedCornerPostprocessor postprocessor = usePostprocessorScaling ? this.mRoundedCornerPostprocessor : null;
        ResizeOptions resizeOptions = doResize ? new ResizeOptions(this.getWidth(), this.getHeight()) : null;
        ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)this.mUri).setPostprocessor((Postprocessor)postprocessor).setResizeOptions(resizeOptions).build();
        AbstractDraweeController draweeController = this.mDraweeControllerBuilder.reset().setAutoPlayAnimations(true).setCallerContext(this.mCallerContext).setOldController(this.getController()).setImageRequest((Object)imageRequest).setControllerListener(this.mControllerListener).build();
        this.setController((DraweeController)draweeController);
        this.mIsDirty = false;
    }

    public void setControllerListener(ControllerListener controllerListener) {
        this.mControllerListener = controllerListener;
        this.mIsDirty = true;
        this.maybeUpdateView();
    }

    public void setImageFadeDuration(int imageFadeDuration) {
        this.mImageFadeDuration = imageFadeDuration;
        this.mIsDirty = true;
        this.maybeUpdateView();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.maybeUpdateView();
        }
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    private static boolean shouldResize(@Nullable Uri uri) {
        return uri != null && (UriUtil.isLocalContentUri((Uri)uri) || UriUtil.isLocalFileUri((Uri)uri));
    }

    @Nullable
    private static Uri getResourceDrawableUri(Context context, @Nullable String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        name = name.toLowerCase().replace("-", "_");
        int resId = context.getResources().getIdentifier(name, "drawable", context.getPackageName());
        return new Uri.Builder().scheme("res").path(String.valueOf(resId)).build();
    }

    private class RoundedCornerPostprocessor
    extends BasePostprocessor {
        private RoundedCornerPostprocessor() {
        }

        float getRadius(Bitmap source) {
            ScalingUtils.getTransform((Matrix)sMatrix, (Rect)new Rect(0, 0, source.getWidth(), source.getHeight()), (int)source.getWidth(), (int)source.getHeight(), (float)0.0f, (float)0.0f, (ScalingUtils.ScaleType)ReactImageView.this.mScaleType);
            sMatrix.invert(sInverse);
            return sInverse.mapRadius(ReactImageView.this.mBorderRadius);
        }

        public void process(Bitmap output, Bitmap source) {
            output.setHasAlpha(true);
            if (ReactImageView.this.mBorderRadius < 0.01f) {
                super.process(output, source);
                return;
            }
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            Canvas canvas = new Canvas(output);
            float radius = this.getRadius(source);
            canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)source.getWidth(), (float)source.getHeight()), radius, radius, paint);
        }
    }
}

