/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.DisplayMetrics;
import com.facebook.csslayout.CSSLayoutContext;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.animation.Animation;
import com.facebook.react.animation.AnimationRegistry;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.NativeViewHierarchyOptimizer;
import com.facebook.react.uimanager.OnLayoutEvent;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ShadowNodeRegistry;
import com.facebook.react.uimanager.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModuleConstantsHelper;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.debug.NotThreadSafeUiManagerDebugListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class UIManagerModule
extends ReactContextBaseJavaModule
implements OnBatchCompleteListener,
LifecycleEventListener {
    private static final int ROOT_VIEW_TAG_INCREMENT = 10;
    private final NativeViewHierarchyManager mNativeViewHierarchyManager;
    private final EventDispatcher mEventDispatcher;
    private final AnimationRegistry mAnimationRegistry = new AnimationRegistry();
    private final ShadowNodeRegistry mShadowNodeRegistry = new ShadowNodeRegistry();
    private final ViewManagerRegistry mViewManagers;
    private final CSSLayoutContext mLayoutContext = new CSSLayoutContext();
    private final Map<String, Object> mModuleConstants;
    private final UIViewOperationQueue mOperationsQueue;
    private final NativeViewHierarchyOptimizer mNativeViewHierarchyOptimizer;
    private final int[] mMeasureBuffer = new int[4];
    @Nullable
    private NotThreadSafeUiManagerDebugListener mUiManagerDebugListener;
    private int mNextRootViewTag = 1;
    private int mBatchId = 0;

    public UIManagerModule(ReactApplicationContext reactContext, List<ViewManager> viewManagerList) {
        super(reactContext);
        this.mViewManagers = new ViewManagerRegistry(viewManagerList);
        this.mEventDispatcher = new EventDispatcher(reactContext);
        this.mNativeViewHierarchyManager = new NativeViewHierarchyManager(this.mAnimationRegistry, this.mViewManagers);
        this.mOperationsQueue = new UIViewOperationQueue(reactContext, this, this.mNativeViewHierarchyManager, this.mAnimationRegistry);
        this.mNativeViewHierarchyOptimizer = new NativeViewHierarchyOptimizer(this.mOperationsQueue, this.mShadowNodeRegistry);
        DisplayMetrics displayMetrics = reactContext.getResources().getDisplayMetrics();
        DisplayMetricsHolder.setDisplayMetrics(displayMetrics);
        this.mModuleConstants = UIManagerModuleConstantsHelper.createConstants(displayMetrics, viewManagerList);
        reactContext.addLifecycleEventListener(this);
    }

    @Override
    public String getName() {
        return "RKUIManager";
    }

    @Override
    public Map<String, Object> getConstants() {
        return this.mModuleConstants;
    }

    @Override
    public void onHostResume() {
        this.mOperationsQueue.resumeFrameCallback();
    }

    @Override
    public void onHostPause() {
        this.mOperationsQueue.pauseFrameCallback();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        this.mEventDispatcher.onCatalystInstanceDestroyed();
    }

    public int addMeasuredRootView(final SizeMonitoringFrameLayout rootView) {
        final int tag = this.mNextRootViewTag;
        this.mNextRootViewTag += 10;
        final ReactShadowNode rootCSSNode = new ReactShadowNode();
        rootCSSNode.setReactTag(tag);
        final ThemedReactContext themedRootContext = new ThemedReactContext(this.getReactApplicationContext(), rootView.getContext());
        rootCSSNode.setThemedContext(themedRootContext);
        if (rootView.getLayoutParams() != null && rootView.getLayoutParams().width > 0 && rootView.getLayoutParams().height > 0) {
            rootCSSNode.setStyleWidth(rootView.getLayoutParams().width);
            rootCSSNode.setStyleHeight(rootView.getLayoutParams().height);
        } else {
            rootCSSNode.setStyleWidth(rootView.getWidth());
            rootCSSNode.setStyleHeight(rootView.getHeight());
        }
        rootCSSNode.setViewClassName("Root");
        rootView.setOnSizeChangedListener(new SizeMonitoringFrameLayout.OnSizeChangedListener(){

            @Override
            public void onSizeChanged(final int width, final int height, int oldW, int oldH) {
                UIManagerModule.this.getReactApplicationContext().runOnNativeModulesQueueThread(new Runnable(){

                    @Override
                    public void run() {
                        UIManagerModule.this.updateRootNodeSize(rootCSSNode, width, height);
                    }
                });
            }
        });
        this.mShadowNodeRegistry.addRootNode(rootCSSNode);
        if (UiThreadUtil.isOnUiThread()) {
            this.mNativeViewHierarchyManager.addRootView(tag, rootView, themedRootContext);
        } else {
            final Semaphore semaphore = new Semaphore(0);
            this.getReactApplicationContext().runOnUiQueueThread(new Runnable(){

                @Override
                public void run() {
                    UIManagerModule.this.mNativeViewHierarchyManager.addRootView(tag, rootView, themedRootContext);
                    semaphore.release();
                }
            });
            try {
                SoftAssertions.assertCondition(semaphore.tryAcquire(5000L, TimeUnit.MILLISECONDS), "Timed out adding root view");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return tag;
    }

    @ReactMethod
    public void removeRootView(int rootViewTag) {
        this.mShadowNodeRegistry.removeRootNode(rootViewTag);
        this.mOperationsQueue.enqueueRemoveRootView(rootViewTag);
    }

    private void updateRootNodeSize(ReactShadowNode rootCSSNode, int newWidth, int newHeight) {
        this.getReactApplicationContext().assertOnNativeModulesQueueThread();
        rootCSSNode.setStyleWidth(newWidth);
        rootCSSNode.setStyleHeight(newHeight);
        if (this.mOperationsQueue.isEmpty()) {
            this.dispatchViewUpdates(-1);
        }
    }

    @ReactMethod
    public void createView(int tag, String className, int rootViewTag, ReadableMap props) {
        ViewManager viewManager = this.mViewManagers.get(className);
        Object cssNode = viewManager.createShadowNodeInstance();
        ReactShadowNode rootNode = this.mShadowNodeRegistry.getNode(rootViewTag);
        ((ReactShadowNode)cssNode).setReactTag(tag);
        ((ReactShadowNode)cssNode).setViewClassName(className);
        ((ReactShadowNode)cssNode).setRootNode(rootNode);
        ((ReactShadowNode)cssNode).setThemedContext(rootNode.getThemedContext());
        this.mShadowNodeRegistry.addNode((ReactShadowNode)cssNode);
        CatalystStylesDiffMap styles = null;
        if (props != null) {
            styles = new CatalystStylesDiffMap(props);
            ((ReactShadowNode)cssNode).updateProperties(styles);
        }
        if (!((ReactShadowNode)cssNode).isVirtual()) {
            this.mNativeViewHierarchyOptimizer.handleCreateView((ReactShadowNode)cssNode, rootViewTag, styles);
        }
    }

    @ReactMethod
    public void updateView(int tag, String className, ReadableMap props) {
        ViewManager viewManager = this.mViewManagers.get(className);
        if (viewManager == null) {
            throw new IllegalViewOperationException("Got unknown view type: " + className);
        }
        ReactShadowNode cssNode = this.mShadowNodeRegistry.getNode(tag);
        if (cssNode == null) {
            throw new IllegalViewOperationException("Trying to update non-existent view with tag " + tag);
        }
        if (props != null) {
            CatalystStylesDiffMap styles = new CatalystStylesDiffMap(props);
            cssNode.updateProperties(styles);
            if (!cssNode.isVirtual()) {
                this.mNativeViewHierarchyOptimizer.handleUpdateView(cssNode, className, styles);
            }
        }
    }

    @ReactMethod
    public void manageChildren(int viewTag, @Nullable ReadableArray moveFrom, @Nullable ReadableArray moveTo, @Nullable ReadableArray addChildTags, @Nullable ReadableArray addAtIndices, @Nullable ReadableArray removeFrom) {
        int i;
        int i2;
        int numToRemove;
        ReactShadowNode cssNodeToManage = this.mShadowNodeRegistry.getNode(viewTag);
        int numToMove = moveFrom == null ? 0 : moveFrom.size();
        int numToAdd = addChildTags == null ? 0 : addChildTags.size();
        int n = numToRemove = removeFrom == null ? 0 : removeFrom.size();
        if (numToMove != 0 && (moveTo == null || numToMove != moveTo.size())) {
            throw new IllegalViewOperationException("Size of moveFrom != size of moveTo!");
        }
        if (numToAdd != 0 && (addAtIndices == null || numToAdd != addAtIndices.size())) {
            throw new IllegalViewOperationException("Size of addChildTags != size of addAtIndices!");
        }
        ViewAtIndex[] viewsToAdd = new ViewAtIndex[numToMove + numToAdd];
        int[] indicesToRemove = new int[numToMove + numToRemove];
        int[] tagsToRemove = new int[indicesToRemove.length];
        int[] tagsToDelete = new int[numToRemove];
        if (numToMove > 0) {
            Assertions.assertNotNull((Object)moveFrom);
            Assertions.assertNotNull((Object)moveTo);
            for (i2 = 0; i2 < numToMove; ++i2) {
                int moveFromIndex = moveFrom.getInt(i2);
                int tagToMove = cssNodeToManage.getChildAt(moveFromIndex).getReactTag();
                viewsToAdd[i2] = new ViewAtIndex(tagToMove, moveTo.getInt(i2));
                indicesToRemove[i2] = moveFromIndex;
                tagsToRemove[i2] = tagToMove;
            }
        }
        if (numToAdd > 0) {
            Assertions.assertNotNull((Object)addChildTags);
            Assertions.assertNotNull((Object)addAtIndices);
            for (i2 = 0; i2 < numToAdd; ++i2) {
                int viewTagToAdd = addChildTags.getInt(i2);
                int indexToAddAt = addAtIndices.getInt(i2);
                viewsToAdd[numToMove + i2] = new ViewAtIndex(viewTagToAdd, indexToAddAt);
            }
        }
        if (numToRemove > 0) {
            Assertions.assertNotNull((Object)removeFrom);
            for (i2 = 0; i2 < numToRemove; ++i2) {
                int indexToRemove = removeFrom.getInt(i2);
                int tagToRemove = cssNodeToManage.getChildAt(indexToRemove).getReactTag();
                indicesToRemove[numToMove + i2] = indexToRemove;
                tagsToRemove[numToMove + i2] = tagToRemove;
                tagsToDelete[i2] = tagToRemove;
            }
        }
        Arrays.sort(viewsToAdd, ViewAtIndex.COMPARATOR);
        Arrays.sort(indicesToRemove);
        int lastIndexRemoved = -1;
        for (i = indicesToRemove.length - 1; i >= 0; --i) {
            int indexToRemove = indicesToRemove[i];
            if (indexToRemove == lastIndexRemoved) {
                throw new IllegalViewOperationException("Repeated indices in Removal list for view tag: " + viewTag);
            }
            cssNodeToManage.removeChildAt(indicesToRemove[i]);
            lastIndexRemoved = indicesToRemove[i];
        }
        for (i = 0; i < viewsToAdd.length; ++i) {
            ViewAtIndex viewAtIndex = viewsToAdd[i];
            ReactShadowNode cssNodeToAdd = this.mShadowNodeRegistry.getNode(viewAtIndex.mTag);
            if (cssNodeToAdd == null) {
                throw new IllegalViewOperationException("Trying to add unknown view tag: " + viewAtIndex.mTag);
            }
            cssNodeToManage.addChildAt(cssNodeToAdd, viewAtIndex.mIndex);
        }
        if (!cssNodeToManage.isVirtual() && !cssNodeToManage.isVirtualAnchor()) {
            this.mNativeViewHierarchyOptimizer.handleManageChildren(cssNodeToManage, indicesToRemove, tagsToRemove, viewsToAdd, tagsToDelete);
        }
        for (i = 0; i < tagsToDelete.length; ++i) {
            this.removeCSSNode(tagsToDelete[i]);
        }
    }

    private void removeCSSNode(int tag) {
        ReactShadowNode node = this.mShadowNodeRegistry.getNode(tag);
        this.mShadowNodeRegistry.removeNode(tag);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.removeCSSNode(node.getChildAt(i).getReactTag());
        }
    }

    @ReactMethod
    public void replaceExistingNonRootView(int oldTag, int newTag) {
        if (this.mShadowNodeRegistry.isRootNode(oldTag) || this.mShadowNodeRegistry.isRootNode(newTag)) {
            throw new IllegalViewOperationException("Trying to add or replace a root tag!");
        }
        ReactShadowNode oldNode = this.mShadowNodeRegistry.getNode(oldTag);
        if (oldNode == null) {
            throw new IllegalViewOperationException("Trying to replace unknown view tag: " + oldTag);
        }
        ReactShadowNode parent = oldNode.getParent();
        if (parent == null) {
            throw new IllegalViewOperationException("Node is not attached to a parent: " + oldTag);
        }
        int oldIndex = parent.indexOf(oldNode);
        if (oldIndex < 0) {
            throw new IllegalStateException("Didn't find child tag in parent");
        }
        WritableArray tagsToAdd = Arguments.createArray();
        tagsToAdd.pushInt(newTag);
        WritableArray addAtIndices = Arguments.createArray();
        addAtIndices.pushInt(oldIndex);
        WritableArray indicesToRemove = Arguments.createArray();
        indicesToRemove.pushInt(oldIndex);
        this.manageChildren(parent.getReactTag(), null, null, tagsToAdd, addAtIndices, indicesToRemove);
    }

    @ReactMethod
    public void removeSubviewsFromContainerWithID(int containerTag) {
        ReactShadowNode containerNode = this.mShadowNodeRegistry.getNode(containerTag);
        if (containerNode == null) {
            throw new IllegalViewOperationException("Trying to remove subviews of an unknown view tag: " + containerTag);
        }
        WritableArray indicesToRemove = Arguments.createArray();
        for (int childIndex = 0; childIndex < containerNode.getChildCount(); ++childIndex) {
            indicesToRemove.pushInt(childIndex);
        }
        this.manageChildren(containerTag, null, null, null, null, indicesToRemove);
    }

    @ReactMethod
    public void measure(int reactTag, Callback callback) {
        this.mOperationsQueue.enqueueMeasure(reactTag, callback);
    }

    @ReactMethod
    public void measureLayout(int tag, int ancestorTag, Callback errorCallback, Callback successCallback) {
        try {
            this.measureLayout(tag, ancestorTag, this.mMeasureBuffer);
            float relativeX = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[0]);
            float relativeY = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[3]);
            successCallback.invoke(Float.valueOf(relativeX), Float.valueOf(relativeY), Float.valueOf(width), Float.valueOf(height));
        }
        catch (IllegalViewOperationException e) {
            errorCallback.invoke(e.getMessage());
        }
    }

    @ReactMethod
    public void measureLayoutRelativeToParent(int tag, Callback errorCallback, Callback successCallback) {
        try {
            this.measureLayoutRelativeToParent(tag, this.mMeasureBuffer);
            float relativeX = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[0]);
            float relativeY = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[1]);
            float width = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[2]);
            float height = PixelUtil.toDIPFromPixel(this.mMeasureBuffer[3]);
            successCallback.invoke(Float.valueOf(relativeX), Float.valueOf(relativeY), Float.valueOf(width), Float.valueOf(height));
        }
        catch (IllegalViewOperationException e) {
            errorCallback.invoke(e.getMessage());
        }
    }

    private void measureLayout(int tag, int ancestorTag, int[] outputBuffer) {
        ReactShadowNode node = this.mShadowNodeRegistry.getNode(tag);
        ReactShadowNode ancestor = this.mShadowNodeRegistry.getNode(ancestorTag);
        if (node == null || ancestor == null) {
            throw new IllegalViewOperationException("Tag " + (node == null ? tag : ancestorTag) + " does not exist");
        }
        if (node != ancestor) {
            for (ReactShadowNode currentParent = node.getParent(); currentParent != ancestor; currentParent = currentParent.getParent()) {
                if (currentParent != null) continue;
                throw new IllegalViewOperationException("Tag " + ancestorTag + " is not an ancestor of tag " + tag);
            }
        }
        this.measureLayoutRelativeToVerifiedAncestor(node, ancestor, outputBuffer);
    }

    private void measureLayoutRelativeToParent(int tag, int[] outputBuffer) {
        ReactShadowNode node = this.mShadowNodeRegistry.getNode(tag);
        if (node == null) {
            throw new IllegalViewOperationException("No native view for tag " + tag + " exists!");
        }
        ReactShadowNode parent = node.getParent();
        if (parent == null) {
            throw new IllegalViewOperationException("View with tag " + tag + " doesn't have a parent!");
        }
        this.measureLayoutRelativeToVerifiedAncestor(node, parent, outputBuffer);
    }

    private void measureLayoutRelativeToVerifiedAncestor(ReactShadowNode node, ReactShadowNode ancestor, int[] outputBuffer) {
        int offsetX = 0;
        int offsetY = 0;
        if (node != ancestor) {
            offsetX = Math.round(node.getLayoutX());
            offsetY = Math.round(node.getLayoutY());
            for (ReactShadowNode current = node.getParent(); current != ancestor; current = current.getParent()) {
                Assertions.assertNotNull((Object)current);
                this.assertNodeDoesNotNeedCustomLayoutForChildren(current);
                offsetX += Math.round(current.getLayoutX());
                offsetY += Math.round(current.getLayoutY());
            }
            this.assertNodeDoesNotNeedCustomLayoutForChildren(ancestor);
        }
        outputBuffer[0] = offsetX;
        outputBuffer[1] = offsetY;
        outputBuffer[2] = node.getScreenWidth();
        outputBuffer[3] = node.getScreenHeight();
    }

    private void assertNodeDoesNotNeedCustomLayoutForChildren(ReactShadowNode node) {
        ViewManager viewManager = (ViewManager)Assertions.assertNotNull((Object)this.mViewManagers.get(node.getViewClass()));
        if (!(viewManager instanceof ViewGroupManager)) {
            throw new IllegalViewOperationException("Trying to use view " + node.getViewClass() + " as a parent, but its Manager doesn't extends ViewGroupManager");
        }
        ViewGroupManager viewGroupManager = (ViewGroupManager)viewManager;
        if (viewGroupManager != null && viewGroupManager.needsCustomLayoutForChildren()) {
            throw new IllegalViewOperationException("Trying to measure a view using measureLayout/measureLayoutRelativeToParent relative to an ancestor that requires custom layout for it's children (" + node.getViewClass() + "). Use measure instead.");
        }
    }

    @ReactMethod
    public void findSubviewIn(int reactTag, ReadableArray point, Callback callback) {
        this.mOperationsQueue.enqueueFindTargetForTouch(reactTag, Math.round(PixelUtil.toPixelFromDIP(point.getDouble(0))), Math.round(PixelUtil.toPixelFromDIP(point.getDouble(1))), callback);
    }

    public void registerAnimation(Animation animation) {
        this.mOperationsQueue.enqueueRegisterAnimation(animation);
    }

    public void addAnimation(int reactTag, int animationID, Callback onSuccess) {
        this.assertViewExists(reactTag, "addAnimation");
        this.mOperationsQueue.enqueueAddAnimation(reactTag, animationID, onSuccess);
    }

    public void removeAnimation(int reactTag, int animationID) {
        this.assertViewExists(reactTag, "removeAnimation");
        this.mOperationsQueue.enqueueRemoveAnimation(animationID);
    }

    @ReactMethod
    public void setJSResponder(int reactTag, boolean blockNativeResponder) {
        this.assertViewExists(reactTag, "setJSResponder");
        this.mOperationsQueue.enqueueSetJSResponder(reactTag, blockNativeResponder);
    }

    @ReactMethod
    public void clearJSResponder() {
        this.mOperationsQueue.enqueueClearJSResponder();
    }

    @ReactMethod
    public void dispatchViewManagerCommand(int reactTag, int commandId, ReadableArray commandArgs) {
        this.assertViewExists(reactTag, "dispatchViewManagerCommand");
        this.mOperationsQueue.enqueueDispatchCommand(reactTag, commandId, commandArgs);
    }

    @ReactMethod
    public void showPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.assertViewExists(reactTag, "showPopupMenu");
        this.mOperationsQueue.enqueueShowPopupMenu(reactTag, items, error, success);
    }

    @ReactMethod
    public void setMainScrollViewTag(int reactTag) {
    }

    @ReactMethod
    public void configureNextLayoutAnimation(ReadableMap config, Callback successCallback, Callback errorCallback) {
    }

    private void assertViewExists(int reactTag, String operationNameForExceptionMessage) {
        if (this.mShadowNodeRegistry.getNode(reactTag) == null) {
            throw new IllegalViewOperationException("Unable to execute operation " + operationNameForExceptionMessage + " on view with " + "tag: " + reactTag + ", since the view does not exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBatchComplete() {
        int batchId = this.mBatchId++;
        SystraceMessage.beginSection(0L, "onBatchCompleteUI").arg("BatchId", batchId).flush();
        try {
            this.dispatchViewUpdates(batchId);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void setUiManagerDebugListener(@Nullable NotThreadSafeUiManagerDebugListener listener) {
        this.mUiManagerDebugListener = listener;
    }

    public EventDispatcher getEventDispatcher() {
        return this.mEventDispatcher;
    }

    private void dispatchViewUpdates(int batchId) {
        for (int i = 0; i < this.mShadowNodeRegistry.getRootNodeCount(); ++i) {
            int tag = this.mShadowNodeRegistry.getRootTag(i);
            ReactShadowNode cssRoot = this.mShadowNodeRegistry.getNode(tag);
            this.notifyOnBeforeLayoutRecursive(cssRoot);
            cssRoot.calculateLayout(this.mLayoutContext);
            this.applyUpdatesRecursive(cssRoot, 0.0f, 0.0f);
        }
        this.mNativeViewHierarchyOptimizer.onBatchComplete();
        this.mOperationsQueue.dispatchViewUpdates(batchId);
    }

    private void notifyOnBeforeLayoutRecursive(ReactShadowNode cssNode) {
        if (!cssNode.hasUpdates()) {
            return;
        }
        for (int i = 0; i < cssNode.getChildCount(); ++i) {
            this.notifyOnBeforeLayoutRecursive(cssNode.getChildAt(i));
        }
        cssNode.onBeforeLayout();
    }

    private void applyUpdatesRecursive(ReactShadowNode cssNode, float absoluteX, float absoluteY) {
        int tag;
        if (!cssNode.hasUpdates()) {
            return;
        }
        if (!cssNode.isVirtualAnchor()) {
            for (int i = 0; i < cssNode.getChildCount(); ++i) {
                this.applyUpdatesRecursive(cssNode.getChildAt(i), absoluteX + cssNode.getLayoutX(), absoluteY + cssNode.getLayoutY());
            }
        }
        if (!this.mShadowNodeRegistry.isRootNode(tag = cssNode.getReactTag())) {
            cssNode.dispatchUpdates(absoluteX, absoluteY, this.mOperationsQueue, this.mNativeViewHierarchyOptimizer);
            if (cssNode.shouldNotifyOnLayout()) {
                this.mEventDispatcher.dispatchEvent(OnLayoutEvent.obtain(tag, cssNode.getScreenX(), cssNode.getScreenY(), cssNode.getScreenWidth(), cssNode.getScreenHeight()));
            }
        }
        cssNode.markUpdateSeen();
    }

    void notifyOnViewHierarchyUpdateEnqueued() {
        if (this.mUiManagerDebugListener != null) {
            this.mUiManagerDebugListener.onViewHierarchyUpdateEnqueued();
        }
    }

    void notifyOnViewHierarchyUpdateFinished() {
        if (this.mUiManagerDebugListener != null) {
            this.mUiManagerDebugListener.onViewHierarchyUpdateFinished();
        }
    }

    @ReactMethod
    public void sendAccessibilityEvent(int tag, int eventType) {
        this.mOperationsQueue.enqueueSendAccessibilityEvent(tag, eventType);
    }
}

