/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.graphics.Color;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSColorUtil {
    static final Pattern RGB_COLOR_PATTERN = Pattern.compile("rgb\\(\\s*([0-9]{1,3}),\\s*([0-9]{1,3}),\\s*([0-9]{1,3})\\s*\\)");
    static final Pattern RGBA_COLOR_PATTERN = Pattern.compile("rgba\\(\\s*([0-9]{1,3}),\\s*([0-9]{1,3}),\\s*([0-9]{1,3})\\s*,\\s*(0*(\\.\\d{1,3})?|1(\\.0+)?)\\)");
    private static final HashMap<String, Integer> sColorNameMap = new HashMap();

    public static int getColor(String colorString) {
        if (colorString.startsWith("rgb(")) {
            Matcher rgbMatcher = RGB_COLOR_PATTERN.matcher(colorString);
            if (rgbMatcher.matches()) {
                return Color.rgb((int)CSSColorUtil.validateColorComponent(Integer.parseInt(rgbMatcher.group(1))), (int)CSSColorUtil.validateColorComponent(Integer.parseInt(rgbMatcher.group(2))), (int)CSSColorUtil.validateColorComponent(Integer.parseInt(rgbMatcher.group(3))));
            }
            throw new JSApplicationIllegalArgumentException("Invalid color: " + colorString);
        }
        if (colorString.startsWith("rgba(")) {
            Matcher rgbaMatcher = RGBA_COLOR_PATTERN.matcher(colorString);
            if (rgbaMatcher.matches()) {
                return Color.argb((int)((int)(Float.parseFloat(rgbaMatcher.group(4)) * 255.0f)), (int)CSSColorUtil.validateColorComponent(Integer.parseInt(rgbaMatcher.group(1))), (int)CSSColorUtil.validateColorComponent(Integer.parseInt(rgbaMatcher.group(2))), (int)CSSColorUtil.validateColorComponent(Integer.parseInt(rgbaMatcher.group(3))));
            }
            throw new JSApplicationIllegalArgumentException("Invalid color: " + colorString);
        }
        if (colorString.startsWith("#")) {
            if (colorString.length() == 4) {
                int r = CSSColorUtil.parseHexChar(colorString.charAt(1));
                int g = CSSColorUtil.parseHexChar(colorString.charAt(2));
                int b = CSSColorUtil.parseHexChar(colorString.charAt(3));
                r |= r << 4;
                g |= g << 4;
                b |= b << 4;
                return Color.rgb((int)r, (int)g, (int)b);
            }
            if (colorString.length() == 7) {
                try {
                    return Color.parseColor((String)colorString);
                }
                catch (IllegalArgumentException ex) {
                    throw new JSApplicationIllegalArgumentException("Invalid color: " + colorString);
                }
            }
            throw new JSApplicationIllegalArgumentException("Invalid color: " + colorString);
        }
        Integer color = sColorNameMap.get(colorString.toLowerCase());
        if (color != null) {
            return color;
        }
        throw new JSApplicationIllegalArgumentException("Unknown color: " + colorString);
    }

    @VisibleForTesting
    static int parseHexChar(char hexChar) {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        if (hexChar >= 'a' && hexChar <= 'f') {
            return hexChar - 97 + 10;
        }
        throw new JSApplicationIllegalArgumentException("Invalid hex character: " + hexChar);
    }

    private static int validateColorComponent(int color) {
        if (color < 0 || color > 255) {
            throw new JSApplicationIllegalArgumentException("Invalid color component: " + color);
        }
        return color;
    }

    static {
        sColorNameMap.put("black", Color.argb((int)255, (int)0, (int)0, (int)0));
        sColorNameMap.put("silver", Color.argb((int)255, (int)192, (int)192, (int)192));
        sColorNameMap.put("gray", Color.argb((int)255, (int)128, (int)128, (int)128));
        sColorNameMap.put("grey", Color.argb((int)255, (int)128, (int)128, (int)128));
        sColorNameMap.put("white", Color.argb((int)255, (int)255, (int)255, (int)255));
        sColorNameMap.put("maroon", Color.argb((int)255, (int)128, (int)0, (int)0));
        sColorNameMap.put("red", Color.argb((int)255, (int)255, (int)0, (int)0));
        sColorNameMap.put("purple", Color.argb((int)255, (int)128, (int)0, (int)128));
        sColorNameMap.put("fuchsia", Color.argb((int)255, (int)255, (int)0, (int)255));
        sColorNameMap.put("green", Color.argb((int)255, (int)0, (int)128, (int)0));
        sColorNameMap.put("lime", Color.argb((int)255, (int)0, (int)255, (int)0));
        sColorNameMap.put("olive", Color.argb((int)255, (int)128, (int)128, (int)0));
        sColorNameMap.put("yellow", Color.argb((int)255, (int)255, (int)255, (int)0));
        sColorNameMap.put("navy", Color.argb((int)255, (int)0, (int)0, (int)128));
        sColorNameMap.put("blue", Color.argb((int)255, (int)0, (int)0, (int)255));
        sColorNameMap.put("teal", Color.argb((int)255, (int)0, (int)128, (int)128));
        sColorNameMap.put("aqua", Color.argb((int)255, (int)0, (int)255, (int)255));
        sColorNameMap.put("orange", Color.argb((int)255, (int)255, (int)165, (int)0));
        sColorNameMap.put("transparent", Color.argb((int)0, (int)0, (int)0, (int)0));
    }
}

