/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.text.Html;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.devsupport.DebugServerException;
import java.io.File;

class ExceptionFormatterHelper {
    ExceptionFormatterHelper() {
    }

    private static String getStackTraceHtmlComponent(String methodName, String filename, int lineNumber, int columnNumber) {
        StringBuilder stringBuilder = new StringBuilder();
        methodName = methodName.replace("<", "&lt;").replace(">", "&gt;");
        stringBuilder.append("<font color=#FDE5E5>").append(methodName).append("</font><br /><font color=#F9B3B3>").append(filename).append(":").append(lineNumber);
        if (columnNumber != -1) {
            stringBuilder.append(":").append(columnNumber);
        }
        stringBuilder.append("</font><br /><br />");
        return stringBuilder.toString();
    }

    public static CharSequence jsStackTraceToHtml(ReadableArray stack) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stack.size(); ++i) {
            ReadableMap frame = stack.getMap(i);
            String methodName = frame.getString("methodName");
            String fileName = new File(frame.getString("file")).getName();
            int lineNumber = frame.getInt("lineNumber");
            int columnNumber = -1;
            if (frame.hasKey("column") && !frame.isNull("column")) {
                columnNumber = frame.getInt("column");
            }
            stringBuilder.append(ExceptionFormatterHelper.getStackTraceHtmlComponent(methodName, fileName, lineNumber, columnNumber));
        }
        return Html.fromHtml((String)stringBuilder.toString());
    }

    public static CharSequence javaStackTraceToHtml(StackTraceElement[] stack) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stack.length; ++i) {
            stringBuilder.append(ExceptionFormatterHelper.getStackTraceHtmlComponent(stack[i].getMethodName(), stack[i].getFileName(), stack[i].getLineNumber(), -1));
        }
        return Html.fromHtml((String)stringBuilder.toString());
    }

    public static CharSequence debugServerExcStackTraceToHtml(DebugServerException e) {
        String s = ExceptionFormatterHelper.getStackTraceHtmlComponent("", e.fileName, e.lineNumber, e.column);
        return Html.fromHtml((String)s);
    }
}

