/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.SetBuilder;
import com.facebook.systrace.Systrace;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class NativeModuleRegistry {
    private final ArrayList<ModuleDefinition> mModuleTable;
    private final Map<Class<NativeModule>, NativeModule> mModuleInstances;
    private final String mModuleDescriptions;
    private final ArrayList<OnBatchCompleteListener> mBatchCompleteListenerModules;

    private NativeModuleRegistry(ArrayList<ModuleDefinition> moduleTable, Map<Class<NativeModule>, NativeModule> moduleInstances, String moduleDescriptions) {
        this.mModuleTable = moduleTable;
        this.mModuleInstances = moduleInstances;
        this.mModuleDescriptions = moduleDescriptions;
        this.mBatchCompleteListenerModules = new ArrayList(this.mModuleTable.size());
        for (int i = 0; i < this.mModuleTable.size(); ++i) {
            ModuleDefinition definition = this.mModuleTable.get(i);
            if (!(definition.target instanceof OnBatchCompleteListener)) continue;
            this.mBatchCompleteListenerModules.add((OnBatchCompleteListener)((Object)definition.target));
        }
    }

    void call(CatalystInstance catalystInstance, int moduleId, int methodId, ReadableNativeArray parameters) {
        ModuleDefinition definition = this.mModuleTable.get(moduleId);
        if (definition == null) {
            throw new RuntimeException("Call to unknown module: " + moduleId);
        }
        definition.call(catalystInstance, methodId, parameters);
    }

    String moduleDescriptions() {
        return this.mModuleDescriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCatalystInstanceDestroy() {
        UiThreadUtil.assertOnUiThread();
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyCatalystInstanceDestroy");
        try {
            for (NativeModule nativeModule : this.mModuleInstances.values()) {
                nativeModule.onCatalystInstanceDestroy();
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCatalystInstanceInitialized() {
        UiThreadUtil.assertOnUiThread();
        ReactMarker.logMarker("NativeModule_start");
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyCatalystInstanceInitialized");
        try {
            for (NativeModule nativeModule : this.mModuleInstances.values()) {
                nativeModule.initialize();
            }
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("NativeModule_end");
        }
    }

    public void onBatchComplete() {
        for (int i = 0; i < this.mBatchCompleteListenerModules.size(); ++i) {
            this.mBatchCompleteListenerModules.get(i).onBatchComplete();
        }
    }

    public <T extends NativeModule> T getModule(Class<T> moduleInterface) {
        return (T)((NativeModule)Assertions.assertNotNull((Object)this.mModuleInstances.get(moduleInterface)));
    }

    public Collection<NativeModule> getAllModules() {
        return this.mModuleInstances.values();
    }

    public static class Builder {
        private ArrayList<ModuleDefinition> mModuleDefinitions = new ArrayList();
        private Map<Class<NativeModule>, NativeModule> mModuleInstances = MapBuilder.newHashMap();
        private Set<String> mSeenModuleNames = SetBuilder.newHashSet();

        public Builder add(NativeModule module) {
            ModuleDefinition registration = new ModuleDefinition(this.mModuleDefinitions.size(), module.getName(), module);
            Assertions.assertCondition((!this.mSeenModuleNames.contains(module.getName()) ? 1 : 0) != 0, (String)("Module " + module.getName() + " was already registered!"));
            this.mSeenModuleNames.add(module.getName());
            this.mModuleDefinitions.add(registration);
            this.mModuleInstances.put(module.getClass(), module);
            return this;
        }

        public NativeModuleRegistry build() {
            JsonFactory jsonFactory = new JsonFactory();
            StringWriter writer = new StringWriter();
            try {
                JsonGenerator jg = jsonFactory.createGenerator((Writer)writer);
                jg.writeStartObject();
                for (ModuleDefinition module : this.mModuleDefinitions) {
                    jg.writeObjectFieldStart(module.name);
                    jg.writeNumberField("moduleID", module.id);
                    jg.writeObjectFieldStart("methods");
                    for (int i = 0; i < module.methods.size(); ++i) {
                        MethodRegistration method = module.methods.get(i);
                        jg.writeObjectFieldStart(method.name);
                        jg.writeNumberField("methodID", i);
                        jg.writeStringField("type", method.method.getType());
                        jg.writeEndObject();
                    }
                    jg.writeEndObject();
                    module.target.writeConstantsField(jg, "constants");
                    jg.writeEndObject();
                }
                jg.writeEndObject();
                jg.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to serialize Java module configuration", ioe);
            }
            String moduleDefinitionJson = writer.getBuffer().toString();
            return new NativeModuleRegistry(this.mModuleDefinitions, this.mModuleInstances, moduleDefinitionJson);
        }
    }

    private static class MethodRegistration {
        public String name;
        public String tracingName;
        public NativeModule.NativeMethod method;

        public MethodRegistration(String name, String tracingName, NativeModule.NativeMethod method) {
            this.name = name;
            this.tracingName = tracingName;
            this.method = method;
        }
    }

    private static class ModuleDefinition {
        public final int id;
        public final String name;
        public final NativeModule target;
        public final ArrayList<MethodRegistration> methods;

        public ModuleDefinition(int id, String name, NativeModule target) {
            this.id = id;
            this.name = name;
            this.target = target;
            this.methods = new ArrayList();
            for (Map.Entry<String, NativeModule.NativeMethod> entry : target.getMethods().entrySet()) {
                this.methods.add(new MethodRegistration(entry.getKey(), "NativeCall__" + target.getName() + "_" + entry.getKey(), entry.getValue()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void call(CatalystInstance catalystInstance, int methodId, ReadableNativeArray parameters) {
            MethodRegistration method = this.methods.get(methodId);
            Systrace.beginSection(0L, method.tracingName);
            try {
                this.methods.get((int)methodId).method.invoke(catalystInstance, parameters);
            }
            finally {
                Systrace.endSection(0L);
            }
        }
    }
}

