/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.catalyst.uimanager.debug;

import android.util.SparseArray;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import javax.annotation.Nullable;

public class DebugComponentOwnershipModule
extends ReactContextBaseJavaModule {
    private final SparseArray<OwnerHierarchyCallback> mRequestIdToCallback = new SparseArray();
    @Nullable
    private RCTDebugComponentOwnership mRCTDebugComponentOwnership;
    private int mNextRequestId = 0;

    public DebugComponentOwnershipModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mRCTDebugComponentOwnership = this.getReactApplicationContext().getJSModule(RCTDebugComponentOwnership.class);
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        this.mRCTDebugComponentOwnership = null;
    }

    @ReactMethod
    public synchronized void receiveOwnershipHierarchy(int requestId, int tag, @Nullable ReadableArray owners) {
        OwnerHierarchyCallback callback = (OwnerHierarchyCallback)this.mRequestIdToCallback.get(requestId);
        if (callback == null) {
            throw new JSApplicationCausedNativeException("Got receiveOwnershipHierarchy for invalid request id: " + requestId);
        }
        this.mRequestIdToCallback.delete(requestId);
        callback.onOwnerHierarchyLoaded(tag, owners);
    }

    public synchronized void loadComponentOwnerHierarchy(int tag, OwnerHierarchyCallback callback) {
        int requestId = this.mNextRequestId++;
        this.mRequestIdToCallback.put(requestId, (Object)callback);
        ((RCTDebugComponentOwnership)Assertions.assertNotNull((Object)this.mRCTDebugComponentOwnership)).getOwnerHierarchy(requestId, tag);
    }

    @Override
    public String getName() {
        return "DebugComponentOwnershipModule";
    }

    public static interface OwnerHierarchyCallback {
        public void onOwnerHierarchyLoaded(int var1, @Nullable ReadableArray var2);
    }

    public static interface RCTDebugComponentOwnership
    extends JavaScriptModule {
        public void getOwnerHierarchy(int var1, int var2);
    }
}

