/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.devsupport.DevSupportManager;
import com.facebook.react.modules.debug.DeveloperSettings;
import javax.annotation.Nullable;

@VisibleForTesting
public class DevInternalSettings
implements DeveloperSettings,
SharedPreferences.OnSharedPreferenceChangeListener {
    private static final String PREFS_FPS_DEBUG_KEY = "fps_debug";
    private static final String PREFS_JS_DEV_MODE_DEBUG_KEY = "js_dev_mode_debug";
    private static final String PREFS_DEBUG_SERVER_HOST_KEY = "debug_http_host";
    private static final String PREFS_ANIMATIONS_DEBUG_KEY = "animations_debug";
    private static final String PREFS_RELOAD_ON_JS_CHANGE_KEY = "reload_on_js_change";
    private final SharedPreferences mPreferences;
    private final DevSupportManager mDebugManager;

    public DevInternalSettings(Context applicationContext, DevSupportManager debugManager) {
        this.mDebugManager = debugManager;
        this.mPreferences = PreferenceManager.getDefaultSharedPreferences((Context)applicationContext);
        this.mPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    @Override
    public boolean isFpsDebugEnabled() {
        return this.mPreferences.getBoolean(PREFS_FPS_DEBUG_KEY, false);
    }

    @Override
    public boolean isAnimationFpsDebugEnabled() {
        return this.mPreferences.getBoolean(PREFS_ANIMATIONS_DEBUG_KEY, false);
    }

    @Override
    public boolean isJSDevModeEnabled() {
        return this.mPreferences.getBoolean(PREFS_JS_DEV_MODE_DEBUG_KEY, true);
    }

    @Nullable
    public String getDebugServerHost() {
        return this.mPreferences.getString(PREFS_DEBUG_SERVER_HOST_KEY, null);
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if (PREFS_FPS_DEBUG_KEY.equals(key) || PREFS_RELOAD_ON_JS_CHANGE_KEY.equals(key) || PREFS_JS_DEV_MODE_DEBUG_KEY.equals(key)) {
            this.mDebugManager.reloadSettings();
        }
    }

    public boolean isReloadOnJSChangeEnabled() {
        return this.mPreferences.getBoolean(PREFS_RELOAD_ON_JS_CHANGE_KEY, false);
    }
}

