/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistry;
import com.facebook.react.bridge.JavaScriptModulesConfig;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReactCallback;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.queue.CatalystQueueConfiguration;
import com.facebook.react.bridge.queue.CatalystQueueConfigurationSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.TraceListener;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

@DoNotStrip
public class CatalystInstance {
    private static final int BRIDGE_SETUP_TIMEOUT_MS = 30000;
    private static final int LOAD_JS_BUNDLE_TIMEOUT_MS = 30000;
    private static final AtomicInteger sNextInstanceIdForTrace = new AtomicInteger(1);
    private final CatalystQueueConfiguration mCatalystQueueConfiguration;
    private final CopyOnWriteArrayList<NotThreadSafeBridgeIdleDebugListener> mBridgeIdleListeners;
    private final AtomicInteger mPendingJSCalls = new AtomicInteger(0);
    private final String mJsPendingCallsTitleForTrace = "pending_js_calls_instance" + sNextInstanceIdForTrace.getAndIncrement();
    private volatile boolean mDestroyed = false;
    private final TraceListener mTraceListener;
    private final JavaScriptModuleRegistry mJSModuleRegistry;
    private final JSBundleLoader mJSBundleLoader;
    private final NativeModuleRegistry mJavaRegistry;
    private final NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;
    private boolean mInitialized = false;
    @Nullable
    private ReactBridge mBridge;
    private boolean mJSBundleHasLoaded;

    private CatalystInstance(CatalystQueueConfigurationSpec catalystQueueConfigurationSpec, final JavaScriptExecutor jsExecutor, NativeModuleRegistry registry, final JavaScriptModulesConfig jsModulesConfig, JSBundleLoader jsBundleLoader, NativeModuleCallExceptionHandler nativeModuleCallExceptionHandler) {
        this.mCatalystQueueConfiguration = CatalystQueueConfiguration.create(catalystQueueConfigurationSpec, new NativeExceptionHandler());
        this.mBridgeIdleListeners = new CopyOnWriteArrayList();
        this.mJavaRegistry = registry;
        this.mJSModuleRegistry = new JavaScriptModuleRegistry(this, jsModulesConfig);
        this.mJSBundleLoader = jsBundleLoader;
        this.mNativeModuleCallExceptionHandler = nativeModuleCallExceptionHandler;
        this.mTraceListener = new JSProfilerTraceListener();
        Systrace.registerListener(this.mTraceListener);
        final CountDownLatch initLatch = new CountDownLatch(1);
        this.mCatalystQueueConfiguration.getJSQueueThread().runOnQueue(new Runnable(){

            @Override
            public void run() {
                CatalystInstance.this.initializeBridge(jsExecutor, jsModulesConfig);
                initLatch.countDown();
            }
        });
        try {
            Assertions.assertCondition((boolean)initLatch.await(30000L, TimeUnit.MILLISECONDS), (String)"Timed out waiting for bridge to initialize!");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeBridge(JavaScriptExecutor jsExecutor, JavaScriptModulesConfig jsModulesConfig) {
        this.mCatalystQueueConfiguration.getJSQueueThread().assertIsOnThread();
        Assertions.assertCondition((this.mBridge == null ? 1 : 0) != 0, (String)"initializeBridge should be called once");
        this.mBridge = new ReactBridge(jsExecutor, new NativeModulesReactCallback(), this.mCatalystQueueConfiguration.getNativeModulesQueueThread());
        this.mBridge.setGlobalVariable("__fbBatchedBridgeConfig", this.buildModulesConfigJSONProperty(this.mJavaRegistry, jsModulesConfig));
    }

    public void runJSBundle() {
        Systrace.beginSection(0L, "CatalystInstance_runJSBundle");
        try {
            final CountDownLatch initLatch = new CountDownLatch(1);
            this.mCatalystQueueConfiguration.getJSQueueThread().runOnQueue(new Runnable(){

                @Override
                public void run() {
                    Assertions.assertCondition((!CatalystInstance.this.mJSBundleHasLoaded ? 1 : 0) != 0, (String)"JS bundle was already loaded!");
                    CatalystInstance.this.mJSBundleHasLoaded = true;
                    CatalystInstance.this.incrementPendingJSCalls();
                    CatalystInstance.this.mJSBundleLoader.loadScript(CatalystInstance.this.mBridge);
                    initLatch.countDown();
                }
            });
            Assertions.assertCondition((boolean)initLatch.await(30000L, TimeUnit.MILLISECONDS), (String)"Timed out loading JS!");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    void callFunction(final int moduleId, final int methodId, final NativeArray arguments, final String tracingName) {
        if (this.mDestroyed) {
            FLog.w((String)"React", (String)"Calling JS function after bridge has been destroyed.");
            return;
        }
        this.incrementPendingJSCalls();
        this.mCatalystQueueConfiguration.getJSQueueThread().runOnQueue(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CatalystInstance.this.mCatalystQueueConfiguration.getJSQueueThread().assertIsOnThread();
                if (CatalystInstance.this.mDestroyed) {
                    return;
                }
                Systrace.beginSection(0L, tracingName);
                try {
                    ((ReactBridge)Assertions.assertNotNull((Object)CatalystInstance.this.mBridge)).callFunction(moduleId, methodId, arguments);
                }
                finally {
                    Systrace.endSection(0L);
                }
            }
        });
    }

    @DoNotStrip
    void invokeCallback(final int callbackID, final NativeArray arguments) {
        if (this.mDestroyed) {
            FLog.w((String)"React", (String)"Invoking JS callback after bridge has been destroyed.");
            return;
        }
        this.incrementPendingJSCalls();
        this.mCatalystQueueConfiguration.getJSQueueThread().runOnQueue(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CatalystInstance.this.mCatalystQueueConfiguration.getJSQueueThread().assertIsOnThread();
                if (CatalystInstance.this.mDestroyed) {
                    return;
                }
                Systrace.beginSection(0L, "<callback>");
                try {
                    ((ReactBridge)Assertions.assertNotNull((Object)CatalystInstance.this.mBridge)).invokeCallback(callbackID, arguments);
                }
                finally {
                    Systrace.endSection(0L);
                }
            }
        });
    }

    void destroy() {
        boolean wasIdle;
        UiThreadUtil.assertOnUiThread();
        if (this.mDestroyed) {
            return;
        }
        this.mDestroyed = true;
        this.mJavaRegistry.notifyCatalystInstanceDestroy();
        this.mCatalystQueueConfiguration.destroy();
        boolean bl = wasIdle = this.mPendingJSCalls.getAndSet(0) == 0;
        if (!wasIdle && !this.mBridgeIdleListeners.isEmpty()) {
            for (NotThreadSafeBridgeIdleDebugListener listener : this.mBridgeIdleListeners) {
                listener.onTransitionToBridgeIdle();
            }
        }
        if (this.mTraceListener != null) {
            Systrace.unregisterListener(this.mTraceListener);
        }
        ((ReactBridge)Assertions.assertNotNull((Object)this.mBridge)).dispose();
    }

    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    @VisibleForTesting
    public void initialize() {
        UiThreadUtil.assertOnUiThread();
        Assertions.assertCondition((!this.mInitialized ? 1 : 0) != 0, (String)"This catalyst instance has already been initialized");
        this.mInitialized = true;
        this.mJavaRegistry.notifyCatalystInstanceInitialized();
    }

    public CatalystQueueConfiguration getCatalystQueueConfiguration() {
        return this.mCatalystQueueConfiguration;
    }

    @Nullable
    @VisibleForTesting
    public ReactBridge getBridge() {
        return this.mBridge;
    }

    public <T extends JavaScriptModule> T getJSModule(Class<T> jsInterface) {
        return ((JavaScriptModuleRegistry)Assertions.assertNotNull((Object)this.mJSModuleRegistry)).getJavaScriptModule(jsInterface);
    }

    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        return this.mJavaRegistry.getModule(nativeModuleInterface);
    }

    public Collection<NativeModule> getNativeModules() {
        return this.mJavaRegistry.getAllModules();
    }

    public void addBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener listener) {
        this.mBridgeIdleListeners.add(listener);
    }

    public void removeBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener listener) {
        this.mBridgeIdleListeners.remove(listener);
    }

    private String buildModulesConfigJSONProperty(NativeModuleRegistry nativeModuleRegistry, JavaScriptModulesConfig jsModulesConfig) {
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jg = jsonFactory.createGenerator((Writer)writer);
            jg.writeStartObject();
            jg.writeFieldName("remoteModuleConfig");
            jg.writeRawValue(nativeModuleRegistry.moduleDescriptions());
            jg.writeFieldName("localModulesConfig");
            jg.writeRawValue(jsModulesConfig.moduleDescriptions());
            jg.writeEndObject();
            jg.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to serialize JavaScript module declaration", ioe);
        }
        return writer.getBuffer().toString();
    }

    private void incrementPendingJSCalls() {
        int oldPendingCalls = this.mPendingJSCalls.getAndIncrement();
        boolean wasIdle = oldPendingCalls == 0;
        Systrace.traceCounter(0L, this.mJsPendingCallsTitleForTrace, oldPendingCalls + 1);
        if (wasIdle && !this.mBridgeIdleListeners.isEmpty()) {
            for (NotThreadSafeBridgeIdleDebugListener listener : this.mBridgeIdleListeners) {
                listener.onTransitionToBridgeBusy();
            }
        }
    }

    private void decrementPendingJSCalls() {
        int newPendingCalls = this.mPendingJSCalls.decrementAndGet();
        Assertions.assertCondition((newPendingCalls >= 0 ? 1 : 0) != 0);
        boolean isNowIdle = newPendingCalls == 0;
        Systrace.traceCounter(0L, this.mJsPendingCallsTitleForTrace, newPendingCalls);
        if (isNowIdle && !this.mBridgeIdleListeners.isEmpty()) {
            for (NotThreadSafeBridgeIdleDebugListener listener : this.mBridgeIdleListeners) {
                listener.onTransitionToBridgeIdle();
            }
        }
    }

    public static class Builder {
        @Nullable
        private CatalystQueueConfigurationSpec mCatalystQueueConfigurationSpec;
        @Nullable
        private JSBundleLoader mJSBundleLoader;
        @Nullable
        private NativeModuleRegistry mRegistry;
        @Nullable
        private JavaScriptModulesConfig mJSModulesConfig;
        @Nullable
        private JavaScriptExecutor mJSExecutor;
        @Nullable
        private NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;

        public Builder setCatalystQueueConfigurationSpec(CatalystQueueConfigurationSpec catalystQueueConfigurationSpec) {
            this.mCatalystQueueConfigurationSpec = catalystQueueConfigurationSpec;
            return this;
        }

        public Builder setRegistry(NativeModuleRegistry registry) {
            this.mRegistry = registry;
            return this;
        }

        public Builder setJSModulesConfig(JavaScriptModulesConfig jsModulesConfig) {
            this.mJSModulesConfig = jsModulesConfig;
            return this;
        }

        public Builder setJSBundleLoader(JSBundleLoader jsBundleLoader) {
            this.mJSBundleLoader = jsBundleLoader;
            return this;
        }

        public Builder setJSExecutor(JavaScriptExecutor jsExecutor) {
            this.mJSExecutor = jsExecutor;
            return this;
        }

        public Builder setNativeModuleCallExceptionHandler(NativeModuleCallExceptionHandler handler) {
            this.mNativeModuleCallExceptionHandler = handler;
            return this;
        }

        public CatalystInstance build() {
            return new CatalystInstance((CatalystQueueConfigurationSpec)Assertions.assertNotNull((Object)this.mCatalystQueueConfigurationSpec), (JavaScriptExecutor)Assertions.assertNotNull((Object)this.mJSExecutor), (NativeModuleRegistry)Assertions.assertNotNull((Object)this.mRegistry), (JavaScriptModulesConfig)Assertions.assertNotNull((Object)this.mJSModulesConfig), (JSBundleLoader)Assertions.assertNotNull((Object)this.mJSBundleLoader), (NativeModuleCallExceptionHandler)Assertions.assertNotNull((Object)this.mNativeModuleCallExceptionHandler));
        }
    }

    private class JSProfilerTraceListener
    implements TraceListener {
        private JSProfilerTraceListener() {
        }

        @Override
        public void onTraceStarted() {
            CatalystInstance.this.mCatalystQueueConfiguration.getJSQueueThread().runOnQueue(new Runnable(){

                @Override
                public void run() {
                    CatalystInstance.this.mCatalystQueueConfiguration.getJSQueueThread().assertIsOnThread();
                    if (CatalystInstance.this.mDestroyed) {
                        return;
                    }
                    ((ReactBridge)Assertions.assertNotNull((Object)CatalystInstance.this.mBridge)).setGlobalVariable("__BridgeProfilingIsProfiling", "true");
                }
            });
        }

        @Override
        public void onTraceStopped() {
            CatalystInstance.this.mCatalystQueueConfiguration.getJSQueueThread().runOnQueue(new Runnable(){

                @Override
                public void run() {
                    CatalystInstance.this.mCatalystQueueConfiguration.getJSQueueThread().assertIsOnThread();
                    if (CatalystInstance.this.mDestroyed) {
                        return;
                    }
                    ((ReactBridge)Assertions.assertNotNull((Object)CatalystInstance.this.mBridge)).setGlobalVariable("__BridgeProfilingIsProfiling", "false");
                }
            });
        }
    }

    private class NativeExceptionHandler
    implements QueueThreadExceptionHandler {
        private NativeExceptionHandler() {
        }

        @Override
        public void handleException(Exception e) {
            CatalystInstance.this.mNativeModuleCallExceptionHandler.handleException(e);
            CatalystInstance.this.mCatalystQueueConfiguration.getUIQueueThread().runOnQueue(new Runnable(){

                @Override
                public void run() {
                    CatalystInstance.this.destroy();
                }
            });
        }
    }

    private class NativeModulesReactCallback
    implements ReactCallback {
        private NativeModulesReactCallback() {
        }

        @Override
        public void call(int moduleId, int methodId, ReadableNativeArray parameters) {
            CatalystInstance.this.mCatalystQueueConfiguration.getNativeModulesQueueThread().assertIsOnThread();
            if (CatalystInstance.this.mDestroyed) {
                return;
            }
            CatalystInstance.this.mJavaRegistry.call(CatalystInstance.this, moduleId, methodId, parameters);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBatchComplete() {
            CatalystInstance.this.mCatalystQueueConfiguration.getNativeModulesQueueThread().assertIsOnThread();
            if (!CatalystInstance.this.mDestroyed) {
                Systrace.beginSection(0L, "onBatchComplete");
                try {
                    CatalystInstance.this.mJavaRegistry.onBatchComplete();
                }
                finally {
                    Systrace.endSection(0L);
                }
            }
            CatalystInstance.this.decrementPendingJSCalls();
        }
    }
}

