/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.TouchTargetHelper;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.TouchEvent;
import com.facebook.react.uimanager.events.TouchEventType;
import javax.annotation.Nullable;

public class ReactRootView
extends SizeMonitoringFrameLayout
implements RootView {
    private final KeyboardListener mKeyboardListener = new KeyboardListener();
    @Nullable
    private ReactInstanceManager mReactInstanceManager;
    @Nullable
    private String mJSModuleName;
    @Nullable
    private Bundle mLaunchOptions;
    private int mTargetTag = -1;
    private boolean mChildIsHandlingNativeGesture = false;
    private boolean mWasMeasured = false;
    private boolean mAttachScheduled = false;
    private boolean mIsAttachedToWindow = false;
    private boolean mIsAttachedToInstance = false;

    public ReactRootView(Context context) {
        super(context);
    }

    public ReactRootView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ReactRootView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode == 0 || heightMode == 0) {
            throw new IllegalStateException("The root catalyst view must have a width and height given to it by it's parent view. You can do this by specifying MATCH_PARENT or explicit width and height in the layout.");
        }
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        this.mWasMeasured = true;
        if (this.mAttachScheduled && this.mReactInstanceManager != null && this.mIsAttachedToWindow) {
            this.mAttachScheduled = false;
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ((ReactInstanceManager)Assertions.assertNotNull((Object)ReactRootView.this.mReactInstanceManager)).attachMeasuredRootView(ReactRootView.this);
                    ReactRootView.this.mIsAttachedToInstance = true;
                    ReactRootView.this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)ReactRootView.this.mKeyboardListener);
                }
            });
        }
    }

    private void handleTouchEvent(MotionEvent ev) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"React", (String)"Unable to handle touch in JS as the catalyst instance has not been attached");
            return;
        }
        int action = ev.getAction() & 0xFF;
        ReactContext reactContext = this.mReactInstanceManager.getCurrentReactContext();
        EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        if (action == 0) {
            if (this.mTargetTag != -1) {
                FLog.e((String)"React", (String)"Got DOWN touch before receiving UP or CANCEL from last gesture");
            }
            this.mChildIsHandlingNativeGesture = false;
            this.mTargetTag = TouchTargetHelper.findTargetTagForTouch(ev.getY(), ev.getX(), (ViewGroup)this);
            eventDispatcher.dispatchEvent(new TouchEvent(this.mTargetTag, SystemClock.uptimeMillis(), TouchEventType.START, ev));
        } else {
            if (this.mChildIsHandlingNativeGesture) {
                return;
            }
            if (this.mTargetTag == -1) {
                FLog.e((String)"React", (String)"Unexpected state: received touch event but didn't get starting ACTION_DOWN for this gesture before");
            } else if (action == 1) {
                eventDispatcher.dispatchEvent(new TouchEvent(this.mTargetTag, SystemClock.uptimeMillis(), TouchEventType.END, ev));
                this.mTargetTag = -1;
            } else if (action == 2) {
                eventDispatcher.dispatchEvent(new TouchEvent(this.mTargetTag, SystemClock.uptimeMillis(), TouchEventType.MOVE, ev));
            } else if (action == 5) {
                eventDispatcher.dispatchEvent(new TouchEvent(this.mTargetTag, SystemClock.uptimeMillis(), TouchEventType.START, ev));
            } else if (action == 6) {
                eventDispatcher.dispatchEvent(new TouchEvent(this.mTargetTag, SystemClock.uptimeMillis(), TouchEventType.END, ev));
            } else if (action == 3) {
                this.dispatchCancelEvent(ev);
                this.mTargetTag = -1;
            } else {
                FLog.w((String)"React", (String)("Warning : touch event was ignored. Action=" + action + " Target=" + this.mTargetTag));
            }
        }
    }

    @Override
    public void onChildStartedNativeGesture(MotionEvent androidEvent) {
        if (this.mChildIsHandlingNativeGesture) {
            return;
        }
        this.dispatchCancelEvent(androidEvent);
        this.mChildIsHandlingNativeGesture = true;
        this.mTargetTag = -1;
    }

    private void dispatchCancelEvent(MotionEvent androidEvent) {
        if (this.mTargetTag == -1) {
            FLog.w((String)"React", (String)"Can't cancel already finished gesture. Is a child View trying to start a gesture from an UP/CANCEL event?");
            return;
        }
        EventDispatcher eventDispatcher = this.mReactInstanceManager.getCurrentReactContext().getNativeModule(UIManagerModule.class).getEventDispatcher();
        Assertions.assertCondition((!this.mChildIsHandlingNativeGesture ? 1 : 0) != 0, (String)"Expected to not have already sent a cancel for this gesture");
        ((EventDispatcher)Assertions.assertNotNull((Object)eventDispatcher)).dispatchEvent(new TouchEvent(this.mTargetTag, SystemClock.uptimeMillis(), TouchEventType.CANCEL, androidEvent));
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.handleTouchEvent(ev);
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.handleTouchEvent(ev);
        super.onTouchEvent(ev);
        return true;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsAttachedToWindow = false;
        if (this.mReactInstanceManager != null && !this.mAttachScheduled) {
            this.mReactInstanceManager.detachRootView(this);
            this.mIsAttachedToInstance = false;
            this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mKeyboardListener);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsAttachedToWindow = true;
        if (this.mReactInstanceManager != null) {
            this.mAttachScheduled = true;
        }
    }

    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName) {
        this.startReactApplication(reactInstanceManager, moduleName, null);
    }

    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName, @Nullable Bundle launchOptions) {
        Assertions.assertCondition((this.mReactInstanceManager == null ? 1 : 0) != 0, (String)"This root view has already been attached to a catalyst instance manager");
        this.mReactInstanceManager = reactInstanceManager;
        this.mJSModuleName = moduleName;
        this.mLaunchOptions = launchOptions;
        if (this.mWasMeasured && this.mIsAttachedToWindow) {
            this.mReactInstanceManager.attachMeasuredRootView(this);
            this.mIsAttachedToInstance = true;
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mKeyboardListener);
        } else {
            this.mAttachScheduled = true;
        }
    }

    String getJSModuleName() {
        return (String)Assertions.assertNotNull((Object)this.mJSModuleName);
    }

    @Nullable
    Bundle getLaunchOptions() {
        return this.mLaunchOptions;
    }

    @VisibleForTesting
    void simulateAttachForTesting() {
        this.mIsAttachedToWindow = true;
        this.mIsAttachedToInstance = true;
        this.mWasMeasured = true;
    }

    private class KeyboardListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private int mKeyboardHeight = 0;
        private final Rect mVisibleViewArea = new Rect();

        private KeyboardListener() {
        }

        public void onGlobalLayout() {
            if (ReactRootView.this.mReactInstanceManager == null || !ReactRootView.this.mIsAttachedToInstance || ReactRootView.this.mReactInstanceManager.getCurrentReactContext() == null) {
                FLog.w((String)"React", (String)"Unable to dispatch keyboard events in JS as the react instance has not been attached");
                return;
            }
            ReactRootView.this.getRootView().getWindowVisibleDisplayFrame(this.mVisibleViewArea);
            int heightDiff = DisplayMetricsHolder.getDisplayMetrics().heightPixels - this.mVisibleViewArea.bottom;
            if (this.mKeyboardHeight != heightDiff && heightDiff > 0) {
                this.mKeyboardHeight = heightDiff;
                WritableMap params = Arguments.createMap();
                WritableMap coordinates = Arguments.createMap();
                coordinates.putDouble("screenY", PixelUtil.toDIPFromPixel(this.mVisibleViewArea.bottom));
                coordinates.putDouble("screenX", PixelUtil.toDIPFromPixel(this.mVisibleViewArea.left));
                coordinates.putDouble("width", PixelUtil.toDIPFromPixel(this.mVisibleViewArea.width()));
                coordinates.putDouble("height", PixelUtil.toDIPFromPixel(this.mKeyboardHeight));
                params.putMap("endCoordinates", coordinates);
                this.sendEvent("keyboardDidShow", params);
            } else if (this.mKeyboardHeight != 0 && heightDiff == 0) {
                this.mKeyboardHeight = heightDiff;
                this.sendEvent("keyboardDidHide", null);
            }
        }

        private void sendEvent(String eventName, @Nullable WritableMap params) {
            if (ReactRootView.this.mReactInstanceManager != null) {
                ReactRootView.this.mReactInstanceManager.getCurrentReactContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(eventName, params);
            }
        }
    }
}

