/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.text.BoringLayout;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import com.facebook.csslayout.CSSConstants;
import com.facebook.csslayout.CSSNode;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.views.text.CustomStyleSpan;
import com.facebook.react.views.text.ReactTagSpan;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ReactTextShadowNode
extends ReactShadowNode {
    public static final String PROP_TEXT = "text";
    public static final int UNSET = -1;
    private static final TextPaint sTextPaintInstance = new TextPaint();
    private static final CSSNode.MeasureFunction TEXT_MEASURE_FUNCTION;
    private int mLineHeight = -1;
    private int mNumberOfLines = -1;
    private boolean mIsColorSet = false;
    private int mColor;
    private boolean mIsBackgroundColorSet = false;
    private int mBackgroundColor;
    private int mFontSize = -1;
    private int mFontStyle = -1;
    private int mFontWeight = -1;
    @Nullable
    private String mFontFamily = null;
    @Nullable
    private String mText = null;
    @Nullable
    private Spanned mPreparedSpannedText;
    private final boolean mIsVirtual;

    private static final void buildSpannedFromTextCSSNode(ReactTextShadowNode textCSSNode, SpannableStringBuilder sb, List<SetSpanOperation> ops) {
        int start = sb.length();
        if (textCSSNode.mText != null) {
            sb.append((CharSequence)textCSSNode.mText);
        }
        int length = textCSSNode.getChildCount();
        for (int i = 0; i < length; ++i) {
            ReactShadowNode child = textCSSNode.getChildAt(i);
            if (!(child instanceof ReactTextShadowNode)) {
                throw new IllegalViewOperationException("Unexpected view type nested under text node: " + child.getClass());
            }
            ReactTextShadowNode.buildSpannedFromTextCSSNode((ReactTextShadowNode)child, sb, ops);
            ((ReactTextShadowNode)child).markUpdateSeen();
        }
        int end = sb.length();
        if (end > start) {
            if (textCSSNode.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ForegroundColorSpan(textCSSNode.mColor)));
            }
            if (textCSSNode.mIsBackgroundColorSet) {
                ops.add(new SetSpanOperation(start, end, new BackgroundColorSpan(textCSSNode.mBackgroundColor)));
            }
            if (textCSSNode.mFontSize != -1) {
                ops.add(new SetSpanOperation(start, end, new AbsoluteSizeSpan(textCSSNode.mFontSize)));
            }
            if (textCSSNode.mFontStyle != -1 || textCSSNode.mFontWeight != -1 || textCSSNode.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, (Object)new CustomStyleSpan(textCSSNode.mFontStyle, textCSSNode.mFontWeight, textCSSNode.mFontFamily)));
            }
            ops.add(new SetSpanOperation(start, end, new ReactTagSpan(textCSSNode.getReactTag())));
        }
    }

    protected static final Spanned fromTextCSSNode(ReactTextShadowNode textCSSNode) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        ArrayList<SetSpanOperation> ops = new ArrayList<SetSpanOperation>();
        ReactTextShadowNode.buildSpannedFromTextCSSNode(textCSSNode, sb, ops);
        if (textCSSNode.mFontSize == -1) {
            sb.setSpan((Object)new AbsoluteSizeSpan((int)Math.ceil(PixelUtil.toPixelFromSP(14.0f))), 0, sb.length(), 17);
        }
        for (int i = ops.size() - 1; i >= 0; --i) {
            SetSpanOperation op = (SetSpanOperation)ops.get(i);
            op.execute(sb);
        }
        return sb;
    }

    private static int parseNumericFontWeight(String fontWeightString) {
        return fontWeightString.length() == 3 && fontWeightString.endsWith("00") && fontWeightString.charAt(0) <= '9' && fontWeightString.charAt(0) >= '1' ? 100 * (fontWeightString.charAt(0) - 48) : -1;
    }

    @Override
    public void onBeforeLayout() {
        if (this.mIsVirtual) {
            return;
        }
        this.mPreparedSpannedText = ReactTextShadowNode.fromTextCSSNode(this);
        this.markUpdated();
    }

    @Override
    protected void markUpdated() {
        super.markUpdated();
        if (!this.mIsVirtual) {
            super.dirty();
        }
    }

    @Override
    public void updateProperties(CatalystStylesDiffMap styles) {
        super.updateProperties(styles);
        if (styles.hasKey(PROP_TEXT)) {
            this.mText = styles.getString(PROP_TEXT);
            this.markUpdated();
        }
        if (styles.hasKey("numberOfLines")) {
            this.mNumberOfLines = styles.getInt("numberOfLines", -1);
            this.markUpdated();
        }
        if (styles.hasKey("lineHeight")) {
            this.mLineHeight = styles.getInt("lineHeight", -1);
            this.markUpdated();
        }
        if (styles.hasKey("fontSize")) {
            this.mFontSize = styles.isNull("fontSize") ? -1 : (int)Math.ceil(PixelUtil.toPixelFromSP(styles.getFloat("fontSize", 14.0f)));
            this.markUpdated();
        }
        if (styles.hasKey("color")) {
            if (styles.isNull("color")) {
                this.mIsColorSet = false;
            } else {
                this.mColor = styles.getInt("color", 0);
                this.mIsColorSet = true;
            }
            this.markUpdated();
        }
        if (styles.hasKey("backgroundColor") && !this.isVirtualAnchor()) {
            if (styles.isNull("backgroundColor")) {
                this.mIsBackgroundColorSet = false;
            } else {
                this.mBackgroundColor = styles.getInt("backgroundColor", 0);
                this.mIsBackgroundColorSet = true;
            }
            this.markUpdated();
        }
        if (styles.hasKey("fontFamily")) {
            this.mFontFamily = styles.getString("fontFamily");
            this.markUpdated();
        }
        if (styles.hasKey("fontWeight")) {
            String fontWeightString = styles.getString("fontWeight");
            int fontWeightNumeric = fontWeightString != null ? ReactTextShadowNode.parseNumericFontWeight(fontWeightString) : -1;
            int fontWeight = -1;
            if (fontWeightNumeric >= 500 || "bold".equals(fontWeightString)) {
                fontWeight = 1;
            } else if ("normal".equals(fontWeightString) || fontWeightNumeric != -1 && fontWeightNumeric < 500) {
                fontWeight = 0;
            }
            if (fontWeight != this.mFontWeight) {
                this.mFontWeight = fontWeight;
                this.markUpdated();
            }
        }
        if (styles.hasKey("fontStyle")) {
            String fontStyleString = styles.getString("fontStyle");
            int fontStyle = -1;
            if ("italic".equals(fontStyleString)) {
                fontStyle = 2;
            } else if ("normal".equals(fontStyleString)) {
                fontStyle = 0;
            }
            if (fontStyle != this.mFontStyle) {
                this.mFontStyle = fontStyle;
                this.markUpdated();
            }
        }
    }

    @Override
    public boolean isVirtualAnchor() {
        return !this.mIsVirtual;
    }

    @Override
    public boolean isVirtual() {
        return this.mIsVirtual;
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        if (this.mIsVirtual) {
            return;
        }
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mPreparedSpannedText != null) {
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), this.mPreparedSpannedText);
        }
    }

    public ReactTextShadowNode(boolean isVirtual) {
        this.mIsVirtual = isVirtual;
        if (!isVirtual) {
            this.setMeasureFunction(TEXT_MEASURE_FUNCTION);
        }
    }

    static {
        sTextPaintInstance.setFlags(1);
        TEXT_MEASURE_FUNCTION = new CSSNode.MeasureFunction(){

            @Override
            public void measure(CSSNode node, float width, MeasureOutput measureOutput) {
                float desiredWidth;
                ReactTextShadowNode reactCSSNode = (ReactTextShadowNode)node;
                TextPaint textPaint = sTextPaintInstance;
                Spanned text = (Spanned)Assertions.assertNotNull((Object)reactCSSNode.mPreparedSpannedText, (String)"Spannable element has not been prepared in onBeforeLayout");
                BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)textPaint);
                float f = desiredWidth = boring == null ? Layout.getDesiredWidth((CharSequence)text, (TextPaint)textPaint) : Float.NaN;
                Object layout2 = boring == null && (CSSConstants.isUndefined(width) || !CSSConstants.isUndefined(desiredWidth) && desiredWidth <= width) ? new StaticLayout((CharSequence)text, textPaint, (int)Math.ceil(desiredWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true) : (boring != null && (CSSConstants.isUndefined(width) || (float)boring.width <= width) ? BoringLayout.make((CharSequence)text, (TextPaint)textPaint, (int)boring.width, (Layout.Alignment)Layout.Alignment.ALIGN_NORMAL, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)true) : new StaticLayout((CharSequence)text, textPaint, (int)width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true));
                measureOutput.height = layout2.getHeight();
                measureOutput.width = layout2.getWidth();
                if (reactCSSNode.mNumberOfLines != -1 && reactCSSNode.mNumberOfLines < layout2.getLineCount()) {
                    measureOutput.height = layout2.getLineBottom(reactCSSNode.mNumberOfLines - 1);
                }
                if (reactCSSNode.mLineHeight != -1) {
                    int lines = reactCSSNode.mNumberOfLines != -1 ? Math.min(reactCSSNode.mNumberOfLines, layout2.getLineCount()) : layout2.getLineCount();
                    float lineHeight = PixelUtil.toPixelFromSP(reactCSSNode.mLineHeight);
                    measureOutput.height = lineHeight * (float)lines;
                }
            }
        };
    }

    private static class SetSpanOperation {
        protected int start;
        protected int end;
        protected Object what;

        SetSpanOperation(int start, int end, Object what) {
            this.start = start;
            this.end = end;
            this.what = what;
        }

        public void execute(SpannableStringBuilder sb) {
            int spanFlags = 34;
            if (this.start == 0) {
                spanFlags = 18;
            }
            sb.setSpan(this.what, this.start, this.end, spanFlags);
        }
    }
}

