/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.content.Context;
import com.facebook.common.internal.AndroidPredicates;
import com.facebook.common.soloader.SoLoaderShim;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.backends.okhttp.OkHttpImagePipelineConfigFactory;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.modules.common.ModuleDataCleaner;
import com.facebook.react.modules.fresco.SystraceRequestListener;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.soloader.SoLoader;
import com.squareup.okhttp.OkHttpClient;
import java.util.HashSet;

public class FrescoModule
extends ReactContextBaseJavaModule
implements ModuleDataCleaner.Cleanable {
    public FrescoModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public void initialize() {
        super.initialize();
        SoLoaderShim.setHandler((SoLoaderShim.Handler)new SoLoaderShim.Handler(){

            public void loadLibrary(String libraryName) {
                SoLoader.loadLibrary(libraryName);
            }
        });
        HashSet<SystraceRequestListener> requestListeners = new HashSet<SystraceRequestListener>();
        requestListeners.add(new SystraceRequestListener());
        Context context = this.getReactApplicationContext().getApplicationContext();
        OkHttpClient okHttpClient = OkHttpClientProvider.getOkHttpClient();
        ImagePipelineConfig config = OkHttpImagePipelineConfigFactory.newBuilder((Context)context, (OkHttpClient)okHttpClient).setDownsampleEnabled(false).setRequestListeners(requestListeners).build();
        Fresco.initialize((Context)context, (ImagePipelineConfig)config);
    }

    @Override
    public String getName() {
        return "FrescoModule";
    }

    @Override
    public void clearSensitiveData() {
        ImagePipelineFactory imagePipelineFactory = Fresco.getImagePipelineFactory();
        imagePipelineFactory.getBitmapMemoryCache().removeAll(AndroidPredicates.True());
        imagePipelineFactory.getEncodedMemoryCache().removeAll(AndroidPredicates.True());
        imagePipelineFactory.getMainDiskStorageCache().clearAll();
        imagePipelineFactory.getSmallImageDiskStorageCache().clearAll();
    }
}

