/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.facebook.react.R;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.CSSColorUtil;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.UIProp;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.toolbar.events.ToolbarClickEvent;
import javax.annotation.Nullable;

public class ReactToolbarManager
extends ViewGroupManager<Toolbar> {
    private static final String REACT_CLASS = "ToolbarAndroid";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_LOGO = "logo";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_NAV_ICON = "navIcon";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_SUBTITLE = "subtitle";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_SUBTITLE_COLOR = "subtitleColor";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_TITLE = "title";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_TITLE_COLOR = "titleColor";
    @UIProp(value=UIProp.Type.ARRAY)
    public static final String PROP_ACTIONS = "actions";
    private static final String PROP_ACTION_ICON = "icon";
    private static final String PROP_ACTION_SHOW = "show";
    private static final String PROP_ACTION_SHOW_WITH_TEXT = "showWithText";
    private static final String PROP_ACTION_TITLE = "title";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected Toolbar createViewInstance(ThemedReactContext reactContext) {
        return new Toolbar((Context)reactContext);
    }

    @Override
    public void updateView(Toolbar toolbar, CatalystStylesDiffMap props) {
        String color;
        super.updateView(toolbar, props);
        int[] defaultColors = ReactToolbarManager.getDefaultColors(toolbar.getContext());
        if (props.hasKey(PROP_SUBTITLE)) {
            toolbar.setSubtitle((CharSequence)props.getString(PROP_SUBTITLE));
        }
        if (props.hasKey(PROP_SUBTITLE_COLOR)) {
            color = props.getString(PROP_SUBTITLE_COLOR);
            if (color != null) {
                toolbar.setSubtitleTextColor(CSSColorUtil.getColor(color));
            } else {
                toolbar.setSubtitleTextColor(defaultColors[1]);
            }
        }
        if (props.hasKey("title")) {
            toolbar.setTitle((CharSequence)props.getString("title"));
        }
        if (props.hasKey(PROP_TITLE_COLOR)) {
            color = props.getString(PROP_TITLE_COLOR);
            if (color != null) {
                toolbar.setTitleTextColor(CSSColorUtil.getColor(color));
            } else {
                toolbar.setTitleTextColor(defaultColors[0]);
            }
        }
        if (props.hasKey(PROP_NAV_ICON)) {
            String navIcon = props.getString(PROP_NAV_ICON);
            if (navIcon != null) {
                toolbar.setNavigationIcon(ReactToolbarManager.getDrawableResourceByName(toolbar.getContext(), navIcon));
            } else {
                toolbar.setNavigationIcon(null);
            }
        }
        if (props.hasKey(PROP_LOGO)) {
            String logo = props.getString(PROP_LOGO);
            if (logo != null) {
                toolbar.setLogo(ReactToolbarManager.getDrawableResourceByName(toolbar.getContext(), logo));
            } else {
                toolbar.setLogo(null);
            }
        }
        if (props.hasKey(PROP_ACTIONS)) {
            ReactToolbarManager.setActions(toolbar, props.getArray(PROP_ACTIONS));
        }
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, final Toolbar view) {
        final EventDispatcher mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        view.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                mEventDispatcher.dispatchEvent(new ToolbarClickEvent(view.getId(), SystemClock.uptimeMillis(), -1));
            }
        });
        view.setOnMenuItemClickListener(new Toolbar.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem menuItem) {
                mEventDispatcher.dispatchEvent(new ToolbarClickEvent(view.getId(), SystemClock.uptimeMillis(), menuItem.getOrder()));
                return true;
            }
        });
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    private static void setActions(Toolbar toolbar, @Nullable ReadableArray actions) {
        Menu menu = toolbar.getMenu();
        menu.clear();
        if (actions != null) {
            for (int i = 0; i < actions.size(); ++i) {
                String show;
                String icon;
                ReadableMap action = actions.getMap(i);
                MenuItem item = menu.add(0, 0, i, (CharSequence)action.getString("title"));
                String string2 = icon = action.hasKey(PROP_ACTION_ICON) ? action.getString(PROP_ACTION_ICON) : null;
                if (icon != null) {
                    item.setIcon(ReactToolbarManager.getDrawableResourceByName(toolbar.getContext(), icon));
                }
                String string3 = show = action.hasKey(PROP_ACTION_SHOW) ? action.getString(PROP_ACTION_SHOW) : null;
                if (show == null) continue;
                int showAsAction = 0;
                if ("always".equals(show)) {
                    showAsAction = 2;
                } else if ("ifRoom".equals(show)) {
                    showAsAction = 1;
                }
                if (action.hasKey(PROP_ACTION_SHOW_WITH_TEXT) && action.getBoolean(PROP_ACTION_SHOW_WITH_TEXT)) {
                    showAsAction |= 4;
                }
                item.setShowAsAction(showAsAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getDefaultColors(Context context) {
        int[] nArray;
        Resources.Theme theme = context.getTheme();
        TypedArray toolbarStyle = null;
        TypedArray textAppearances = null;
        TypedArray titleTextAppearance = null;
        TypedArray subtitleTextAppearance = null;
        try {
            toolbarStyle = theme.obtainStyledAttributes(new int[]{R.attr.toolbarStyle});
            int toolbarStyleResId = toolbarStyle.getResourceId(0, 0);
            textAppearances = theme.obtainStyledAttributes(toolbarStyleResId, new int[]{R.attr.titleTextAppearance, R.attr.subtitleTextAppearance});
            int titleTextAppearanceResId = textAppearances.getResourceId(0, 0);
            int subtitleTextAppearanceResId = textAppearances.getResourceId(1, 0);
            titleTextAppearance = theme.obtainStyledAttributes(titleTextAppearanceResId, new int[]{16842904});
            subtitleTextAppearance = theme.obtainStyledAttributes(subtitleTextAppearanceResId, new int[]{16842904});
            int titleTextColor = titleTextAppearance.getColor(0, -16777216);
            int subtitleTextColor = subtitleTextAppearance.getColor(0, -16777216);
            nArray = new int[]{titleTextColor, subtitleTextColor};
        }
        catch (Throwable throwable) {
            ReactToolbarManager.recycleQuietly(toolbarStyle);
            ReactToolbarManager.recycleQuietly(textAppearances);
            ReactToolbarManager.recycleQuietly(titleTextAppearance);
            ReactToolbarManager.recycleQuietly(subtitleTextAppearance);
            throw throwable;
        }
        ReactToolbarManager.recycleQuietly(toolbarStyle);
        ReactToolbarManager.recycleQuietly(textAppearances);
        ReactToolbarManager.recycleQuietly(titleTextAppearance);
        ReactToolbarManager.recycleQuietly(subtitleTextAppearance);
        return nArray;
    }

    private static void recycleQuietly(@Nullable TypedArray style2) {
        if (style2 != null) {
            style2.recycle();
        }
    }

    private static int getDrawableResourceByName(Context context, String name) {
        name = name.toLowerCase().replace("-", "_");
        return context.getResources().getIdentifier(name, "drawable", context.getPackageName());
    }
}

