/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.text.Spanned;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.facebook.csslayout.CSSNode;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.csslayout.Spacing;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.views.text.ReactTextShadowNode;
import com.facebook.react.views.textinput.ReactTextUpdate;
import javax.annotation.Nullable;

class ReactTextInputShadowNode
extends ReactTextShadowNode
implements CSSNode.MeasureFunction {
    public static final String PROP_TEXT_INPUT_MOST_RECENT_EVENT_COUNT = "mostRecentEventCount";
    private static final int MEASURE_SPEC = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
    @Nullable
    private EditText mEditText;
    private int mFontSize = (int)Math.ceil(PixelUtil.toPixelFromSP(14.0f));
    @Nullable
    private float[] mComputedPadding;
    private int mJsEventCount = -1;
    private int mNumLines = -1;

    public ReactTextInputShadowNode() {
        super(false);
        this.setMeasureFunction(this);
    }

    @Override
    protected void setThemedContext(ThemedReactContext themedContext) {
        super.setThemedContext(themedContext);
        this.mEditText = new EditText((Context)this.getThemedContext());
        this.mEditText.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.setDefaultPadding(0, this.mEditText.getPaddingLeft());
        this.setDefaultPadding(1, this.mEditText.getPaddingTop());
        this.setDefaultPadding(2, this.mEditText.getPaddingRight());
        this.setDefaultPadding(3, this.mEditText.getPaddingBottom());
        this.mComputedPadding = ReactTextInputShadowNode.spacingToFloatArray(this.getStylePadding());
    }

    @Override
    public void measure(CSSNode node, float width, MeasureOutput measureOutput) {
        EditText editText = (EditText)Assertions.assertNotNull((Object)this.mEditText);
        measureOutput.width = width;
        editText.setTextSize(0, (float)this.mFontSize);
        this.mComputedPadding = ReactTextInputShadowNode.spacingToFloatArray(this.getStylePadding());
        editText.setPadding((int)Math.ceil(this.getStylePadding().get(0)), (int)Math.ceil(this.getStylePadding().get(1)), (int)Math.ceil(this.getStylePadding().get(2)), (int)Math.ceil(this.getStylePadding().get(3)));
        if (this.mNumLines != -1) {
            editText.setLines(this.mNumLines);
        }
        editText.measure(MEASURE_SPEC, MEASURE_SPEC);
        measureOutput.height = editText.getMeasuredHeight();
    }

    @Override
    public void onBeforeLayout() {
    }

    @Override
    public void updateProperties(CatalystStylesDiffMap styles) {
        super.updateProperties(styles);
        if (styles.hasKey("fontSize")) {
            float fontSize = styles.getFloat("fontSize", 14.0f);
            this.mFontSize = (int)Math.ceil(PixelUtil.toPixelFromSP(fontSize));
        }
        if (styles.hasKey(PROP_TEXT_INPUT_MOST_RECENT_EVENT_COUNT)) {
            this.mJsEventCount = styles.getInt(PROP_TEXT_INPUT_MOST_RECENT_EVENT_COUNT, 0);
        }
        if (styles.hasKey("numberOfLines")) {
            this.mNumLines = styles.getInt("numberOfLines", -1);
        }
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mComputedPadding != null) {
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), this.mComputedPadding);
            this.mComputedPadding = null;
        }
        if (this.mJsEventCount != -1) {
            Spanned preparedSpannedText = ReactTextInputShadowNode.fromTextCSSNode(this);
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(preparedSpannedText, this.mJsEventCount);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        super.setPadding(spacingType, padding);
        this.mComputedPadding = ReactTextInputShadowNode.spacingToFloatArray(this.getStylePadding());
        this.markUpdated();
    }

    private static float[] spacingToFloatArray(Spacing spacing) {
        return new float[]{spacing.get(0), spacing.get(1), spacing.get(2), spacing.get(3)};
    }
}

