/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.DisplayMetrics;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.UIManagerModuleConstants;
import com.facebook.react.uimanager.UIProp;
import com.facebook.react.uimanager.ViewManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class UIManagerModuleConstantsHelper {
    private static final String CUSTOM_BUBBLING_EVENT_TYPES_KEY = "customBubblingEventTypes";
    private static final String CUSTOM_DIRECT_EVENT_TYPES_KEY = "customDirectEventTypes";

    UIManagerModuleConstantsHelper() {
    }

    static Map<String, Object> createConstants(DisplayMetrics displayMetrics, List<ViewManager> viewManagers) {
        Map<String, Object> constants = UIManagerModuleConstants.getConstants(displayMetrics);
        Map bubblingEventTypesConstants = UIManagerModuleConstants.getBubblingEventTypeConstants();
        Map directEventTypesConstants = UIManagerModuleConstants.getDirectEventTypeConstants();
        for (ViewManager viewManager : viewManagers) {
            Map<String, UIProp.Type> viewManagerNativeProps;
            Map<String, Integer> viewManagerCommands;
            Map<String, Object> viewManagerDirectEvents;
            Map<String, Object> viewManagerBubblingEvents = viewManager.getExportedCustomBubblingEventTypeConstants();
            if (viewManagerBubblingEvents != null) {
                UIManagerModuleConstantsHelper.recursiveMerge(bubblingEventTypesConstants, viewManagerBubblingEvents);
            }
            if ((viewManagerDirectEvents = viewManager.getExportedCustomDirectEventTypeConstants()) != null) {
                UIManagerModuleConstantsHelper.recursiveMerge(directEventTypesConstants, viewManagerDirectEvents);
            }
            HashMap<String, Map<String, Object>> viewManagerConstants = MapBuilder.newHashMap();
            Map<String, Object> customViewConstants = viewManager.getExportedViewConstants();
            if (customViewConstants != null) {
                viewManagerConstants.put("Constants", customViewConstants);
            }
            if ((viewManagerCommands = viewManager.getCommandsMap()) != null) {
                viewManagerConstants.put("Commands", viewManagerCommands);
            }
            if (!(viewManagerNativeProps = viewManager.getNativeProps()).isEmpty()) {
                HashMap<String, String> nativeProps = new HashMap<String, String>();
                for (Map.Entry<String, UIProp.Type> entry : viewManagerNativeProps.entrySet()) {
                    nativeProps.put(entry.getKey(), entry.getValue().toString());
                }
                viewManagerConstants.put("NativeProps", nativeProps);
            }
            if (viewManagerConstants.isEmpty()) continue;
            constants.put(viewManager.getName(), viewManagerConstants);
        }
        constants.put(CUSTOM_BUBBLING_EVENT_TYPES_KEY, bubblingEventTypesConstants);
        constants.put(CUSTOM_DIRECT_EVENT_TYPES_KEY, directEventTypesConstants);
        return constants;
    }

    private static void recursiveMerge(Map dest, Map source) {
        for (Object key : source.keySet()) {
            Object sourceValue = source.get(key);
            Object destValue = dest.get(key);
            if (destValue != null && sourceValue instanceof Map && destValue instanceof Map) {
                UIManagerModuleConstantsHelper.recursiveMerge((Map)destValue, (Map)sourceValue);
                continue;
            }
            dest.put(key, sourceValue);
        }
    }
}

