/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.csslayout;

import com.facebook.csslayout.CSSAlign;
import com.facebook.csslayout.CSSConstants;
import com.facebook.csslayout.CSSDirection;
import com.facebook.csslayout.CSSFlexDirection;
import com.facebook.csslayout.CSSJustify;
import com.facebook.csslayout.CSSLayoutContext;
import com.facebook.csslayout.CSSNode;
import com.facebook.csslayout.CSSPositionType;
import com.facebook.csslayout.CSSWrap;
import com.facebook.csslayout.FloatUtil;
import com.facebook.csslayout.MeasureOutput;

public class LayoutEngine {
    private static void setLayoutPosition(CSSNode node, PositionIndex position, float value) {
        switch (position) {
            case TOP: {
                node.layout.top = value;
                break;
            }
            case LEFT: {
                node.layout.left = value;
                break;
            }
            case RIGHT: {
                node.layout.right = value;
                break;
            }
            case BOTTOM: {
                node.layout.bottom = value;
                break;
            }
            default: {
                throw new RuntimeException("Didn't get TOP, LEFT, RIGHT, or BOTTOM!");
            }
        }
    }

    private static float getLayoutPosition(CSSNode node, PositionIndex position) {
        switch (position) {
            case TOP: {
                return node.layout.top;
            }
            case LEFT: {
                return node.layout.left;
            }
            case RIGHT: {
                return node.layout.right;
            }
            case BOTTOM: {
                return node.layout.bottom;
            }
        }
        throw new RuntimeException("Didn't get TOP, LEFT, RIGHT, or BOTTOM!");
    }

    private static void setLayoutDimension(CSSNode node, DimensionIndex dimension, float value) {
        switch (dimension) {
            case WIDTH: {
                node.layout.width = value;
                break;
            }
            case HEIGHT: {
                node.layout.height = value;
                break;
            }
            default: {
                throw new RuntimeException("Someone added a third dimension...");
            }
        }
    }

    private static float getLayoutDimension(CSSNode node, DimensionIndex dimension) {
        switch (dimension) {
            case WIDTH: {
                return node.layout.width;
            }
            case HEIGHT: {
                return node.layout.height;
            }
        }
        throw new RuntimeException("Someone added a third dimension...");
    }

    private static void setLayoutDirection(CSSNode node, CSSDirection direction) {
        node.layout.direction = direction;
    }

    private static float getStylePosition(CSSNode node, PositionIndex position) {
        switch (position) {
            case TOP: {
                return node.style.positionTop;
            }
            case BOTTOM: {
                return node.style.positionBottom;
            }
            case LEFT: {
                return node.style.positionLeft;
            }
            case RIGHT: {
                return node.style.positionRight;
            }
        }
        throw new RuntimeException("Someone added a new cardinal direction...");
    }

    private static float getStyleDimension(CSSNode node, DimensionIndex dimension) {
        switch (dimension) {
            case WIDTH: {
                return node.style.width;
            }
            case HEIGHT: {
                return node.style.height;
            }
        }
        throw new RuntimeException("Someone added a third dimension...");
    }

    private static PositionIndex getLeading(CSSFlexDirection axis) {
        switch (axis) {
            case COLUMN: {
                return PositionIndex.TOP;
            }
            case COLUMN_REVERSE: {
                return PositionIndex.BOTTOM;
            }
            case ROW: {
                return PositionIndex.LEFT;
            }
            case ROW_REVERSE: {
                return PositionIndex.RIGHT;
            }
        }
        throw new RuntimeException("Didn't get TOP, LEFT, RIGHT, or BOTTOM!");
    }

    private static PositionIndex getTrailing(CSSFlexDirection axis) {
        switch (axis) {
            case COLUMN: {
                return PositionIndex.BOTTOM;
            }
            case COLUMN_REVERSE: {
                return PositionIndex.TOP;
            }
            case ROW: {
                return PositionIndex.RIGHT;
            }
            case ROW_REVERSE: {
                return PositionIndex.LEFT;
            }
        }
        throw new RuntimeException("Didn't get COLUMN, COLUMN_REVERSE, ROW, or ROW_REVERSE!");
    }

    private static PositionIndex getPos(CSSFlexDirection axis) {
        switch (axis) {
            case COLUMN: {
                return PositionIndex.TOP;
            }
            case COLUMN_REVERSE: {
                return PositionIndex.BOTTOM;
            }
            case ROW: {
                return PositionIndex.LEFT;
            }
            case ROW_REVERSE: {
                return PositionIndex.RIGHT;
            }
        }
        throw new RuntimeException("Didn't get COLUMN, COLUMN_REVERSE, ROW, or ROW_REVERSE!");
    }

    private static DimensionIndex getDim(CSSFlexDirection axis) {
        switch (axis) {
            case COLUMN: 
            case COLUMN_REVERSE: {
                return DimensionIndex.HEIGHT;
            }
            case ROW: 
            case ROW_REVERSE: {
                return DimensionIndex.WIDTH;
            }
        }
        throw new RuntimeException("Didn't get COLUMN, COLUMN_REVERSE, ROW, or ROW_REVERSE!");
    }

    private static boolean isDimDefined(CSSNode node, CSSFlexDirection axis) {
        float value = LayoutEngine.getStyleDimension(node, LayoutEngine.getDim(axis));
        return !CSSConstants.isUndefined(value) && (double)value > 0.0;
    }

    private static boolean isPosDefined(CSSNode node, PositionIndex position) {
        return !CSSConstants.isUndefined(LayoutEngine.getStylePosition(node, position));
    }

    private static float getPosition(CSSNode node, PositionIndex position) {
        float result = LayoutEngine.getStylePosition(node, position);
        return CSSConstants.isUndefined(result) ? 0.0f : result;
    }

    private static float getMargin(CSSNode node, PositionIndex position) {
        switch (position) {
            case TOP: {
                return node.style.margin.get(1);
            }
            case BOTTOM: {
                return node.style.margin.get(3);
            }
            case LEFT: {
                return node.style.margin.get(0);
            }
            case RIGHT: {
                return node.style.margin.get(2);
            }
            case START: {
                return node.style.margin.get(6);
            }
            case END: {
                return node.style.margin.get(7);
            }
        }
        throw new RuntimeException("Someone added a new cardinal direction...");
    }

    private static float getLeadingMargin(CSSNode node, CSSFlexDirection axis) {
        float leadingMargin;
        if (LayoutEngine.isRowDirection(axis) && !CSSConstants.isUndefined(leadingMargin = node.style.margin.getRaw(6))) {
            return leadingMargin;
        }
        return LayoutEngine.getMargin(node, LayoutEngine.getLeading(axis));
    }

    private static float getTrailingMargin(CSSNode node, CSSFlexDirection axis) {
        float trailingMargin;
        if (LayoutEngine.isRowDirection(axis) && !CSSConstants.isUndefined(trailingMargin = node.style.margin.getRaw(7))) {
            return trailingMargin;
        }
        return LayoutEngine.getMargin(node, LayoutEngine.getTrailing(axis));
    }

    private static float getPadding(CSSNode node, PositionIndex position) {
        switch (position) {
            case TOP: {
                return node.style.padding.get(1);
            }
            case BOTTOM: {
                return node.style.padding.get(3);
            }
            case LEFT: {
                return node.style.padding.get(0);
            }
            case RIGHT: {
                return node.style.padding.get(2);
            }
            case START: {
                return node.style.padding.get(6);
            }
            case END: {
                return node.style.padding.get(7);
            }
        }
        throw new RuntimeException("Someone added a new cardinal direction...");
    }

    private static float getLeadingPadding(CSSNode node, CSSFlexDirection axis) {
        float leadingPadding;
        if (LayoutEngine.isRowDirection(axis) && !CSSConstants.isUndefined(leadingPadding = node.style.padding.getRaw(6))) {
            return leadingPadding;
        }
        return LayoutEngine.getPadding(node, LayoutEngine.getLeading(axis));
    }

    private static float getTrailingPadding(CSSNode node, CSSFlexDirection axis) {
        float trailingPadding;
        if (LayoutEngine.isRowDirection(axis) && !CSSConstants.isUndefined(trailingPadding = node.style.padding.getRaw(7))) {
            return trailingPadding;
        }
        return LayoutEngine.getPadding(node, LayoutEngine.getTrailing(axis));
    }

    private static float getBorder(CSSNode node, PositionIndex position) {
        switch (position) {
            case TOP: {
                return node.style.border.get(1);
            }
            case BOTTOM: {
                return node.style.border.get(3);
            }
            case LEFT: {
                return node.style.border.get(0);
            }
            case RIGHT: {
                return node.style.border.get(2);
            }
            case START: {
                return node.style.border.get(6);
            }
            case END: {
                return node.style.border.get(7);
            }
        }
        throw new RuntimeException("Someone added a new cardinal direction...");
    }

    private static float getLeadingBorder(CSSNode node, CSSFlexDirection axis) {
        float leadingBorder;
        if (LayoutEngine.isRowDirection(axis) && !CSSConstants.isUndefined(leadingBorder = node.style.border.getRaw(6))) {
            return leadingBorder;
        }
        return LayoutEngine.getBorder(node, LayoutEngine.getLeading(axis));
    }

    private static float getTrailingBorder(CSSNode node, CSSFlexDirection axis) {
        float trailingBorder;
        if (LayoutEngine.isRowDirection(axis) && !CSSConstants.isUndefined(trailingBorder = node.style.border.getRaw(7))) {
            return trailingBorder;
        }
        return LayoutEngine.getBorder(node, LayoutEngine.getTrailing(axis));
    }

    private static float getLeadingPaddingAndBorder(CSSNode node, CSSFlexDirection axis) {
        return LayoutEngine.getLeadingPadding(node, axis) + LayoutEngine.getLeadingBorder(node, axis);
    }

    private static float getTrailingPaddingAndBorder(CSSNode node, CSSFlexDirection axis) {
        return LayoutEngine.getTrailingPadding(node, axis) + LayoutEngine.getTrailingBorder(node, axis);
    }

    private static float getBorderAxis(CSSNode node, CSSFlexDirection axis) {
        return LayoutEngine.getLeadingBorder(node, axis) + LayoutEngine.getTrailingBorder(node, axis);
    }

    private static float getMarginAxis(CSSNode node, CSSFlexDirection axis) {
        return LayoutEngine.getLeadingMargin(node, axis) + LayoutEngine.getTrailingMargin(node, axis);
    }

    private static float getPaddingAndBorderAxis(CSSNode node, CSSFlexDirection axis) {
        return LayoutEngine.getLeadingPaddingAndBorder(node, axis) + LayoutEngine.getTrailingPaddingAndBorder(node, axis);
    }

    private static float boundAxis(CSSNode node, CSSFlexDirection axis, float value) {
        float min = Float.NaN;
        float max = Float.NaN;
        if (LayoutEngine.isColumnDirection(axis)) {
            min = node.style.minHeight;
            max = node.style.maxHeight;
        } else if (LayoutEngine.isRowDirection(axis)) {
            min = node.style.minWidth;
            max = node.style.maxWidth;
        }
        float boundValue = value;
        if (!CSSConstants.isUndefined(max) && (double)max >= 0.0 && boundValue > max) {
            boundValue = max;
        }
        if (!CSSConstants.isUndefined(min) && (double)min >= 0.0 && boundValue < min) {
            boundValue = min;
        }
        return boundValue;
    }

    private static void setDimensionFromStyle(CSSNode node, CSSFlexDirection axis) {
        if (!CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(axis)))) {
            return;
        }
        if (!LayoutEngine.isDimDefined(node, axis)) {
            return;
        }
        float maxLayoutDimension = Math.max(LayoutEngine.boundAxis(node, axis, LayoutEngine.getStyleDimension(node, LayoutEngine.getDim(axis))), LayoutEngine.getPaddingAndBorderAxis(node, axis));
        LayoutEngine.setLayoutDimension(node, LayoutEngine.getDim(axis), maxLayoutDimension);
    }

    private static void setTrailingPosition(CSSNode node, CSSNode child, CSSFlexDirection axis) {
        LayoutEngine.setLayoutPosition(child, LayoutEngine.getTrailing(axis), LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(axis)) - LayoutEngine.getLayoutDimension(child, LayoutEngine.getDim(axis)) - LayoutEngine.getLayoutPosition(child, LayoutEngine.getPos(axis)));
    }

    private static float getRelativePosition(CSSNode node, CSSFlexDirection axis) {
        float lead = LayoutEngine.getStylePosition(node, LayoutEngine.getLeading(axis));
        if (!CSSConstants.isUndefined(lead)) {
            return lead;
        }
        return -LayoutEngine.getPosition(node, LayoutEngine.getTrailing(axis));
    }

    private static float getFlex(CSSNode node) {
        return node.style.flex;
    }

    private static boolean isRowDirection(CSSFlexDirection flexDirection) {
        return flexDirection == CSSFlexDirection.ROW || flexDirection == CSSFlexDirection.ROW_REVERSE;
    }

    private static boolean isColumnDirection(CSSFlexDirection flexDirection) {
        return flexDirection == CSSFlexDirection.COLUMN || flexDirection == CSSFlexDirection.COLUMN_REVERSE;
    }

    private static CSSFlexDirection resolveAxis(CSSFlexDirection axis, CSSDirection direction) {
        if (direction == CSSDirection.RTL) {
            if (axis == CSSFlexDirection.ROW) {
                return CSSFlexDirection.ROW_REVERSE;
            }
            if (axis == CSSFlexDirection.ROW_REVERSE) {
                return CSSFlexDirection.ROW;
            }
        }
        return axis;
    }

    private static CSSDirection resolveDirection(CSSNode node, CSSDirection parentDirection) {
        CSSDirection direction = node.style.direction;
        if (direction == CSSDirection.INHERIT) {
            direction = parentDirection == null ? CSSDirection.LTR : parentDirection;
        }
        return direction;
    }

    private static CSSFlexDirection getFlexDirection(CSSNode node) {
        return node.style.flexDirection;
    }

    private static CSSFlexDirection getCrossFlexDirection(CSSFlexDirection flexDirection, CSSDirection direction) {
        if (LayoutEngine.isColumnDirection(flexDirection)) {
            return LayoutEngine.resolveAxis(CSSFlexDirection.ROW, direction);
        }
        return CSSFlexDirection.COLUMN;
    }

    private static CSSPositionType getPositionType(CSSNode node) {
        return node.style.positionType;
    }

    private static CSSAlign getAlignItem(CSSNode node, CSSNode child) {
        if (child.style.alignSelf != CSSAlign.AUTO) {
            return child.style.alignSelf;
        }
        return node.style.alignItems;
    }

    private static CSSAlign getAlignContent(CSSNode node) {
        return node.style.alignContent;
    }

    private static CSSJustify getJustifyContent(CSSNode node) {
        return node.style.justifyContent;
    }

    private static boolean isFlexWrap(CSSNode node) {
        return node.style.flexWrap == CSSWrap.WRAP;
    }

    private static boolean isFlex(CSSNode node) {
        return LayoutEngine.getPositionType(node) == CSSPositionType.RELATIVE && LayoutEngine.getFlex(node) > 0.0f;
    }

    private static boolean isMeasureDefined(CSSNode node) {
        return node.isMeasureDefined();
    }

    private static float getDimWithMargin(CSSNode node, CSSFlexDirection axis) {
        return LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(axis)) + LayoutEngine.getLeadingMargin(node, axis) + LayoutEngine.getTrailingMargin(node, axis);
    }

    private static boolean needsRelayout(CSSNode node, float parentMaxWidth) {
        return node.isDirty() || !FloatUtil.floatsEqual(node.lastLayout.requestedHeight, node.layout.height) || !FloatUtil.floatsEqual(node.lastLayout.requestedWidth, node.layout.width) || !FloatUtil.floatsEqual(node.lastLayout.parentMaxWidth, parentMaxWidth);
    }

    static void layoutNode(CSSLayoutContext layoutContext, CSSNode node, float parentMaxWidth, CSSDirection parentDirection) {
        if (LayoutEngine.needsRelayout(node, parentMaxWidth)) {
            node.lastLayout.requestedWidth = node.layout.width;
            node.lastLayout.requestedHeight = node.layout.height;
            node.lastLayout.parentMaxWidth = parentMaxWidth;
            LayoutEngine.layoutNodeImpl(layoutContext, node, parentMaxWidth, parentDirection);
            node.lastLayout.copy(node.layout);
        } else {
            node.layout.copy(node.lastLayout);
        }
        node.markHasNewLayout();
    }

    private static void layoutNodeImpl(CSSLayoutContext layoutContext, CSSNode node, float parentMaxWidth, CSSDirection parentDirection) {
        CSSFlexDirection axis;
        int ii;
        int i;
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            node.getChildAt((int)i2).layout.resetResult();
        }
        CSSDirection direction = LayoutEngine.resolveDirection(node, parentDirection);
        CSSFlexDirection mainAxis = LayoutEngine.resolveAxis(LayoutEngine.getFlexDirection(node), direction);
        CSSFlexDirection crossAxis = LayoutEngine.getCrossFlexDirection(mainAxis, direction);
        CSSFlexDirection resolvedRowAxis = LayoutEngine.resolveAxis(CSSFlexDirection.ROW, direction);
        LayoutEngine.setDimensionFromStyle(node, mainAxis);
        LayoutEngine.setDimensionFromStyle(node, crossAxis);
        LayoutEngine.setLayoutDirection(node, direction);
        LayoutEngine.setLayoutPosition(node, LayoutEngine.getLeading(mainAxis), LayoutEngine.getLayoutPosition(node, LayoutEngine.getLeading(mainAxis)) + LayoutEngine.getLeadingMargin(node, mainAxis) + LayoutEngine.getRelativePosition(node, mainAxis));
        LayoutEngine.setLayoutPosition(node, LayoutEngine.getTrailing(mainAxis), LayoutEngine.getLayoutPosition(node, LayoutEngine.getTrailing(mainAxis)) + LayoutEngine.getTrailingMargin(node, mainAxis) + LayoutEngine.getRelativePosition(node, mainAxis));
        LayoutEngine.setLayoutPosition(node, LayoutEngine.getLeading(crossAxis), LayoutEngine.getLayoutPosition(node, LayoutEngine.getLeading(crossAxis)) + LayoutEngine.getLeadingMargin(node, crossAxis) + LayoutEngine.getRelativePosition(node, crossAxis));
        LayoutEngine.setLayoutPosition(node, LayoutEngine.getTrailing(crossAxis), LayoutEngine.getLayoutPosition(node, LayoutEngine.getTrailing(crossAxis)) + LayoutEngine.getTrailingMargin(node, crossAxis) + LayoutEngine.getRelativePosition(node, crossAxis));
        if (LayoutEngine.isMeasureDefined(node)) {
            boolean isColumnUndefined;
            float width = Float.NaN;
            width = LayoutEngine.isDimDefined(node, resolvedRowAxis) ? node.style.width : (!CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(resolvedRowAxis))) ? LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(resolvedRowAxis)) : parentMaxWidth - LayoutEngine.getMarginAxis(node, resolvedRowAxis));
            width -= LayoutEngine.getPaddingAndBorderAxis(node, resolvedRowAxis);
            boolean isRowUndefined = !LayoutEngine.isDimDefined(node, resolvedRowAxis) && CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(resolvedRowAxis)));
            boolean bl = isColumnUndefined = !LayoutEngine.isDimDefined(node, CSSFlexDirection.COLUMN) && CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(CSSFlexDirection.COLUMN)));
            if (isRowUndefined || isColumnUndefined) {
                MeasureOutput measureDim = node.measure(layoutContext.measureOutput, width);
                if (isRowUndefined) {
                    node.layout.width = measureDim.width + LayoutEngine.getPaddingAndBorderAxis(node, resolvedRowAxis);
                }
                if (isColumnUndefined) {
                    node.layout.height = measureDim.height + LayoutEngine.getPaddingAndBorderAxis(node, CSSFlexDirection.COLUMN);
                }
            }
            if (node.getChildCount() == 0) {
                return;
            }
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            CSSNode child = node.getChildAt(i);
            if (LayoutEngine.getAlignItem(node, child) == CSSAlign.STRETCH && LayoutEngine.getPositionType(child) == CSSPositionType.RELATIVE && !CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(crossAxis))) && !LayoutEngine.isDimDefined(child, crossAxis)) {
                LayoutEngine.setLayoutDimension(child, LayoutEngine.getDim(crossAxis), Math.max(LayoutEngine.boundAxis(child, crossAxis, LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(crossAxis)) - LayoutEngine.getPaddingAndBorderAxis(node, crossAxis) - LayoutEngine.getMarginAxis(child, crossAxis)), LayoutEngine.getPaddingAndBorderAxis(child, crossAxis)));
                continue;
            }
            if (LayoutEngine.getPositionType(child) != CSSPositionType.ABSOLUTE) continue;
            for (ii = 0; ii < 2; ++ii) {
                CSSFlexDirection cSSFlexDirection = axis = ii != 0 ? CSSFlexDirection.ROW : CSSFlexDirection.COLUMN;
                if (CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(axis))) || LayoutEngine.isDimDefined(child, axis) || !LayoutEngine.isPosDefined(child, LayoutEngine.getLeading(axis)) || !LayoutEngine.isPosDefined(child, LayoutEngine.getTrailing(axis))) continue;
                LayoutEngine.setLayoutDimension(child, LayoutEngine.getDim(axis), Math.max(LayoutEngine.boundAxis(child, axis, LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(axis)) - LayoutEngine.getPaddingAndBorderAxis(node, axis) - LayoutEngine.getMarginAxis(child, axis) - LayoutEngine.getPosition(child, LayoutEngine.getLeading(axis)) - LayoutEngine.getPosition(child, LayoutEngine.getTrailing(axis))), LayoutEngine.getPaddingAndBorderAxis(child, axis)));
            }
        }
        float definedMainDim = Float.NaN;
        if (!CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(mainAxis)))) {
            definedMainDim = LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(mainAxis)) - LayoutEngine.getPaddingAndBorderAxis(node, mainAxis);
        }
        int startLine = 0;
        int endLine = 0;
        boolean alreadyComputedNextLayout = false;
        float linesCrossDim = 0.0f;
        float linesMainDim = 0.0f;
        int linesCount = 0;
        while (endLine < node.getChildCount()) {
            float maxWidth;
            float mainContentDim = 0.0f;
            int flexibleChildrenCount = 0;
            float totalFlexible = 0.0f;
            int nonFlexibleChildrenCount = 0;
            for (i = startLine; i < node.getChildCount(); ++i) {
                CSSNode child = node.getChildAt(i);
                float nextContentDim = 0.0f;
                if (!CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(mainAxis))) && LayoutEngine.isFlex(child)) {
                    ++flexibleChildrenCount;
                    totalFlexible += LayoutEngine.getFlex(child);
                    nextContentDim = LayoutEngine.getPaddingAndBorderAxis(child, mainAxis) + LayoutEngine.getMarginAxis(child, mainAxis);
                } else {
                    maxWidth = Float.NaN;
                    if (!LayoutEngine.isRowDirection(mainAxis)) {
                        maxWidth = parentMaxWidth - LayoutEngine.getMarginAxis(node, resolvedRowAxis) - LayoutEngine.getPaddingAndBorderAxis(node, resolvedRowAxis);
                        if (LayoutEngine.isDimDefined(node, resolvedRowAxis)) {
                            maxWidth = LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(resolvedRowAxis)) - LayoutEngine.getPaddingAndBorderAxis(node, resolvedRowAxis);
                        }
                    }
                    if (!alreadyComputedNextLayout) {
                        LayoutEngine.layoutNode(layoutContext, child, maxWidth, direction);
                    }
                    if (LayoutEngine.getPositionType(child) == CSSPositionType.RELATIVE) {
                        ++nonFlexibleChildrenCount;
                        nextContentDim = LayoutEngine.getDimWithMargin(child, mainAxis);
                    }
                }
                if (LayoutEngine.isFlexWrap(node) && !CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(mainAxis))) && mainContentDim + nextContentDim > definedMainDim && i != startLine) {
                    --nonFlexibleChildrenCount;
                    alreadyComputedNextLayout = true;
                    break;
                }
                alreadyComputedNextLayout = false;
                mainContentDim += nextContentDim;
                endLine = i + 1;
            }
            float leadingMainDim = 0.0f;
            float betweenMainDim = 0.0f;
            float remainingMainDim = 0.0f;
            remainingMainDim = !CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(mainAxis))) ? definedMainDim - mainContentDim : Math.max(mainContentDim, 0.0f) - mainContentDim;
            if (flexibleChildrenCount != 0) {
                float flexibleMainDim = remainingMainDim / totalFlexible;
                for (i = startLine; i < endLine; ++i) {
                    float boundMainDim;
                    float baseMainDim;
                    CSSNode child = node.getChildAt(i);
                    if (!LayoutEngine.isFlex(child) || (baseMainDim = flexibleMainDim * LayoutEngine.getFlex(child) + LayoutEngine.getPaddingAndBorderAxis(child, mainAxis)) == (boundMainDim = LayoutEngine.boundAxis(child, mainAxis, baseMainDim))) continue;
                    remainingMainDim -= boundMainDim;
                    totalFlexible -= LayoutEngine.getFlex(child);
                }
                flexibleMainDim = remainingMainDim / totalFlexible;
                if (flexibleMainDim < 0.0f) {
                    flexibleMainDim = 0.0f;
                }
                for (i = startLine; i < endLine; ++i) {
                    CSSNode child = node.getChildAt(i);
                    if (!LayoutEngine.isFlex(child)) continue;
                    LayoutEngine.setLayoutDimension(child, LayoutEngine.getDim(mainAxis), LayoutEngine.boundAxis(child, mainAxis, flexibleMainDim * LayoutEngine.getFlex(child) + LayoutEngine.getPaddingAndBorderAxis(child, mainAxis)));
                    maxWidth = Float.NaN;
                    if (LayoutEngine.isDimDefined(node, resolvedRowAxis)) {
                        maxWidth = LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(resolvedRowAxis)) - LayoutEngine.getPaddingAndBorderAxis(node, resolvedRowAxis);
                    } else if (!LayoutEngine.isRowDirection(mainAxis)) {
                        maxWidth = parentMaxWidth - LayoutEngine.getMarginAxis(node, resolvedRowAxis) - LayoutEngine.getPaddingAndBorderAxis(node, resolvedRowAxis);
                    }
                    LayoutEngine.layoutNode(layoutContext, child, maxWidth, direction);
                }
            } else {
                CSSJustify justifyContent = LayoutEngine.getJustifyContent(node);
                if (justifyContent == CSSJustify.CENTER) {
                    leadingMainDim = remainingMainDim / 2.0f;
                } else if (justifyContent == CSSJustify.FLEX_END) {
                    leadingMainDim = remainingMainDim;
                } else if (justifyContent == CSSJustify.SPACE_BETWEEN) {
                    remainingMainDim = Math.max(remainingMainDim, 0.0f);
                    betweenMainDim = flexibleChildrenCount + nonFlexibleChildrenCount - 1 != 0 ? remainingMainDim / (float)(flexibleChildrenCount + nonFlexibleChildrenCount - 1) : 0.0f;
                } else if (justifyContent == CSSJustify.SPACE_AROUND) {
                    betweenMainDim = remainingMainDim / (float)(flexibleChildrenCount + nonFlexibleChildrenCount);
                    leadingMainDim = betweenMainDim / 2.0f;
                }
            }
            float crossDim = 0.0f;
            float mainDim = leadingMainDim + LayoutEngine.getLeadingPaddingAndBorder(node, mainAxis);
            for (i = startLine; i < endLine; ++i) {
                CSSNode child = node.getChildAt(i);
                child.lineIndex = linesCount;
                if (LayoutEngine.getPositionType(child) == CSSPositionType.ABSOLUTE && LayoutEngine.isPosDefined(child, LayoutEngine.getLeading(mainAxis))) {
                    LayoutEngine.setLayoutPosition(child, LayoutEngine.getPos(mainAxis), LayoutEngine.getPosition(child, LayoutEngine.getLeading(mainAxis)) + LayoutEngine.getLeadingBorder(node, mainAxis) + LayoutEngine.getLeadingMargin(child, mainAxis));
                } else {
                    LayoutEngine.setLayoutPosition(child, LayoutEngine.getPos(mainAxis), LayoutEngine.getLayoutPosition(child, LayoutEngine.getPos(mainAxis)) + mainDim);
                    if (!CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(mainAxis)))) {
                        LayoutEngine.setTrailingPosition(node, child, mainAxis);
                    }
                }
                if (LayoutEngine.getPositionType(child) != CSSPositionType.RELATIVE) continue;
                mainDim = mainDim + betweenMainDim + LayoutEngine.getDimWithMargin(child, mainAxis);
                crossDim = Math.max(crossDim, LayoutEngine.boundAxis(child, crossAxis, LayoutEngine.getDimWithMargin(child, crossAxis)));
            }
            float containerCrossAxis = LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(crossAxis));
            if (CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(crossAxis)))) {
                containerCrossAxis = Math.max(LayoutEngine.boundAxis(node, crossAxis, crossDim + LayoutEngine.getPaddingAndBorderAxis(node, crossAxis)), LayoutEngine.getPaddingAndBorderAxis(node, crossAxis));
            }
            for (i = startLine; i < endLine; ++i) {
                CSSNode child = node.getChildAt(i);
                if (LayoutEngine.getPositionType(child) == CSSPositionType.ABSOLUTE && LayoutEngine.isPosDefined(child, LayoutEngine.getLeading(crossAxis))) {
                    LayoutEngine.setLayoutPosition(child, LayoutEngine.getPos(crossAxis), LayoutEngine.getPosition(child, LayoutEngine.getLeading(crossAxis)) + LayoutEngine.getLeadingBorder(node, crossAxis) + LayoutEngine.getLeadingMargin(child, crossAxis));
                    continue;
                }
                float leadingCrossDim = LayoutEngine.getLeadingPaddingAndBorder(node, crossAxis);
                if (LayoutEngine.getPositionType(child) == CSSPositionType.RELATIVE) {
                    CSSAlign alignItem = LayoutEngine.getAlignItem(node, child);
                    if (alignItem == CSSAlign.STRETCH) {
                        if (!LayoutEngine.isDimDefined(child, crossAxis)) {
                            LayoutEngine.setLayoutDimension(child, LayoutEngine.getDim(crossAxis), Math.max(LayoutEngine.boundAxis(child, crossAxis, containerCrossAxis - LayoutEngine.getPaddingAndBorderAxis(node, crossAxis) - LayoutEngine.getMarginAxis(child, crossAxis)), LayoutEngine.getPaddingAndBorderAxis(child, crossAxis)));
                        }
                    } else if (alignItem != CSSAlign.FLEX_START) {
                        float remainingCrossDim = containerCrossAxis - LayoutEngine.getPaddingAndBorderAxis(node, crossAxis) - LayoutEngine.getDimWithMargin(child, crossAxis);
                        leadingCrossDim = alignItem == CSSAlign.CENTER ? (leadingCrossDim += remainingCrossDim / 2.0f) : (leadingCrossDim += remainingCrossDim);
                    }
                }
                LayoutEngine.setLayoutPosition(child, LayoutEngine.getPos(crossAxis), LayoutEngine.getLayoutPosition(child, LayoutEngine.getPos(crossAxis)) + linesCrossDim + leadingCrossDim);
                if (CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(crossAxis)))) continue;
                LayoutEngine.setTrailingPosition(node, child, crossAxis);
            }
            linesCrossDim += crossDim;
            linesMainDim = Math.max(linesMainDim, mainDim);
            ++linesCount;
            startLine = endLine;
        }
        if (linesCount > 1 && !CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(crossAxis)))) {
            float nodeCrossAxisInnerSize = LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(crossAxis)) - LayoutEngine.getPaddingAndBorderAxis(node, crossAxis);
            float remainingAlignContentDim = nodeCrossAxisInnerSize - linesCrossDim;
            float crossDimLead = 0.0f;
            float currentLead = LayoutEngine.getLeadingPaddingAndBorder(node, crossAxis);
            CSSAlign alignContent = LayoutEngine.getAlignContent(node);
            if (alignContent == CSSAlign.FLEX_END) {
                currentLead += remainingAlignContentDim;
            } else if (alignContent == CSSAlign.CENTER) {
                currentLead += remainingAlignContentDim / 2.0f;
            } else if (alignContent == CSSAlign.STRETCH && nodeCrossAxisInnerSize > linesCrossDim) {
                crossDimLead = remainingAlignContentDim / (float)linesCount;
            }
            int endIndex = 0;
            for (i = 0; i < linesCount; ++i) {
                int startIndex = endIndex;
                float lineHeight = 0.0f;
                for (ii = startIndex; ii < node.getChildCount(); ++ii) {
                    CSSNode child = node.getChildAt(ii);
                    if (LayoutEngine.getPositionType(child) != CSSPositionType.RELATIVE) continue;
                    if (child.lineIndex != i) break;
                    if (CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(child, LayoutEngine.getDim(crossAxis)))) continue;
                    lineHeight = Math.max(lineHeight, LayoutEngine.getLayoutDimension(child, LayoutEngine.getDim(crossAxis)) + LayoutEngine.getMarginAxis(child, crossAxis));
                }
                endIndex = ii;
                lineHeight += crossDimLead;
                for (ii = startIndex; ii < endIndex; ++ii) {
                    CSSNode child = node.getChildAt(ii);
                    if (LayoutEngine.getPositionType(child) != CSSPositionType.RELATIVE) continue;
                    CSSAlign alignContentAlignItem = LayoutEngine.getAlignItem(node, child);
                    if (alignContentAlignItem == CSSAlign.FLEX_START) {
                        LayoutEngine.setLayoutPosition(child, LayoutEngine.getPos(crossAxis), currentLead + LayoutEngine.getLeadingMargin(child, crossAxis));
                        continue;
                    }
                    if (alignContentAlignItem == CSSAlign.FLEX_END) {
                        LayoutEngine.setLayoutPosition(child, LayoutEngine.getPos(crossAxis), currentLead + lineHeight - LayoutEngine.getTrailingMargin(child, crossAxis) - LayoutEngine.getLayoutDimension(child, LayoutEngine.getDim(crossAxis)));
                        continue;
                    }
                    if (alignContentAlignItem == CSSAlign.CENTER) {
                        float childHeight = LayoutEngine.getLayoutDimension(child, LayoutEngine.getDim(crossAxis));
                        LayoutEngine.setLayoutPosition(child, LayoutEngine.getPos(crossAxis), currentLead + (lineHeight - childHeight) / 2.0f);
                        continue;
                    }
                    if (alignContentAlignItem != CSSAlign.STRETCH) continue;
                    LayoutEngine.setLayoutPosition(child, LayoutEngine.getPos(crossAxis), currentLead + LayoutEngine.getLeadingMargin(child, crossAxis));
                }
                currentLead += lineHeight;
            }
        }
        boolean needsMainTrailingPos = false;
        boolean needsCrossTrailingPos = false;
        if (CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(mainAxis)))) {
            LayoutEngine.setLayoutDimension(node, LayoutEngine.getDim(mainAxis), Math.max(LayoutEngine.boundAxis(node, mainAxis, linesMainDim + LayoutEngine.getTrailingPaddingAndBorder(node, mainAxis)), LayoutEngine.getPaddingAndBorderAxis(node, mainAxis)));
            needsMainTrailingPos = true;
        }
        if (CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(crossAxis)))) {
            LayoutEngine.setLayoutDimension(node, LayoutEngine.getDim(crossAxis), Math.max(LayoutEngine.boundAxis(node, crossAxis, linesCrossDim + LayoutEngine.getPaddingAndBorderAxis(node, crossAxis)), LayoutEngine.getPaddingAndBorderAxis(node, crossAxis)));
            needsCrossTrailingPos = true;
        }
        if (needsMainTrailingPos || needsCrossTrailingPos) {
            for (i = 0; i < node.getChildCount(); ++i) {
                CSSNode child = node.getChildAt(i);
                if (needsMainTrailingPos) {
                    LayoutEngine.setTrailingPosition(node, child, mainAxis);
                }
                if (!needsCrossTrailingPos) continue;
                LayoutEngine.setTrailingPosition(node, child, crossAxis);
            }
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            CSSNode child = node.getChildAt(i);
            if (LayoutEngine.getPositionType(child) != CSSPositionType.ABSOLUTE) continue;
            for (ii = 0; ii < 2; ++ii) {
                CSSFlexDirection cSSFlexDirection = axis = ii != 0 ? CSSFlexDirection.ROW : CSSFlexDirection.COLUMN;
                if (CSSConstants.isUndefined(LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(axis))) || LayoutEngine.isDimDefined(child, axis) || !LayoutEngine.isPosDefined(child, LayoutEngine.getLeading(axis)) || !LayoutEngine.isPosDefined(child, LayoutEngine.getTrailing(axis))) continue;
                LayoutEngine.setLayoutDimension(child, LayoutEngine.getDim(axis), Math.max(LayoutEngine.boundAxis(child, axis, LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(axis)) - LayoutEngine.getBorderAxis(node, axis) - LayoutEngine.getMarginAxis(child, axis) - LayoutEngine.getPosition(child, LayoutEngine.getLeading(axis)) - LayoutEngine.getPosition(child, LayoutEngine.getTrailing(axis))), LayoutEngine.getPaddingAndBorderAxis(child, axis)));
            }
            for (ii = 0; ii < 2; ++ii) {
                CSSFlexDirection cSSFlexDirection = axis = ii != 0 ? CSSFlexDirection.ROW : CSSFlexDirection.COLUMN;
                if (!LayoutEngine.isPosDefined(child, LayoutEngine.getTrailing(axis)) || LayoutEngine.isPosDefined(child, LayoutEngine.getLeading(axis))) continue;
                LayoutEngine.setLayoutPosition(child, LayoutEngine.getLeading(axis), LayoutEngine.getLayoutDimension(node, LayoutEngine.getDim(axis)) - LayoutEngine.getLayoutDimension(child, LayoutEngine.getDim(axis)) - LayoutEngine.getPosition(child, LayoutEngine.getTrailing(axis)));
            }
        }
    }

    private static enum DimensionIndex {
        WIDTH,
        HEIGHT;

    }

    private static enum PositionIndex {
        TOP,
        LEFT,
        BOTTOM,
        RIGHT,
        START,
        END;

    }
}

