/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.virtualview;

import android.content.Context;
import android.view.View;
import com.facebook.common.logging.FLog;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.viewmanagers.VirtualViewManagerDelegate;
import com.facebook.react.viewmanagers.VirtualViewManagerInterface;
import com.facebook.react.views.virtualview.ReactVirtualView;
import com.facebook.react.views.virtualview.ReactVirtualViewKt;
import com.facebook.react.views.virtualview.VirtualViewEventEmitter;
import com.facebook.react.views.virtualview.VirtualViewMode;
import com.facebook.react.views.virtualview.VirtualViewRenderState;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="VirtualView")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0001\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0016H\u0017J\u001a\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014R*\u0010\u0006\u001a\u001e\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00020\u0002\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00000\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/views/virtualview/ReactVirtualViewManager;", "Lcom/facebook/react/uimanager/ViewGroupManager;", "Lcom/facebook/react/views/virtualview/ReactVirtualView;", "Lcom/facebook/react/viewmanagers/VirtualViewManagerInterface;", "<init>", "()V", "_delegate", "Lcom/facebook/react/viewmanagers/VirtualViewManagerDelegate;", "kotlin.jvm.PlatformType", "getDelegate", "Lcom/facebook/react/uimanager/ViewManagerDelegate;", "getName", "", "createViewInstance", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "setInitialHidden", "", "view", "value", "", "setRenderState", "", "setNativeId", "nativeId", "addEventEmitters", "prepareToRecycleView", "Companion", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nReactVirtualViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactVirtualViewManager.kt\ncom/facebook/react/views/virtualview/ReactVirtualViewManager\n+ 2 ReactVirtualView.kt\ncom/facebook/react/views/virtualview/ReactVirtualView\n*L\n1#1,103:1\n359#2,9:104\n*S KotlinDebug\n*F\n+ 1 ReactVirtualViewManager.kt\ncom/facebook/react/views/virtualview/ReactVirtualViewManager\n*L\n58#1:104,9\n*E\n"})
public final class ReactVirtualViewManager
extends ViewGroupManager<ReactVirtualView>
implements VirtualViewManagerInterface<ReactVirtualView> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualViewManagerDelegate<ReactVirtualView, ReactVirtualViewManager> _delegate = new VirtualViewManagerDelegate(this);
    @NotNull
    public static final String REACT_CLASS = "VirtualView";

    public ReactVirtualViewManager() {
        super(null, 1, null);
    }

    @Override
    @NotNull
    protected ViewManagerDelegate<ReactVirtualView> getDelegate() {
        return this._delegate;
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    @NotNull
    protected ReactVirtualView createViewInstance(@NotNull ThemedReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        return new ReactVirtualView((Context)reactContext);
    }

    @Override
    @ReactProp(name="initialHidden")
    public void setInitialHidden(@NotNull ReactVirtualView view, boolean value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.getMode$ReactAndroid_release() == null) {
            view.setMode$ReactAndroid_release(value ? VirtualViewMode.Hidden : VirtualViewMode.Visible);
        }
    }

    @Override
    @ReactProp(name="renderState")
    public void setRenderState(@NotNull ReactVirtualView view, int value) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ReactNativeFeatureFlags.enableVirtualViewRenderState()) {
            view.setRenderState$ReactAndroid_release(switch (value) {
                case 1 -> VirtualViewRenderState.Rendered;
                case 2 -> VirtualViewRenderState.None;
                default -> VirtualViewRenderState.Unknown;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setNativeId(@NotNull ReactVirtualView view, @Nullable String nativeId) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.setNativeId((View)view, nativeId);
        ReactVirtualView reactVirtualView = view;
        String subtag$iv = "setNativeId";
        boolean $i$f$debugLog$ReactAndroid_release = false;
        if (this_$iv.getDebugLogEnabled$ReactAndroid_release()) {
            if (ReactVirtualViewKt.access$getIS_DEBUG_BUILD$p()) {
                String string2 = "ReactVirtualView:" + subtag$iv;
                boolean bl = false;
                FLog.d((String)string2, (String)(String.valueOf(view.getId()) + " [" + this_$iv.getId() + "][" + this_$iv.getNativeId$ReactAndroid_release() + "]"));
            } else {
                String string3 = "ReactVirtualView:" + subtag$iv;
                boolean bl = false;
                FLog.w((String)string3, (String)(String.valueOf(view.getId()) + " [" + this_$iv.getId() + "][" + this_$iv.getNativeId$ReactAndroid_release() + "]"));
            }
        }
    }

    @Override
    protected void addEventEmitters(@NotNull ThemedReactContext reactContext, @NotNull ReactVirtualView view) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag(reactContext, view.getId());
        if (eventDispatcher == null) {
            return;
        }
        EventDispatcher dispatcher = eventDispatcher;
        view.setModeChangeEmitter$ReactAndroid_release(new VirtualViewEventEmitter(view.getId(), UIManagerHelper.getSurfaceId((Context)reactContext), dispatcher));
    }

    @Override
    @Nullable
    protected ReactVirtualView prepareToRecycleView(@NotNull ThemedReactContext reactContext, @NotNull ReactVirtualView view) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.recycleView$ReactAndroid_release();
        return (ReactVirtualView)super.prepareToRecycleView(reactContext, (View)view);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/virtualview/ReactVirtualViewManager$Companion;", "", "<init>", "()V", "REACT_CLASS", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

