/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.os.Build;
import android.text.Spannable;
import android.text.Spanned;
import android.view.View;
import android.widget.TextView;
import com.facebook.react.R;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.common.mapbuffer.ReadableMapBuffer;
import com.facebook.react.internal.SystraceSection;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.IViewManagerWithChildren;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactTextAnchorViewManager;
import com.facebook.react.views.text.ReactTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextView;
import com.facebook.react.views.text.ReactTextViewAccessibilityDelegate;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.TextAttributeProps;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.react.views.text.internal.span.TextInlineImageSpan;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="RCTText")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u00014B\u0015\b\u0007\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\fH\u0014J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\fH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0018\u0018\u00010(H\u0016J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+H\u0016J0\u0010,\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020.2\u0006\u00101\u001a\u00020.H\u0016J\u001a\u00102\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\f2\b\u00103\u001a\u0004\u0018\u00010\u0011H\u0007R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0007\u00a8\u00065"}, d2={"Lcom/facebook/react/views/text/ReactTextViewManager;", "Lcom/facebook/react/views/text/ReactTextAnchorViewManager;", "Lcom/facebook/react/views/text/ReactTextShadowNode;", "Lcom/facebook/react/uimanager/IViewManagerWithChildren;", "Lcom/facebook/react/views/text/ReactTextViewManagerCallback;", "reactTextViewManagerCallback", "<init>", "(Lcom/facebook/react/views/text/ReactTextViewManagerCallback;)V", "getReactTextViewManagerCallback", "()Lcom/facebook/react/views/text/ReactTextViewManagerCallback;", "setReactTextViewManagerCallback", "prepareToRecycleView", "Lcom/facebook/react/views/text/ReactTextView;", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "view", "getName", "", "updateViewAccessibility", "", "createViewInstance", "context", "updateExtraData", "extraData", "", "createShadowNodeInstance", "getShadowNodeClass", "Ljava/lang/Class;", "onAfterUpdateTransaction", "needsCustomLayoutForChildren", "", "updateState", "props", "Lcom/facebook/react/uimanager/ReactStylesDiffMap;", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getReactTextUpdate", "state", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "getExportedCustomDirectEventTypeConstants", "", "onPostProcessSpannable", "text", "Landroid/text/Spannable;", "setPadding", "left", "", "top", "right", "bottom", "setOverflow", "overflow", "Companion", "ReactAndroid_release"})
public final class ReactTextViewManager
extends ReactTextAnchorViewManager<ReactTextShadowNode>
implements IViewManagerWithChildren,
ReactTextViewManagerCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ReactTextViewManagerCallback reactTextViewManagerCallback;
    private static final short TX_STATE_KEY_ATTRIBUTED_STRING = 0;
    private static final short TX_STATE_KEY_PARAGRAPH_ATTRIBUTES = 1;
    @NotNull
    public static final String REACT_CLASS = "RCTText";

    @JvmOverloads
    public ReactTextViewManager(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        this.reactTextViewManagerCallback = reactTextViewManagerCallback;
        if (ReactNativeFeatureFlags.enableViewRecyclingForText()) {
            this.setupViewRecycling();
        }
    }

    public /* synthetic */ ReactTextViewManager(ReactTextViewManagerCallback reactTextViewManagerCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            reactTextViewManagerCallback = null;
        }
        this(reactTextViewManagerCallback);
    }

    @Nullable
    protected final ReactTextViewManagerCallback getReactTextViewManagerCallback() {
        return this.reactTextViewManagerCallback;
    }

    protected final void setReactTextViewManagerCallback(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        this.reactTextViewManagerCallback = reactTextViewManagerCallback;
    }

    @Override
    @Nullable
    protected ReactTextView prepareToRecycleView(@NotNull ThemedReactContext reactContext, @NotNull ReactTextView view) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ReactTextView preparedView = (ReactTextView)super.prepareToRecycleView(reactContext, (View)view);
        if (preparedView != null) {
            preparedView.recycleView();
            this.setSelectionColor$ReactAndroid_release(preparedView, null);
        }
        return preparedView;
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected void updateViewAccessibility(@NotNull ReactTextView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ReactTextViewAccessibilityDelegate.Companion.setDelegate((View)view, view.isFocusable(), view.getImportantForAccessibility());
    }

    @Override
    @NotNull
    public ReactTextView createViewInstance(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new ReactTextView((Context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExtraData(@NotNull ReactTextView view, @NotNull Object extraData) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        AutoCloseable autoCloseable = new SystraceSection("ReactTextViewManager.updateExtraData");
        Throwable throwable = null;
        try {
            SystraceSection s = (SystraceSection)autoCloseable;
            boolean bl = false;
            ReactTextUpdate update = (ReactTextUpdate)extraData;
            Spannable spannable = update.getText();
            if (update.containsImages()) {
                TextInlineImageSpan.Companion.possiblyUpdateInlineImageSpans(spannable, (TextView)view);
            }
            view.setText(update);
            ReactTextViewAccessibilityDelegate.AccessibilityLinks accessibilityLinks = new ReactTextViewAccessibilityDelegate.AccessibilityLinks((Spanned)spannable);
            view.setTag(R.id.accessibility_links, accessibilityLinks.size() > 0 ? accessibilityLinks : null);
            ReactTextViewAccessibilityDelegate.Companion.resetDelegate((View)view, view.isFocusable(), view.getImportantForAccessibility());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public ReactTextShadowNode createShadowNodeInstance() {
        return new ReactTextShadowNode(this.reactTextViewManagerCallback);
    }

    @NotNull
    public final ReactTextShadowNode createShadowNodeInstance(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        return new ReactTextShadowNode(reactTextViewManagerCallback);
    }

    @Override
    @NotNull
    public Class<ReactTextShadowNode> getShadowNodeClass() {
        return ReactTextShadowNode.class;
    }

    @Override
    protected void onAfterUpdateTransaction(@NotNull ReactTextView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onAfterUpdateTransaction((View)view);
        view.updateView();
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object updateState(@NotNull ReactTextView view, @NotNull ReactStylesDiffMap props, @NotNull StateWrapper stateWrapper) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)stateWrapper, (String)"stateWrapper");
        AutoCloseable autoCloseable = new SystraceSection("ReactTextViewManager.updateState");
        Throwable throwable = null;
        try {
            SystraceSection s = (SystraceSection)autoCloseable;
            boolean bl = false;
            ReadableMapBuffer stateMapBuffer = stateWrapper.getStateDataMapBuffer();
            Object object = stateMapBuffer != null ? this.getReactTextUpdate(view, props, stateMapBuffer) : null;
            return object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final Object getReactTextUpdate(ReactTextView view, ReactStylesDiffMap props, MapBuffer state) {
        MapBuffer attributedString = state.getMapBuffer(0);
        MapBuffer paragraphAttributes = state.getMapBuffer(1);
        Context context = view.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        Spannable spanned = TextLayoutManager.INSTANCE.getOrCreateSpannableForText(context, attributedString, this.reactTextViewManagerCallback);
        view.setSpanned(spanned);
        float minimumFontSize = (float)paragraphAttributes.getDouble(6);
        view.setMinimumFontSize(minimumFontSize);
        int textBreakStrategy = TextAttributeProps.getTextBreakStrategy(paragraphAttributes.getString(2));
        int currentJustificationMode = Build.VERSION.SDK_INT < 26 ? 0 : view.getJustificationMode();
        return new ReactTextUpdate(spanned, -1, false, TextLayoutManager.getTextGravity(attributedString, spanned), textBreakStrategy, TextAttributeProps.getJustificationMode(props, currentJustificationMode));
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        Map baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        Map map = baseEventTypeConstants;
        if (map == null) {
            map = new HashMap();
        }
        Map eventTypeConstants = map;
        eventTypeConstants.putAll(MapsKt.mapOf((Pair)TuplesKt.to((Object)"topTextLayout", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onTextLayout")))));
        return eventTypeConstants;
    }

    @Override
    public void onPostProcessSpannable(@NotNull Spannable text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            ReactTextViewManagerCallback reactTextViewManagerCallback = this.reactTextViewManagerCallback;
            if (reactTextViewManagerCallback == null) break block0;
            reactTextViewManagerCallback.onPostProcessSpannable(text);
        }
    }

    @Override
    public void setPadding(@NotNull ReactTextView view, int left, int top, int right, int bottom) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setPadding(left, top, right, bottom);
    }

    @ReactProp(name="overflow")
    public final void setOverflow(@NotNull ReactTextView view, @Nullable String overflow) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setOverflow(overflow);
    }

    @JvmOverloads
    public ReactTextViewManager() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/facebook/react/views/text/ReactTextViewManager$Companion;", "", "<init>", "()V", "TX_STATE_KEY_ATTRIBUTED_STRING", "", "TX_STATE_KEY_PARAGRAPH_ATTRIBUTES", "REACT_CLASS", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

