/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.debuggingoverlay;

import android.content.Context;
import android.graphics.RectF;
import com.facebook.react.bridge.NoSuchKeyException;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UnexpectedNativeTypeException;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.viewmanagers.DebuggingOverlayManagerDelegate;
import com.facebook.react.viewmanagers.DebuggingOverlayManagerInterface;
import com.facebook.react.views.debuggingoverlay.DebuggingOverlay;
import com.facebook.react.views.debuggingoverlay.TraceUpdate;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ReactModule(name="DebuggingOverlay")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/react/views/debuggingoverlay/DebuggingOverlayManager;", "Lcom/facebook/react/uimanager/SimpleViewManager;", "Lcom/facebook/react/views/debuggingoverlay/DebuggingOverlay;", "Lcom/facebook/react/viewmanagers/DebuggingOverlayManagerInterface;", "<init>", "()V", "delegate", "Lcom/facebook/react/uimanager/ViewManagerDelegate;", "getDelegate", "highlightTraceUpdates", "", "view", "providedTraceUpdates", "Lcom/facebook/react/bridge/ReadableArray;", "highlightElements", "providedElements", "clearElementsHighlights", "createViewInstance", "context", "Lcom/facebook/react/uimanager/ThemedReactContext;", "getName", "", "Companion", "ReactAndroid_release"})
public final class DebuggingOverlayManager
extends SimpleViewManager<DebuggingOverlay>
implements DebuggingOverlayManagerInterface<DebuggingOverlay> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewManagerDelegate<DebuggingOverlay> delegate = new DebuggingOverlayManagerDelegate(this);
    @NotNull
    public static final String REACT_CLASS = "DebuggingOverlay";

    @Override
    @NotNull
    protected ViewManagerDelegate<DebuggingOverlay> getDelegate() {
        return this.delegate;
    }

    @Override
    public void highlightTraceUpdates(@NotNull DebuggingOverlay view, @NotNull ReadableArray providedTraceUpdates) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)providedTraceUpdates, (String)"providedTraceUpdates");
        List formattedTraceUpdates = new ArrayList();
        boolean successfullyParsedPayload = true;
        int n = providedTraceUpdates.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            ReadableMap traceUpdate;
            if (providedTraceUpdates.getMap(i) == null) continue;
            ReadableMap serializedRectangle = traceUpdate.getMap("rectangle");
            if (serializedRectangle == null) {
                ReactSoftExceptionLogger.logSoftException(REACT_CLASS, new ReactNoCrashSoftException("Unexpected payload for highlighting trace updates: rectangle field is null"));
                successfullyParsedPayload = false;
                break;
            }
            int id2 = traceUpdate.getInt("id");
            int color = traceUpdate.getInt("color");
            try {
                float left = (float)serializedRectangle.getDouble("x");
                float top = (float)serializedRectangle.getDouble("y");
                float right = (float)((double)left + serializedRectangle.getDouble("width"));
                float bottom = (float)((double)top + serializedRectangle.getDouble("height"));
                RectF rectangle = new RectF(PixelUtil.INSTANCE.dpToPx(left), PixelUtil.INSTANCE.dpToPx(top), PixelUtil.INSTANCE.dpToPx(right), PixelUtil.INSTANCE.dpToPx(bottom));
                object = formattedTraceUpdates.add(new TraceUpdate(id2, rectangle, color));
                continue;
            }
            catch (Exception ex) {
                Exception exception = ex;
                if (!(exception instanceof NoSuchKeyException) && !(exception instanceof UnexpectedNativeTypeException)) {
                    throw ex;
                }
                ReactSoftExceptionLogger.logSoftException(REACT_CLASS, new ReactNoCrashSoftException("Unexpected payload for highlighting trace updates: rectangle field should have x, y, width, height fields"));
                successfullyParsedPayload = false;
                object = Unit.INSTANCE;
            }
        }
        if (successfullyParsedPayload) {
            view.setTraceUpdates(formattedTraceUpdates);
        }
    }

    @Override
    public void highlightElements(@NotNull DebuggingOverlay view, @NotNull ReadableArray providedElements) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        Intrinsics.checkNotNullParameter((Object)providedElements, (String)"providedElements");
        List elementsRectangles = new ArrayList();
        boolean successfullyParsedPayload = true;
        int n = providedElements.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (providedElements.getMap(i) == null) continue;
            try {
                ReadableMap element;
                float left = (float)element.getDouble("x");
                float top = (float)element.getDouble("y");
                float right = (float)((double)left + element.getDouble("width"));
                float bottom = (float)((double)top + element.getDouble("height"));
                RectF rect = new RectF(PixelUtil.INSTANCE.dpToPx(left), PixelUtil.INSTANCE.dpToPx(top), PixelUtil.INSTANCE.dpToPx(right), PixelUtil.INSTANCE.dpToPx(bottom));
                object = elementsRectangles.add(rect);
                continue;
            }
            catch (Exception ex) {
                Exception exception = ex;
                if (!(exception instanceof NoSuchKeyException) && !(exception instanceof UnexpectedNativeTypeException)) {
                    throw ex;
                }
                ReactSoftExceptionLogger.logSoftException(REACT_CLASS, new ReactNoCrashSoftException("Unexpected payload for highlighting elements: every element should have x, y, width, height fields"));
                successfullyParsedPayload = false;
                object = Unit.INSTANCE;
            }
        }
        if (successfullyParsedPayload) {
            view.setHighlightedElementsRectangles(elementsRectangles);
        }
    }

    @Override
    public void clearElementsHighlights(@NotNull DebuggingOverlay view) {
        Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
        view.clearElementsHighlights();
    }

    @Override
    @NotNull
    protected DebuggingOverlay createViewInstance(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new DebuggingOverlay((Context)context);
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/debuggingoverlay/DebuggingOverlayManager$Companion;", "", "<init>", "()V", "REACT_CLASS", "", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

