/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.MatrixMathHelper;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0007J:\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\bH\u0002J,\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J3\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u001dH\u0083 R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/uimanager/TransformHelper;", "", "<init>", "()V", "helperMatrix", "Ljava/lang/ThreadLocal;", "", "convertToRadians", "", "transformMap", "Lcom/facebook/react/bridge/ReadableMap;", "key", "", "processTransform", "", "transforms", "Lcom/facebook/react/bridge/ReadableArray;", "result", "viewWidth", "", "viewHeight", "transformOrigin", "allowPercentageResolution", "", "parseTranslateValue", "stringValue", "dimension", "getTranslateForTransformOrigin", "nativeProcessTransform", "Lcom/facebook/react/bridge/NativeArray;", "ReactAndroid_release"})
public final class TransformHelper {
    @NotNull
    public static final TransformHelper INSTANCE = new TransformHelper();
    @NotNull
    private static final ThreadLocal<double[]> helperMatrix = new ThreadLocal<double[]>(){

        protected double[] initialValue() {
            return new double[16];
        }
    };

    private TransformHelper() {
    }

    private final double convertToRadians(ReadableMap transformMap, String key) {
        double value = 0.0;
        boolean inRadians = true;
        if (transformMap.getType(key) == ReadableType.String) {
            String string2 = transformMap.getString(key);
            Intrinsics.checkNotNull((Object)string2);
            String stringValue = string2;
            if (StringsKt.endsWith$default((String)stringValue, (String)"rad", (boolean)false, (int)2, null)) {
                stringValue = StringsKt.dropLast((String)stringValue, (int)3);
            } else if (StringsKt.endsWith$default((String)stringValue, (String)"deg", (boolean)false, (int)2, null)) {
                inRadians = false;
                stringValue = StringsKt.dropLast((String)stringValue, (int)3);
            }
            value = Double.parseDouble(stringValue);
        } else {
            value = transformMap.getDouble(key);
        }
        return inRadians ? value : MatrixMathHelper.degreesToRadians(value);
    }

    @Deprecated(message="Use processTransform(ReadableArray, DoubleArray, Float, Float, ReadableArray, Boolean) instead", replaceWith=@ReplaceWith(expression="processTransform(...)", imports={}))
    @JvmStatic
    public static final void processTransform(@NotNull ReadableArray transforms, @NotNull double[] result) {
        Intrinsics.checkNotNullParameter((Object)transforms, (String)"transforms");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        TransformHelper.processTransform(transforms, result, 0.0f, 0.0f, null, false);
    }

    @Deprecated(message="Use processTransform(ReadableArray, DoubleArray, Float, Float, ReadableArray, Boolean) instead", replaceWith=@ReplaceWith(expression="processTransform(...)", imports={}))
    @JvmStatic
    public static final void processTransform(@NotNull ReadableArray transforms, @NotNull double[] result, float viewWidth, float viewHeight, @Nullable ReadableArray transformOrigin) {
        Intrinsics.checkNotNullParameter((Object)transforms, (String)"transforms");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        TransformHelper.processTransform(transforms, result, viewWidth, viewHeight, transformOrigin, false);
    }

    @JvmStatic
    public static final void processTransform(@NotNull ReadableArray transforms, @NotNull double[] result, float viewWidth, float viewHeight, @Nullable ReadableArray transformOrigin, boolean allowPercentageResolution) {
        double[] offsets;
        double[] helperMatrix2;
        block61: {
            block60: {
                Intrinsics.checkNotNullParameter((Object)transforms, (String)"transforms");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                if (allowPercentageResolution && ReactNativeFeatureFlags.useNativeTransformHelperAndroid() && transforms instanceof NativeArray) {
                    ReadableArray readableArray = transformOrigin;
                    if (readableArray == null ? true : readableArray instanceof NativeArray) {
                        TransformHelper.nativeProcessTransform((NativeArray)((Object)transforms), result, viewWidth, viewHeight, (NativeArray)((Object)transformOrigin));
                        return;
                    }
                }
                double[] dArray = helperMatrix.get();
                Intrinsics.checkNotNull((Object)dArray);
                helperMatrix2 = dArray;
                MatrixMathHelper.resetIdentityMatrix(result);
                offsets = INSTANCE.getTranslateForTransformOrigin(viewWidth, viewHeight, transformOrigin, allowPercentageResolution);
                if (offsets != null) {
                    MatrixMathHelper.resetIdentityMatrix(helperMatrix2);
                    MatrixMathHelper.applyTranslate3D(helperMatrix2, offsets[0], offsets[1], offsets[2]);
                    MatrixMathHelper.multiplyInto(result, result, helperMatrix2);
                }
                if (transforms.size() != 16 || transforms.getType(0) != ReadableType.Number) break block60;
                MatrixMathHelper.resetIdentityMatrix(helperMatrix2);
                int n = transforms.size();
                for (int i = 0; i < n; ++i) {
                    helperMatrix2[i] = transforms.getDouble(i);
                }
                MatrixMathHelper.multiplyInto(result, result, helperMatrix2);
                break block61;
            }
            int n = transforms.size();
            for (int transformIdx = 0; transformIdx < n; ++transformIdx) {
                ReadableMap transform;
                Intrinsics.checkNotNull((Object)transforms.getMap(transformIdx));
                String transformType = transform.keySetIterator().nextKey();
                MatrixMathHelper.resetIdentityMatrix(helperMatrix2);
                switch (transformType) {
                    case "matrix": {
                        Intrinsics.checkNotNull((Object)transform.getArray(transformType));
                        for (int i = 0; i < 16; ++i) {
                            ReadableArray matrix;
                            helperMatrix2[i] = matrix.getDouble(i);
                        }
                        break;
                    }
                    case "perspective": {
                        MatrixMathHelper.applyPerspective(helperMatrix2, transform.getDouble(transformType));
                        break;
                    }
                    case "rotateX": {
                        MatrixMathHelper.applyRotateX(helperMatrix2, INSTANCE.convertToRadians(transform, transformType));
                        break;
                    }
                    case "rotateY": {
                        MatrixMathHelper.applyRotateY(helperMatrix2, INSTANCE.convertToRadians(transform, transformType));
                        break;
                    }
                    case "rotate": 
                    case "rotateZ": {
                        MatrixMathHelper.applyRotateZ(helperMatrix2, INSTANCE.convertToRadians(transform, transformType));
                        break;
                    }
                    case "scale": {
                        double scale = transform.getDouble(transformType);
                        MatrixMathHelper.applyScaleX(helperMatrix2, scale);
                        MatrixMathHelper.applyScaleY(helperMatrix2, scale);
                        break;
                    }
                    case "scaleX": {
                        MatrixMathHelper.applyScaleX(helperMatrix2, transform.getDouble(transformType));
                        break;
                    }
                    case "scaleY": {
                        MatrixMathHelper.applyScaleY(helperMatrix2, transform.getDouble(transformType));
                        break;
                    }
                    case "translate": {
                        double d;
                        double x;
                        ReadableArray value;
                        Intrinsics.checkNotNull((Object)transform.getArray(transformType));
                        if (value.getType(0) == ReadableType.String && allowPercentageResolution) {
                            String string2 = value.getString(0);
                            Intrinsics.checkNotNull((Object)string2);
                            v3 = INSTANCE.parseTranslateValue(string2, viewWidth);
                        } else {
                            v3 = x = value.getDouble(0);
                        }
                        if (value.getType(1) == ReadableType.String && allowPercentageResolution) {
                            String string3 = value.getString(1);
                            Intrinsics.checkNotNull((Object)string3);
                            d = INSTANCE.parseTranslateValue(string3, viewHeight);
                        } else {
                            d = value.getDouble(1);
                        }
                        double y = d;
                        double z = value.size() > 2 ? value.getDouble(2) : 0.0;
                        MatrixMathHelper.applyTranslate3D(helperMatrix2, x, y, z);
                        break;
                    }
                    case "translateX": {
                        double d;
                        if (transform.getType(transformType) == ReadableType.String && allowPercentageResolution) {
                            String string4 = transform.getString(transformType);
                            Intrinsics.checkNotNull((Object)string4);
                            d = INSTANCE.parseTranslateValue(string4, viewWidth);
                        } else {
                            d = transform.getDouble(transformType);
                        }
                        double translateValue = d;
                        MatrixMathHelper.applyTranslate2D(helperMatrix2, translateValue, 0.0);
                        break;
                    }
                    case "translateY": {
                        double d;
                        if (transform.getType(transformType) == ReadableType.String && allowPercentageResolution) {
                            String string5 = transform.getString(transformType);
                            Intrinsics.checkNotNull((Object)string5);
                            d = INSTANCE.parseTranslateValue(string5, viewHeight);
                        } else {
                            d = transform.getDouble(transformType);
                        }
                        double translateValue = d;
                        MatrixMathHelper.applyTranslate2D(helperMatrix2, 0.0, translateValue);
                        break;
                    }
                    case "skewX": {
                        MatrixMathHelper.applySkewX(helperMatrix2, INSTANCE.convertToRadians(transform, transformType));
                        break;
                    }
                    case "skewY": {
                        MatrixMathHelper.applySkewY(helperMatrix2, INSTANCE.convertToRadians(transform, transformType));
                        break;
                    }
                    default: {
                        FLog.w((String)"ReactNative", (String)("Unsupported transform type: " + transformType));
                    }
                }
                MatrixMathHelper.multiplyInto(result, result, helperMatrix2);
            }
        }
        if (offsets != null) {
            MatrixMathHelper.resetIdentityMatrix(helperMatrix2);
            MatrixMathHelper.applyTranslate3D(helperMatrix2, -offsets[0], -offsets[1], -offsets[2]);
            MatrixMathHelper.multiplyInto(result, result, helperMatrix2);
        }
    }

    private final double parseTranslateValue(String stringValue, double dimension) {
        double d;
        try {
            double d2;
            if (StringsKt.endsWith$default((String)stringValue, (String)"%", (boolean)false, (int)2, null)) {
                double percentage = Double.parseDouble(StringsKt.dropLast((String)stringValue, (int)1));
                d2 = percentage * dimension / 100.0;
            } else {
                d2 = Double.parseDouble(stringValue);
            }
            d = d2;
        }
        catch (NumberFormatException e) {
            FLog.w((String)"ReactNative", (String)("Invalid translate value: " + stringValue));
            d = 0.0;
        }
        return d;
    }

    private final double[] getTranslateForTransformOrigin(float viewWidth, float viewHeight, ReadableArray transformOrigin, boolean allowPercentageResolution) {
        if (transformOrigin == null || viewHeight == 0.0f && viewWidth == 0.0f) {
            return null;
        }
        double viewCenterX = (double)viewWidth / 2.0;
        double viewCenterY = (double)viewHeight / 2.0;
        double[] dArray = new double[]{viewCenterX, viewCenterY, 0.0};
        double[] origin = dArray;
        int n = Math.min(transformOrigin.size(), 3);
        block4: for (int i = 0; i < n; ++i) {
            switch (WhenMappings.$EnumSwitchMapping$0[transformOrigin.getType(i).ordinal()]) {
                case 1: {
                    origin[i] = transformOrigin.getDouble(i);
                    continue block4;
                }
                case 2: {
                    String part;
                    if (!allowPercentageResolution) continue block4;
                    Intrinsics.checkNotNull((Object)transformOrigin.getString(i));
                    if (!StringsKt.endsWith$default((String)part, (String)"%", (boolean)false, (int)2, null)) continue block4;
                    double valPercent = Double.parseDouble(StringsKt.dropLast((String)part, (int)1));
                    origin[i] = (double)(i == 0 ? viewWidth : viewHeight) * valPercent / 100.0;
                }
            }
        }
        double newTranslateX = -viewCenterX + origin[0];
        double newTranslateY = -viewCenterY + origin[1];
        double newTranslateZ = origin[2];
        double[] dArray2 = new double[]{newTranslateX, newTranslateY, newTranslateZ};
        return dArray2;
    }

    @JvmStatic
    private static final native void nativeProcessTransform(NativeArray var0, double[] var1, float var2, float var3, NativeArray var4);

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReadableType.values().length];
            try {
                nArray[ReadableType.Number.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.String.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

