/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0007J\n\u0010\f\u001a\u00020\u0005*\u00020\rJ\n\u0010\f\u001a\u00020\u0005*\u00020\u000eJ\n\u0010\f\u001a\u00020\u0005*\u00020\u0005J\n\u0010\f\u001a\u00020\u0005*\u00020\u0007J\n\u0010\u000f\u001a\u00020\u0005*\u00020\rJ\n\u0010\u000f\u001a\u00020\u0005*\u00020\u000eJ\n\u0010\u000f\u001a\u00020\u0005*\u00020\u0005J\n\u0010\u000f\u001a\u00020\u0005*\u00020\u0007\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/uimanager/PixelUtil;", "", "<init>", "()V", "toPixelFromDIP", "", "value", "", "toPixelFromSP", "maxFontScale", "toDIPFromPixel", "getDisplayMetricDensity", "dpToPx", "", "", "pxToDp", "ReactAndroid_release"})
public final class PixelUtil {
    @NotNull
    public static final PixelUtil INSTANCE = new PixelUtil();

    private PixelUtil() {
    }

    @JvmStatic
    public static final float toPixelFromDIP(float value) {
        if (Float.isNaN(value)) {
            return Float.NaN;
        }
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)DisplayMetricsHolder.getWindowDisplayMetrics());
    }

    @JvmStatic
    public static final float toPixelFromDIP(double value) {
        return PixelUtil.toPixelFromDIP((float)value);
    }

    @JvmStatic
    @JvmOverloads
    public static final float toPixelFromSP(float value, float maxFontScale) {
        if (Float.isNaN(value)) {
            return Float.NaN;
        }
        DisplayMetrics displayMetrics = DisplayMetricsHolder.getWindowDisplayMetrics();
        float scaledValue = TypedValue.applyDimension((int)2, (float)value, (DisplayMetrics)displayMetrics);
        if (maxFontScale >= 1.0f) {
            return Math.min(scaledValue, value * displayMetrics.density * maxFontScale);
        }
        return scaledValue;
    }

    public static /* synthetic */ float toPixelFromSP$default(float f, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = Float.NaN;
        }
        return PixelUtil.toPixelFromSP(f, f2);
    }

    @JvmStatic
    public static final float toPixelFromSP(double value) {
        return PixelUtil.toPixelFromSP$default((float)value, 0.0f, 2, null);
    }

    @JvmStatic
    public static final float toDIPFromPixel(float value) {
        if (Float.isNaN(value)) {
            return Float.NaN;
        }
        return value / DisplayMetricsHolder.getWindowDisplayMetrics().density;
    }

    @JvmStatic
    public static final float getDisplayMetricDensity() {
        return DisplayMetricsHolder.getWindowDisplayMetrics().density;
    }

    public final float dpToPx(int $this$dpToPx) {
        return PixelUtil.toPixelFromDIP($this$dpToPx);
    }

    public final float dpToPx(long $this$dpToPx) {
        return PixelUtil.toPixelFromDIP($this$dpToPx);
    }

    public final float dpToPx(float $this$dpToPx) {
        return PixelUtil.toPixelFromDIP($this$dpToPx);
    }

    public final float dpToPx(double $this$dpToPx) {
        return PixelUtil.toPixelFromDIP((float)$this$dpToPx);
    }

    public final float pxToDp(int $this$pxToDp) {
        return PixelUtil.toDIPFromPixel($this$pxToDp);
    }

    public final float pxToDp(long $this$pxToDp) {
        return PixelUtil.toDIPFromPixel($this$pxToDp);
    }

    public final float pxToDp(float $this$pxToDp) {
        return PixelUtil.toDIPFromPixel($this$pxToDp);
    }

    public final float pxToDp(double $this$pxToDp) {
        return PixelUtil.toDIPFromPixel((float)$this$pxToDp);
    }

    @JvmStatic
    @JvmOverloads
    public static final float toPixelFromSP(float value) {
        return PixelUtil.toPixelFromSP$default(value, 0.0f, 2, null);
    }
}

