/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.content.Context;
import android.util.Log;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistry;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.interop.InteropModuleRegistry;
import com.facebook.react.common.annotations.FrameworkAPI;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.runtime.BridgelessCatalystInstance;
import com.facebook.react.runtime.ReactHostImpl;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001FB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0017J\b\u0010\u0019\u001a\u00020\u0018H\u0017J\b\u0010\u001a\u001a\u00020\u0018H\u0017J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J \u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0016J'\u0010(\u001a\u0004\u0018\u0001H)\"\b\b\u0000\u0010)*\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H)0,H\u0016\u00a2\u0006\u0002\u0010-J\u001a\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u000101H\u0016J \u00102\u001a\u00020\u0018\"\b\b\u0000\u0010)*\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H)0,H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020306H\u0016J'\u00107\u001a\u0004\u0018\u0001H)\"\b\b\u0000\u0010)*\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H)0,H\u0016\u00a2\u0006\u0002\u00108J\u0012\u00107\u001a\u0004\u0018\u0001032\u0006\u00109\u001a\u00020\u000bH\u0016J\n\u0010:\u001a\u0004\u0018\u00010;H\u0017J\u0014\u0010<\u001a\u00020\u00112\n\u0010=\u001a\u00060>j\u0002`?H\u0016J\n\u0010@\u001a\u0004\u0018\u00010AH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010B\u001a\u00020C8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\u00a8\u0006G"}, d2={"Lcom/facebook/react/runtime/BridgelessReactContext;", "Lcom/facebook/react/bridge/ReactApplicationContext;", "Lcom/facebook/react/uimanager/events/EventDispatcherProvider;", "context", "Landroid/content/Context;", "reactHost", "Lcom/facebook/react/runtime/ReactHostImpl;", "<init>", "(Landroid/content/Context;Lcom/facebook/react/runtime/ReactHostImpl;)V", "sourceURLRef", "Ljava/util/concurrent/atomic/AtomicReference;", "", "TAG", "getEventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "getSourceURL", "setSourceURL", "", "sourceURL", "getFabricUIManager", "Lcom/facebook/react/bridge/UIManager;", "getCatalystInstance", "Lcom/facebook/react/bridge/CatalystInstance;", "hasActiveCatalystInstance", "", "isBridgeless", "hasCatalystInstance", "hasActiveReactInstance", "hasReactInstance", "destroy", "devSupportManager", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "getDevSupportManager", "()Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "registerSegment", "segmentId", "", "path", "callback", "Lcom/facebook/react/bridge/Callback;", "getJSModule", "T", "Lcom/facebook/react/bridge/JavaScriptModule;", "jsInterface", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lcom/facebook/react/bridge/JavaScriptModule;", "emitDeviceEvent", "eventName", "args", "", "hasNativeModule", "Lcom/facebook/react/bridge/NativeModule;", "nativeModuleInterface", "getNativeModules", "", "getNativeModule", "(Ljava/lang/Class;)Lcom/facebook/react/bridge/NativeModule;", "name", "getJavaScriptContextHolder", "Lcom/facebook/react/bridge/JavaScriptContextHolder;", "handleException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getJSCallInvokerHolder", "Lcom/facebook/react/turbomodule/core/interfaces/CallInvokerHolder;", "defaultHardwareBackBtnHandler", "Lcom/facebook/react/modules/core/DefaultHardwareBackBtnHandler;", "getDefaultHardwareBackBtnHandler", "()Lcom/facebook/react/modules/core/DefaultHardwareBackBtnHandler;", "BridgelessJSModuleInvocationHandler", "ReactAndroid_release"})
public final class BridgelessReactContext
extends ReactApplicationContext
implements EventDispatcherProvider {
    @NotNull
    private final ReactHostImpl reactHost;
    @NotNull
    private final AtomicReference<String> sourceURLRef;
    @NotNull
    private final String TAG;

    public BridgelessReactContext(@NotNull Context context, @NotNull ReactHostImpl reactHost) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reactHost, (String)"reactHost");
        super(context);
        this.reactHost = reactHost;
        this.sourceURLRef = new AtomicReference();
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        this.TAG = string2;
        if (ReactNativeNewArchitectureFeatureFlags.useFabricInterop()) {
            this.initializeInteropModules();
        }
    }

    @Override
    @NotNull
    public EventDispatcher getEventDispatcher() {
        return this.reactHost.getEventDispatcher$ReactAndroid_release();
    }

    @Override
    @Nullable
    public String getSourceURL() {
        return this.sourceURLRef.get();
    }

    public final void setSourceURL(@Nullable String sourceURL) {
        this.sourceURLRef.set(sourceURL);
    }

    @Override
    @Deprecated(message="This method is deprecated, please use UIManagerHelper.getUIManager() instead.")
    @Nullable
    public UIManager getFabricUIManager() {
        return this.reactHost.getUiManager$ReactAndroid_release();
    }

    @Override
    @NotNull
    public CatalystInstance getCatalystInstance() {
        if (ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            throw new UnsupportedOperationException("CatalystInstance is not supported when Bridgeless mode is enabled.");
        }
        Log.w((String)this.TAG, (String)"[WARNING] Bridgeless doesn't support CatalystInstance. Accessing an API that's not part of the new architecture is not encouraged usage.");
        return new BridgelessCatalystInstance(this.reactHost);
    }

    @Override
    @Deprecated(message="This API has been deprecated due to naming consideration, please use hasActiveReactInstance() instead")
    public boolean hasActiveCatalystInstance() {
        return this.hasActiveReactInstance();
    }

    @Override
    @Deprecated(message="DO NOT USE, this method will be removed in the near future.")
    public boolean isBridgeless() {
        return true;
    }

    @Override
    @Deprecated(message="This API has been deprecated due to naming consideration, please use hasReactInstance() instead")
    public boolean hasCatalystInstance() {
        return false;
    }

    @Override
    public boolean hasActiveReactInstance() {
        return this.reactHost.isInstanceInitialized$ReactAndroid_release();
    }

    @Override
    public boolean hasReactInstance() {
        return this.reactHost.isInstanceInitialized$ReactAndroid_release();
    }

    @Override
    public void destroy() {
    }

    @NotNull
    public final DevSupportManager getDevSupportManager() {
        return this.reactHost.getDevSupportManager();
    }

    @Override
    public void registerSegment(int segmentId, @NotNull String path, @NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.reactHost.registerSegment$ReactAndroid_release(segmentId, path, callback);
    }

    @Override
    @Nullable
    public <T extends JavaScriptModule> T getJSModule(@NotNull Class<T> jsInterface) {
        T t;
        Intrinsics.checkNotNullParameter(jsInterface, (String)"jsInterface");
        InteropModuleRegistry interopModuleRegistry = this.mInteropModuleRegistry;
        if (interopModuleRegistry != null && (t = interopModuleRegistry.getInteropModule(jsInterface)) != null) {
            T it = t;
            boolean bl = false;
            return it;
        }
        Class[] classArray = new Class[]{jsInterface};
        Object object = Proxy.newProxyInstance(jsInterface.getClassLoader(), classArray, (InvocationHandler)new BridgelessJSModuleInvocationHandler(this.reactHost, jsInterface));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.facebook.react.bridge.JavaScriptModule");
        JavaScriptModule interfaceProxy = (JavaScriptModule)object;
        return (T)(interfaceProxy instanceof JavaScriptModule ? interfaceProxy : null);
    }

    @Override
    public void emitDeviceEvent(@NotNull String eventName, @Nullable Object args) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Object[] objectArray = new Object[]{eventName, args};
        WritableNativeArray writableNativeArray = Arguments.fromJavaArgs(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)writableNativeArray, (String)"fromJavaArgs(...)");
        this.reactHost.callFunctionOnModule$ReactAndroid_release("RCTDeviceEventEmitter", "emit", writableNativeArray);
    }

    @Override
    public <T extends NativeModule> boolean hasNativeModule(@NotNull Class<T> nativeModuleInterface) {
        Intrinsics.checkNotNullParameter(nativeModuleInterface, (String)"nativeModuleInterface");
        return this.reactHost.hasNativeModule$ReactAndroid_release(nativeModuleInterface);
    }

    @Override
    @NotNull
    public Collection<NativeModule> getNativeModules() {
        return this.reactHost.getNativeModules$ReactAndroid_release();
    }

    @Override
    @Nullable
    public <T extends NativeModule> T getNativeModule(@NotNull Class<T> nativeModuleInterface) {
        Intrinsics.checkNotNullParameter(nativeModuleInterface, (String)"nativeModuleInterface");
        return this.reactHost.getNativeModule$ReactAndroid_release(nativeModuleInterface);
    }

    @Override
    @Nullable
    public NativeModule getNativeModule(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.reactHost.getNativeModule$ReactAndroid_release(name);
    }

    @Override
    @UnstableReactNativeAPI
    @FrameworkAPI
    @Nullable
    public JavaScriptContextHolder getJavaScriptContextHolder() {
        return this.reactHost.getJavaScriptContextHolder$ReactAndroid_release();
    }

    @Override
    public void handleException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.reactHost.handleHostException$ReactAndroid_release(e);
    }

    @Override
    @Nullable
    public CallInvokerHolder getJSCallInvokerHolder() {
        return this.reactHost.getJsCallInvokerHolder$ReactAndroid_release();
    }

    @NotNull
    public final DefaultHardwareBackBtnHandler getDefaultHardwareBackBtnHandler() {
        return this.reactHost.getDefaultBackButtonHandler$ReactAndroid_release();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ0\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/runtime/BridgelessReactContext$BridgelessJSModuleInvocationHandler;", "Ljava/lang/reflect/InvocationHandler;", "reactHost", "Lcom/facebook/react/runtime/ReactHostImpl;", "jsModuleInterface", "Ljava/lang/Class;", "Lcom/facebook/react/bridge/JavaScriptModule;", "<init>", "(Lcom/facebook/react/runtime/ReactHostImpl;Ljava/lang/Class;)V", "invoke", "", "proxy", "method", "Ljava/lang/reflect/Method;", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "ReactAndroid_release"})
    private static final class BridgelessJSModuleInvocationHandler
    implements InvocationHandler {
        @NotNull
        private final ReactHostImpl reactHost;
        @NotNull
        private final Class<? extends JavaScriptModule> jsModuleInterface;

        public BridgelessJSModuleInvocationHandler(@NotNull ReactHostImpl reactHost, @NotNull Class<? extends JavaScriptModule> jsModuleInterface) {
            Intrinsics.checkNotNullParameter((Object)reactHost, (String)"reactHost");
            Intrinsics.checkNotNullParameter(jsModuleInterface, (String)"jsModuleInterface");
            this.reactHost = reactHost;
            this.jsModuleInterface = jsModuleInterface;
        }

        @Override
        @Nullable
        public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) {
            NativeArray nativeArray;
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            if (args != null) {
                WritableNativeArray writableNativeArray = Arguments.fromJavaArgs(args);
                Intrinsics.checkNotNullExpressionValue((Object)writableNativeArray, (String)"fromJavaArgs(...)");
                nativeArray = writableNativeArray;
            } else {
                nativeArray = new WritableNativeArray();
            }
            NativeArray jsArgs = nativeArray;
            String string2 = JavaScriptModuleRegistry.Companion.getJSModuleName(this.jsModuleInterface);
            String string3 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            this.reactHost.callFunctionOnModule$ReactAndroid_release(string2, string3, jsArgs);
            return null;
        }
    }
}

