/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.accessibilityinfo;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.provider.Settings;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.facebook.fbreact.specs.NativeAccessibilityInfoSpec;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.module.annotations.ReactModule;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="AccessibilityInfo")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0001\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0003=>?B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010)\u001a\u00020!H\u0002J\b\u0010*\u001a\u00020!H\u0002J\b\u0010+\u001a\u00020!H\u0002J\u0010\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u0013H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010-\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u00020!H\u0002J\b\u00100\u001a\u00020!H\u0016J\b\u00101\u001a\u00020!H\u0016J\b\u00102\u001a\u00020!H\u0016J\b\u00103\u001a\u00020!H\u0016J\b\u00104\u001a\u00020!H\u0016J\u0012\u00105\u001a\u00020!2\b\u00106\u001a\u0004\u0018\u000107H\u0016J\u0010\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020:H\u0016J\u0018\u0010;\u001a\u00020!2\u0006\u0010<\u001a\u00020:2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001c\u00a8\u0006@"}, d2={"Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule;", "Lcom/facebook/fbreact/specs/NativeAccessibilityInfoSpec;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "context", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "animationScaleObserver", "Landroid/database/ContentObserver;", "highTextContrastObserver", "accessibilityManager", "Landroid/view/accessibility/AccessibilityManager;", "touchExplorationStateChangeListener", "Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule$ReactTouchExplorationStateChangeListener;", "accessibilityServiceChangeListener", "Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule$ReactAccessibilityServiceChangeListener;", "contentResolver", "Landroid/content/ContentResolver;", "reduceMotionEnabled", "", "highTextContrastEnabled", "touchExplorationEnabled", "accessibilityServiceEnabled", "recommendedTimeout", "", "invertColorsEnabled", "grayscaleModeEnabled", "isReduceMotionEnabledValue", "()Z", "isInvertColorsEnabledValue", "isGrayscaleEnabledValue", "isHighTextContrastEnabledValue", "isReduceMotionEnabled", "", "successCallback", "Lcom/facebook/react/bridge/Callback;", "isInvertColorsEnabled", "isGrayscaleEnabled", "isHighTextContrastEnabled", "isTouchExplorationEnabled", "isAccessibilityServiceEnabled", "updateAndSendReduceMotionChangeEvent", "updateAndSendInvertColorsChangeEvent", "updateAndSendHighTextContrastChangeEvent", "updateAndSendTouchExplorationChangeEvent", "enabled", "updateAndSendAccessibilityServiceChangeEvent", "updateAndSendGrayscaleModeChangeEvent", "onHostResume", "onHostPause", "initialize", "invalidate", "onHostDestroy", "announceForAccessibility", "message", "", "setAccessibilityFocus", "reactTag", "", "getRecommendedTimeoutMillis", "originalTimeout", "ReactTouchExplorationStateChangeListener", "ReactAccessibilityServiceChangeListener", "Companion", "ReactAndroid_release"})
public final class AccessibilityInfoModule
extends NativeAccessibilityInfoSpec
implements LifecycleEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContentObserver animationScaleObserver;
    @NotNull
    private final ContentObserver highTextContrastObserver;
    @Nullable
    private final AccessibilityManager accessibilityManager;
    @NotNull
    private final ReactTouchExplorationStateChangeListener touchExplorationStateChangeListener;
    @NotNull
    private final ReactAccessibilityServiceChangeListener accessibilityServiceChangeListener;
    @NotNull
    private final ContentResolver contentResolver;
    private boolean reduceMotionEnabled;
    private boolean highTextContrastEnabled;
    private boolean touchExplorationEnabled;
    private boolean accessibilityServiceEnabled;
    private int recommendedTimeout;
    private boolean invertColorsEnabled;
    private boolean grayscaleModeEnabled;
    @NotNull
    public static final String NAME = "AccessibilityInfo";
    @NotNull
    private static final String REDUCE_MOTION_EVENT_NAME = "reduceMotionDidChange";
    @NotNull
    private static final String HIGH_TEXT_CONTRAST_EVENT_NAME = "highTextContrastDidChange";
    @NotNull
    private static final String TOUCH_EXPLORATION_EVENT_NAME = "touchExplorationDidChange";
    @NotNull
    private static final String ACCESSIBILITY_SERVICE_EVENT_NAME = "accessibilityServiceDidChange";
    @NotNull
    private static final String ACCESSIBILITY_HIGH_TEXT_CONTRAST_ENABLED_CONSTANT = "high_text_contrast_enabled";
    @NotNull
    private static final String INVERT_COLOR_EVENT_NAME = "invertColorDidChange";
    @NotNull
    private static final String GRAYSCALE_MODE_EVENT_NAME = "grayscaleModeDidChange";

    public AccessibilityInfoModule(@NotNull ReactApplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        super(context);
        Handler handler = UiThreadUtil.getUiThreadHandler();
        this.animationScaleObserver = new ContentObserver(this, handler){
            final /* synthetic */ AccessibilityInfoModule this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onChange(boolean selfChange) {
                this.onChange(selfChange, null);
            }

            public void onChange(boolean selfChange, Uri uri) {
                if (AccessibilityInfoModule.access$getReactApplicationContext(this.this$0).hasActiveReactInstance()) {
                    AccessibilityInfoModule.access$updateAndSendReduceMotionChangeEvent(this.this$0);
                }
            }
        };
        handler = UiThreadUtil.getUiThreadHandler();
        this.highTextContrastObserver = new ContentObserver(this, handler){
            final /* synthetic */ AccessibilityInfoModule this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void onChange(boolean selfChange) {
                this.onChange(selfChange, null);
            }

            public void onChange(boolean selfChange, Uri uri) {
                if (AccessibilityInfoModule.access$getReactApplicationContext(this.this$0).hasActiveReactInstance()) {
                    AccessibilityInfoModule.access$updateAndSendHighTextContrastChangeEvent(this.this$0);
                }
            }
        };
        this.touchExplorationStateChangeListener = new ReactTouchExplorationStateChangeListener();
        this.accessibilityServiceChangeListener = new ReactAccessibilityServiceChangeListener();
        Context appContext = context.getApplicationContext();
        Object object = appContext.getSystemService("accessibility");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.accessibility.AccessibilityManager");
        this.accessibilityManager = (AccessibilityManager)object;
        ContentResolver contentResolver = this.getReactApplicationContext().getContentResolver();
        Intrinsics.checkNotNullExpressionValue((Object)contentResolver, (String)"getContentResolver(...)");
        this.contentResolver = contentResolver;
        this.touchExplorationEnabled = this.accessibilityManager.isTouchExplorationEnabled();
        this.accessibilityServiceEnabled = this.accessibilityManager.isEnabled();
        this.reduceMotionEnabled = this.isReduceMotionEnabledValue();
        this.highTextContrastEnabled = this.isHighTextContrastEnabledValue();
        this.grayscaleModeEnabled = this.isGrayscaleEnabledValue();
    }

    private final boolean isReduceMotionEnabledValue() {
        String rawValue = Settings.Global.getString((ContentResolver)this.contentResolver, (String)"transition_animation_scale");
        if (rawValue == null) {
            return false;
        }
        try {
            float parsedValue = Float.parseFloat(StringsKt.replace$default((String)rawValue, (char)',', (char)'.', (boolean)false, (int)4, null));
            return parsedValue == 0.0f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private final boolean isInvertColorsEnabledValue() {
        boolean bl;
        try {
            bl = Settings.Secure.getInt((ContentResolver)this.contentResolver, (String)"accessibility_display_inversion_enabled") == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    private final boolean isGrayscaleEnabledValue() {
        try {
            String colorCorrectionSettingKey = "accessibility_display_daltonizer_enabled";
            String colorModeSettingKey = "accessibility_display_daltonizer";
            return Settings.Secure.getInt((ContentResolver)this.contentResolver, (String)colorCorrectionSettingKey) == 1 && Settings.Secure.getInt((ContentResolver)this.contentResolver, (String)colorModeSettingKey) == 0;
        }
        catch (Settings.SettingNotFoundException e) {
            return false;
        }
    }

    private final boolean isHighTextContrastEnabledValue() {
        return Settings.Secure.getInt((ContentResolver)this.contentResolver, (String)ACCESSIBILITY_HIGH_TEXT_CONTRAST_ENABLED_CONSTANT, (int)0) != 0;
    }

    @Override
    public void isReduceMotionEnabled(@NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        Object[] objectArray = new Object[]{this.reduceMotionEnabled};
        successCallback.invoke(objectArray);
    }

    @Override
    public void isInvertColorsEnabled(@NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        Object[] objectArray = new Object[]{this.invertColorsEnabled};
        successCallback.invoke(objectArray);
    }

    @Override
    public void isGrayscaleEnabled(@NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        Object[] objectArray = new Object[]{this.grayscaleModeEnabled};
        successCallback.invoke(objectArray);
    }

    @Override
    public void isHighTextContrastEnabled(@NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        Object[] objectArray = new Object[]{this.highTextContrastEnabled};
        successCallback.invoke(objectArray);
    }

    @Override
    public void isTouchExplorationEnabled(@NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        Object[] objectArray = new Object[]{this.touchExplorationEnabled};
        successCallback.invoke(objectArray);
    }

    @Override
    public void isAccessibilityServiceEnabled(@NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        Object[] objectArray = new Object[]{this.accessibilityServiceEnabled};
        successCallback.invoke(objectArray);
    }

    private final void updateAndSendReduceMotionChangeEvent() {
        boolean isReduceMotionEnabled = this.isReduceMotionEnabledValue();
        if (this.reduceMotionEnabled != isReduceMotionEnabled) {
            this.reduceMotionEnabled = isReduceMotionEnabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                reactApplicationContext.emitDeviceEvent(REDUCE_MOTION_EVENT_NAME, this.reduceMotionEnabled);
            }
        }
    }

    private final void updateAndSendInvertColorsChangeEvent() {
        boolean isInvertColorsEnabled = this.isInvertColorsEnabledValue();
        if (this.invertColorsEnabled != isInvertColorsEnabled) {
            this.invertColorsEnabled = isInvertColorsEnabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                reactApplicationContext.emitDeviceEvent(INVERT_COLOR_EVENT_NAME, this.invertColorsEnabled);
            }
        }
    }

    private final void updateAndSendHighTextContrastChangeEvent() {
        boolean isHighTextContrastEnabled = this.isHighTextContrastEnabledValue();
        if (this.highTextContrastEnabled != isHighTextContrastEnabled) {
            this.highTextContrastEnabled = isHighTextContrastEnabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                reactApplicationContext.emitDeviceEvent(HIGH_TEXT_CONTRAST_EVENT_NAME, this.highTextContrastEnabled);
            }
        }
    }

    private final void updateAndSendTouchExplorationChangeEvent(boolean enabled) {
        if (this.touchExplorationEnabled != enabled) {
            this.touchExplorationEnabled = enabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                this.getReactApplicationContext().emitDeviceEvent(TOUCH_EXPLORATION_EVENT_NAME, this.touchExplorationEnabled);
            }
        }
    }

    private final void updateAndSendAccessibilityServiceChangeEvent(boolean enabled) {
        if (this.accessibilityServiceEnabled != enabled) {
            this.accessibilityServiceEnabled = enabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                this.getReactApplicationContext().emitDeviceEvent(ACCESSIBILITY_SERVICE_EVENT_NAME, this.accessibilityServiceEnabled);
            }
        }
    }

    private final void updateAndSendGrayscaleModeChangeEvent() {
        boolean isGrayscaleModeEnabled = this.isGrayscaleEnabledValue();
        if (this.grayscaleModeEnabled != isGrayscaleModeEnabled) {
            this.grayscaleModeEnabled = isGrayscaleModeEnabled;
            ReactApplicationContext reactApplicationContext = this.getReactApplicationContextIfActiveOrWarn();
            if (reactApplicationContext != null) {
                reactApplicationContext.emitDeviceEvent(GRAYSCALE_MODE_EVENT_NAME, this.grayscaleModeEnabled);
            }
        }
    }

    @Override
    public void onHostResume() {
        AccessibilityManager accessibilityManager = this.accessibilityManager;
        if (accessibilityManager != null) {
            accessibilityManager.addTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.touchExplorationStateChangeListener);
        }
        AccessibilityManager accessibilityManager2 = this.accessibilityManager;
        if (accessibilityManager2 != null) {
            accessibilityManager2.addAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this.accessibilityServiceChangeListener);
        }
        Uri transitionUri = Settings.Global.getUriFor((String)"transition_animation_scale");
        this.contentResolver.registerContentObserver(transitionUri, false, this.animationScaleObserver);
        Uri highTextContrastUri = Settings.Global.getUriFor((String)ACCESSIBILITY_HIGH_TEXT_CONTRAST_ENABLED_CONSTANT);
        this.contentResolver.registerContentObserver(highTextContrastUri, false, this.highTextContrastObserver);
        AccessibilityManager accessibilityManager3 = this.accessibilityManager;
        this.updateAndSendTouchExplorationChangeEvent(accessibilityManager3 != null ? accessibilityManager3.isTouchExplorationEnabled() : false);
        AccessibilityManager accessibilityManager4 = this.accessibilityManager;
        this.updateAndSendAccessibilityServiceChangeEvent(accessibilityManager4 != null ? accessibilityManager4.isEnabled() : false);
        this.updateAndSendReduceMotionChangeEvent();
        this.updateAndSendHighTextContrastChangeEvent();
        this.updateAndSendInvertColorsChangeEvent();
        this.updateAndSendGrayscaleModeChangeEvent();
    }

    @Override
    public void onHostPause() {
        AccessibilityManager accessibilityManager = this.accessibilityManager;
        if (accessibilityManager != null) {
            accessibilityManager.removeTouchExplorationStateChangeListener((AccessibilityManager.TouchExplorationStateChangeListener)this.touchExplorationStateChangeListener);
        }
        AccessibilityManager accessibilityManager2 = this.accessibilityManager;
        if (accessibilityManager2 != null) {
            accessibilityManager2.removeAccessibilityStateChangeListener((AccessibilityManager.AccessibilityStateChangeListener)this.accessibilityServiceChangeListener);
        }
        this.contentResolver.unregisterContentObserver(this.animationScaleObserver);
        this.contentResolver.unregisterContentObserver(this.highTextContrastObserver);
    }

    @Override
    public void initialize() {
        this.getReactApplicationContext().addLifecycleEventListener(this);
        AccessibilityManager accessibilityManager = this.accessibilityManager;
        this.updateAndSendTouchExplorationChangeEvent(accessibilityManager != null ? accessibilityManager.isTouchExplorationEnabled() : false);
        AccessibilityManager accessibilityManager2 = this.accessibilityManager;
        this.updateAndSendAccessibilityServiceChangeEvent(accessibilityManager2 != null ? accessibilityManager2.isEnabled() : false);
        this.updateAndSendReduceMotionChangeEvent();
        this.updateAndSendHighTextContrastChangeEvent();
    }

    @Override
    public void invalidate() {
        this.getReactApplicationContext().removeLifecycleEventListener(this);
        super.invalidate();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public void announceForAccessibility(@Nullable String message) {
        if (this.accessibilityManager == null || !this.accessibilityManager.isEnabled()) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain((int)16384);
        event.getText().add(message);
        event.setClassName((CharSequence)AccessibilityInfoModule.class.getName());
        event.setPackageName((CharSequence)this.getReactApplicationContext().getPackageName());
        this.accessibilityManager.sendAccessibilityEvent(event);
    }

    @Override
    public void setAccessibilityFocus(double reactTag) {
    }

    @Override
    public void getRecommendedTimeoutMillis(double originalTimeout, @NotNull Callback successCallback) {
        Intrinsics.checkNotNullParameter((Object)successCallback, (String)"successCallback");
        if (Build.VERSION.SDK_INT < 29) {
            Object[] objectArray = new Object[]{(int)originalTimeout};
            successCallback.invoke(objectArray);
            return;
        }
        AccessibilityManager accessibilityManager = this.accessibilityManager;
        this.recommendedTimeout = accessibilityManager != null ? accessibilityManager.getRecommendedTimeoutMillis((int)originalTimeout, 4) : 0;
        Object[] objectArray = new Object[]{this.recommendedTimeout};
        successCallback.invoke(objectArray);
    }

    public static final /* synthetic */ ReactApplicationContext access$getReactApplicationContext(AccessibilityInfoModule $this) {
        return $this.getReactApplicationContext();
    }

    public static final /* synthetic */ void access$updateAndSendReduceMotionChangeEvent(AccessibilityInfoModule $this) {
        $this.updateAndSendReduceMotionChangeEvent();
    }

    public static final /* synthetic */ void access$updateAndSendHighTextContrastChangeEvent(AccessibilityInfoModule $this) {
        $this.updateAndSendHighTextContrastChangeEvent();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule$Companion;", "", "<init>", "()V", "NAME", "", "REDUCE_MOTION_EVENT_NAME", "HIGH_TEXT_CONTRAST_EVENT_NAME", "TOUCH_EXPLORATION_EVENT_NAME", "ACCESSIBILITY_SERVICE_EVENT_NAME", "ACCESSIBILITY_HIGH_TEXT_CONTRAST_ENABLED_CONSTANT", "INVERT_COLOR_EVENT_NAME", "GRAYSCALE_MODE_EVENT_NAME", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule$ReactAccessibilityServiceChangeListener;", "Landroid/view/accessibility/AccessibilityManager$AccessibilityStateChangeListener;", "<init>", "(Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule;)V", "onAccessibilityStateChanged", "", "enabled", "", "ReactAndroid_release"})
    private final class ReactAccessibilityServiceChangeListener
    implements AccessibilityManager.AccessibilityStateChangeListener {
        public void onAccessibilityStateChanged(boolean enabled) {
            AccessibilityInfoModule.this.updateAndSendAccessibilityServiceChangeEvent(enabled);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule$ReactTouchExplorationStateChangeListener;", "Landroid/view/accessibility/AccessibilityManager$TouchExplorationStateChangeListener;", "<init>", "(Lcom/facebook/react/modules/accessibilityinfo/AccessibilityInfoModule;)V", "onTouchExplorationStateChanged", "", "enabled", "", "ReactAndroid_release"})
    private final class ReactTouchExplorationStateChangeListener
    implements AccessibilityManager.TouchExplorationStateChangeListener {
        public void onTouchExplorationStateChanged(boolean enabled) {
            AccessibilityInfoModule.this.updateAndSendTouchExplorationChangeEvent(enabled);
        }
    }
}

