/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.util.JsonWriter;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\rH\u0007J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J\u001a\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/bridge/JsonWriterHelper;", "", "<init>", "()V", "value", "", "writer", "Landroid/util/JsonWriter;", "dynamicValue", "Lcom/facebook/react/bridge/Dynamic;", "readableMapValue", "Lcom/facebook/react/bridge/ReadableMap;", "readableArrayValue", "Lcom/facebook/react/bridge/ReadableArray;", "mapValue", "map", "", "listValue", "list", "", "objectValue", "ReactAndroid_release"})
public final class JsonWriterHelper {
    @NotNull
    public static final JsonWriterHelper INSTANCE = new JsonWriterHelper();

    private JsonWriterHelper() {
    }

    @JvmStatic
    public static final void value(@NotNull JsonWriter writer, @Nullable Object value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Object object = value;
        if (object instanceof Map) {
            INSTANCE.mapValue(writer, (Map)value);
        } else if (object instanceof List) {
            INSTANCE.listValue(writer, (List)value);
        } else if (object instanceof ReadableMap) {
            INSTANCE.readableMapValue(writer, (ReadableMap)value);
        } else if (object instanceof ReadableArray) {
            JsonWriterHelper.readableArrayValue(writer, (ReadableArray)value);
        } else if (object instanceof Dynamic) {
            INSTANCE.dynamicValue(writer, (Dynamic)value);
        } else {
            INSTANCE.objectValue(writer, value);
        }
    }

    private final void dynamicValue(JsonWriter writer, Dynamic value) throws IOException {
        switch (WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
            case 1: {
                JsonWriter jsonWriter = writer.nullValue();
                break;
            }
            case 2: {
                JsonWriter jsonWriter = writer.value(value.asBoolean());
                break;
            }
            case 3: {
                JsonWriter jsonWriter = writer.value(value.asDouble());
                break;
            }
            case 4: {
                JsonWriter jsonWriter = writer.value(value.asString());
                break;
            }
            case 5: {
                ReadableMap map;
                ReadableMap readableMap = map = value.asMap();
                if (readableMap == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                this.readableMapValue(writer, readableMap);
                JsonWriter jsonWriter = Unit.INSTANCE;
                break;
            }
            case 6: {
                ReadableArray array;
                ReadableArray readableArray = array = value.asArray();
                if (readableArray == null) {
                    String string3 = "Required value was null.";
                    throw new IllegalStateException(string3.toString());
                }
                JsonWriterHelper.readableArrayValue(writer, readableArray);
                JsonWriter jsonWriter = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readableMapValue(JsonWriter writer, ReadableMap value) throws IOException {
        writer.beginObject();
        try {
            ReadableMapKeySetIterator iterator2 = value.keySetIterator();
            while (iterator2.hasNextKey()) {
                String key = iterator2.nextKey();
                writer.name(key);
                switch (WhenMappings.$EnumSwitchMapping$0[value.getType(key).ordinal()]) {
                    case 1: {
                        JsonWriter jsonWriter = writer.nullValue();
                        break;
                    }
                    case 2: {
                        JsonWriter jsonWriter = writer.value(value.getBoolean(key));
                        break;
                    }
                    case 3: {
                        JsonWriter jsonWriter = writer.value(value.getDouble(key));
                        break;
                    }
                    case 4: {
                        JsonWriter jsonWriter = writer.value(value.getString(key));
                        break;
                    }
                    case 5: {
                        ReadableMap map;
                        ReadableMap readableMap = map = value.getMap(key);
                        if (readableMap == null) {
                            String string2 = "Required value was null.";
                            throw new IllegalStateException(string2.toString());
                        }
                        this.readableMapValue(writer, readableMap);
                        JsonWriter jsonWriter = Unit.INSTANCE;
                        break;
                    }
                    case 6: {
                        ReadableArray array;
                        ReadableArray readableArray = array = value.getArray(key);
                        if (readableArray == null) {
                            String string3 = "Required value was null.";
                            throw new IllegalStateException(string3.toString());
                        }
                        JsonWriterHelper.readableArrayValue(writer, readableArray);
                        JsonWriter jsonWriter = Unit.INSTANCE;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
        finally {
            writer.endObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void readableArrayValue(@NotNull JsonWriter writer, @NotNull ReadableArray value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        writer.beginArray();
        try {
            int n = value.size();
            block11: for (int i = 0; i < n; ++i) {
                switch (WhenMappings.$EnumSwitchMapping$0[value.getType(i).ordinal()]) {
                    case 1: {
                        JsonWriter jsonWriter = writer.nullValue();
                        continue block11;
                    }
                    case 2: {
                        JsonWriter jsonWriter = writer.value(value.getBoolean(i));
                        continue block11;
                    }
                    case 3: {
                        JsonWriter jsonWriter = writer.value(value.getDouble(i));
                        continue block11;
                    }
                    case 4: {
                        JsonWriter jsonWriter = writer.value(value.getString(i));
                        continue block11;
                    }
                    case 5: {
                        ReadableMap map;
                        ReadableMap readableMap = map = value.getMap(i);
                        if (readableMap == null) {
                            String string2 = "Required value was null.";
                            throw new IllegalStateException(string2.toString());
                        }
                        INSTANCE.readableMapValue(writer, readableMap);
                        JsonWriter jsonWriter = Unit.INSTANCE;
                        continue block11;
                    }
                    case 6: {
                        ReadableArray array = value.getArray(i);
                        ReadableArray readableArray = array;
                        if (readableArray == null) {
                            String string3 = "Required value was null.";
                            throw new IllegalStateException(string3.toString());
                        }
                        JsonWriterHelper.readableArrayValue(writer, readableArray);
                        JsonWriter jsonWriter = Unit.INSTANCE;
                        continue block11;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
        finally {
            writer.endArray();
        }
    }

    private final void mapValue(JsonWriter writer, Map<?, ?> map) throws IOException {
        writer.beginObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            writer.name(String.valueOf(key));
            JsonWriterHelper.value(writer, value);
        }
        writer.endObject();
    }

    private final void listValue(JsonWriter writer, List<?> list) throws IOException {
        writer.beginArray();
        for (Object item : list) {
            this.objectValue(writer, item);
        }
        writer.endArray();
    }

    private final void objectValue(JsonWriter writer, Object value) throws IOException {
        Object object = value;
        if (object == null) {
            v0 = writer.nullValue();
        } else if (object instanceof String) {
            v0 = writer.value((String)value);
        } else if (object instanceof Number) {
            v0 = writer.value((Number)value);
        } else if (object instanceof Boolean) {
            v0 = writer.value(((Boolean)value).booleanValue());
        } else {
            throw new IllegalArgumentException("Unknown value: " + value);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReadableType.values().length];
            try {
                nArray[ReadableType.Null.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Boolean.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Number.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.String.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Map.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Array.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

