/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.BaseReactPackage;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackageLogger;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.common.ClassFinder;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.devsupport.LogBoxModule;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.module.model.ReactModuleInfoProvider;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ExceptionsManagerModule;
import com.facebook.react.modules.core.HeadlessJsTaskSupportModule;
import com.facebook.react.modules.core.TimingModule;
import com.facebook.react.modules.debug.DevMenuModule;
import com.facebook.react.modules.debug.DevSettingsModule;
import com.facebook.react.modules.debug.SourceCodeModule;
import com.facebook.react.modules.deviceinfo.DeviceInfoModule;
import com.facebook.react.modules.systeminfo.AndroidInfoModule;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerResolver;
import com.facebook.systrace.Systrace;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/CoreModulesPackage;", "Lcom/facebook/react/BaseReactPackage;", "Lcom/facebook/react/ReactPackageLogger;", "reactInstanceManager", "Lcom/facebook/react/ReactInstanceManager;", "hardwareBackBtnHandler", "Lcom/facebook/react/modules/core/DefaultHardwareBackBtnHandler;", "lazyViewManagersEnabled", "", "minTimeLeftInFrameForNonBatchedOperationMs", "", "<init>", "(Lcom/facebook/react/ReactInstanceManager;Lcom/facebook/react/modules/core/DefaultHardwareBackBtnHandler;ZI)V", "getReactModuleInfoProvider", "Lcom/facebook/react/module/model/ReactModuleInfoProvider;", "fallbackForMissingClass", "getModule", "Lcom/facebook/react/bridge/NativeModule;", "name", "", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "createUIManager", "Lcom/facebook/react/uimanager/UIManagerModule;", "startProcessPackage", "", "endProcessPackage", "Companion", "ReactAndroid_release"})
public final class CoreModulesPackage
extends BaseReactPackage
implements ReactPackageLogger {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactInstanceManager reactInstanceManager;
    @NotNull
    private final DefaultHardwareBackBtnHandler hardwareBackBtnHandler;
    private final boolean lazyViewManagersEnabled;
    private final int minTimeLeftInFrameForNonBatchedOperationMs;

    public CoreModulesPackage(@NotNull ReactInstanceManager reactInstanceManager, @NotNull DefaultHardwareBackBtnHandler hardwareBackBtnHandler, boolean lazyViewManagersEnabled, int minTimeLeftInFrameForNonBatchedOperationMs) {
        Intrinsics.checkNotNullParameter((Object)reactInstanceManager, (String)"reactInstanceManager");
        Intrinsics.checkNotNullParameter((Object)hardwareBackBtnHandler, (String)"hardwareBackBtnHandler");
        this.reactInstanceManager = reactInstanceManager;
        this.hardwareBackBtnHandler = hardwareBackBtnHandler;
        this.lazyViewManagersEnabled = lazyViewManagersEnabled;
        this.minTimeLeftInFrameForNonBatchedOperationMs = minTimeLeftInFrameForNonBatchedOperationMs;
    }

    @Override
    @NotNull
    public ReactModuleInfoProvider getReactModuleInfoProvider() {
        if (!ClassFinder.canLoadClassesFromAnnotationProcessors()) {
            return this.fallbackForMissingClass();
        }
        try {
            Class<?> reactModuleInfoProviderClass = ClassFinder.findClass("com.facebook.react.CoreModulesPackage$$ReactModuleInfoProvider");
            GenericDeclaration genericDeclaration = reactModuleInfoProviderClass;
            Object v1 = genericDeclaration != null && (genericDeclaration = ((Class)genericDeclaration).getDeclaredConstructor(new Class[0])) != null ? ((Constructor)genericDeclaration).newInstance(new Object[0]) : null;
            Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type com.facebook.react.module.model.ReactModuleInfoProvider");
            return v1;
        }
        catch (ClassNotFoundException e) {
            return this.fallbackForMissingClass();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for CoreModulesPackage$$ReactModuleInfoProvider", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("No ReactModuleInfoProvider for CoreModulesPackage$$ReactModuleInfoProvider", e);
        }
    }

    private final ReactModuleInfoProvider fallbackForMissingClass() {
        Class[] classArray = new Class[]{AndroidInfoModule.class, DeviceEventManagerModule.class, DeviceInfoModule.class, DevMenuModule.class, DevSettingsModule.class, ExceptionsManagerModule.class, LogBoxModule.class, HeadlessJsTaskSupportModule.class, SourceCodeModule.class, TimingModule.class, UIManagerModule.class};
        Class[] moduleList = classArray;
        Map reactModuleInfoMap = new HashMap();
        for (Class moduleClass : moduleList) {
            ReactModule reactModule = moduleClass.getAnnotation(ReactModule.class);
            if (reactModule == null) continue;
            Map map = reactModuleInfoMap;
            String string = reactModule.name();
            String string2 = reactModule.name();
            String string3 = moduleClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            ReactModuleInfo reactModuleInfo = new ReactModuleInfo(string2, string3, reactModule.canOverrideExistingModule(), reactModule.needsEagerInit(), reactModule.isCxxModule(), ReactModuleInfo.Companion.classIsTurboModule(moduleClass));
            map.put(string, reactModuleInfo);
        }
        return () -> CoreModulesPackage.fallbackForMissingClass$lambda$0(reactModuleInfoMap);
    }

    @Override
    @Nullable
    public NativeModule getModule(@NotNull String name, @NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        return switch (name) {
            case "PlatformConstants" -> new AndroidInfoModule(reactContext);
            case "DeviceEventManager" -> new DeviceEventManagerModule(reactContext, this.hardwareBackBtnHandler);
            case "DevMenu" -> {
                DevSupportManager v1 = this.reactInstanceManager.getDevSupportManager();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDevSupportManager(...)");
                yield new DevMenuModule(reactContext, v1);
            }
            case "DevSettings" -> {
                DevSupportManager v2 = this.reactInstanceManager.getDevSupportManager();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDevSupportManager(...)");
                yield new DevSettingsModule(reactContext, v2);
            }
            case "ExceptionsManager" -> {
                DevSupportManager v3 = this.reactInstanceManager.getDevSupportManager();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getDevSupportManager(...)");
                yield new ExceptionsManagerModule(v3);
            }
            case "LogBox" -> {
                DevSupportManager v4 = this.reactInstanceManager.getDevSupportManager();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getDevSupportManager(...)");
                yield new LogBoxModule(reactContext, v4);
            }
            case "HeadlessJsTaskSupport" -> new HeadlessJsTaskSupportModule(reactContext);
            case "SourceCode" -> new SourceCodeModule(reactContext);
            case "Timing" -> {
                DevSupportManager v5 = this.reactInstanceManager.getDevSupportManager();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getDevSupportManager(...)");
                yield new TimingModule(reactContext, v5);
            }
            case "UIManager" -> this.createUIManager(reactContext);
            case "DeviceInfo" -> new DeviceInfoModule(reactContext);
            default -> throw new IllegalArgumentException("In CoreModulesPackage, could not find Native module for " + name);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final UIManagerModule createUIManager(ReactApplicationContext reactContext) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_START);
        Systrace.beginSection(0L, "createUIManagerModule");
        try {
            if (this.lazyViewManagersEnabled) {
                ViewManagerResolver resolver2 = new ViewManagerResolver(this){
                    final /* synthetic */ CoreModulesPackage this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public ViewManager<?, ?> getViewManager(String viewManagerName) {
                        Intrinsics.checkNotNullParameter((Object)viewManagerName, (String)"viewManagerName");
                        return CoreModulesPackage.access$getReactInstanceManager$p(this.this$0).createViewManager(viewManagerName);
                    }

                    public Collection<String> getViewManagerNames() {
                        Collection<String> collection = CoreModulesPackage.access$getReactInstanceManager$p(this.this$0).getViewManagerNames();
                        Intrinsics.checkNotNullExpressionValue(collection, (String)"getViewManagerNames(...)");
                        return collection;
                    }
                };
                UIManagerModule uIManagerModule = new UIManagerModule(reactContext, resolver2, this.minTimeLeftInFrameForNonBatchedOperationMs);
                return uIManagerModule;
            }
            UIManagerModule uIManagerModule = new UIManagerModule(reactContext, this.reactInstanceManager.getOrCreateViewManagers(reactContext), this.minTimeLeftInFrameForNonBatchedOperationMs);
            return uIManagerModule;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_UI_MANAGER_MODULE_END);
        }
    }

    @Override
    public void startProcessPackage() {
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_CORE_REACT_PACKAGE_START);
    }

    @Override
    public void endProcessPackage() {
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_CORE_REACT_PACKAGE_END);
    }

    private static final Map fallbackForMissingClass$lambda$0(Map $reactModuleInfoMap) {
        return $reactModuleInfoMap;
    }

    public static final /* synthetic */ ReactInstanceManager access$getReactInstanceManager$p(CoreModulesPackage $this) {
        return $this.reactInstanceManager;
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("CoreModulesPackage", LegacyArchitectureLogLevel.ERROR);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/facebook/react/CoreModulesPackage$Companion;", "", "<init>", "()V", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

