/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.permissions;

import android.app.Activity;
import android.content.Context;
import android.util.SparseArray;
import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativePermissionsAndroidSpec;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.core.PermissionAwareActivity;
import com.facebook.react.modules.core.PermissionListener;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="PermissionsAndroid")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J+\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lcom/facebook/react/modules/permissions/PermissionsModule;", "Lcom/facebook/fbreact/specs/NativePermissionsAndroidSpec;", "Lcom/facebook/react/modules/core/PermissionListener;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "callbacks", "Landroid/util/SparseArray;", "Lcom/facebook/react/bridge/Callback;", "requestCode", "", "GRANTED", "", "DENIED", "NEVER_ASK_AGAIN", "checkPermission", "", "permission", "promise", "Lcom/facebook/react/bridge/Promise;", "shouldShowRequestPermissionRationale", "requestPermission", "requestMultiplePermissions", "permissions", "Lcom/facebook/react/bridge/ReadableArray;", "onRequestPermissionsResult", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)Z", "permissionAwareActivity", "Lcom/facebook/react/modules/core/PermissionAwareActivity;", "getPermissionAwareActivity", "()Lcom/facebook/react/modules/core/PermissionAwareActivity;", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nPermissionsModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionsModule.kt\ncom/facebook/react/modules/permissions/PermissionsModule\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n37#2:192\n36#2,3:193\n1#3:196\n*S KotlinDebug\n*F\n+ 1 PermissionsModule.kt\ncom/facebook/react/modules/permissions/PermissionsModule\n*L\n146#1:192\n146#1:193,3\n*E\n"})
public final class PermissionsModule
extends NativePermissionsAndroidSpec
implements PermissionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SparseArray<Callback> callbacks = new SparseArray();
    private int requestCode;
    @NotNull
    private final String GRANTED;
    @NotNull
    private final String DENIED;
    @NotNull
    private final String NEVER_ASK_AGAIN;
    @NotNull
    public static final String NAME = "PermissionsAndroid";
    @NotNull
    private static final String ERROR_INVALID_ACTIVITY = "E_INVALID_ACTIVITY";

    public PermissionsModule(@Nullable ReactApplicationContext reactContext) {
        super(reactContext);
        this.GRANTED = "granted";
        this.DENIED = "denied";
        this.NEVER_ASK_AGAIN = "never_ask_again";
    }

    @Override
    public void checkPermission(@NotNull String permission, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        Context context = this.getReactApplicationContext().getBaseContext();
        promise.resolve(context.checkSelfPermission(permission) == 0);
    }

    @Override
    public void shouldShowRequestPermissionRationale(@NotNull String permission, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        try {
            promise.resolve(this.getPermissionAwareActivity().shouldShowRequestPermissionRationale(permission));
        }
        catch (IllegalStateException e) {
            promise.reject(ERROR_INVALID_ACTIVITY, e);
        }
    }

    @Override
    public void requestPermission(@NotNull String permission, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        Context context = this.getReactApplicationContext().getBaseContext();
        if (context.checkSelfPermission(permission) == 0) {
            promise.resolve(this.GRANTED);
            return;
        }
        try {
            PermissionAwareActivity activity = this.getPermissionAwareActivity();
            this.callbacks.put(this.requestCode, (Object)new Callback(promise, this, permission){
                final /* synthetic */ Promise $promise;
                final /* synthetic */ PermissionsModule this$0;
                final /* synthetic */ String $permission;
                {
                    this.$promise = $promise;
                    this.this$0 = $receiver;
                    this.$permission = $permission;
                }

                public void invoke(Object ... args) {
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    Object object = args[0];
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.IntArray");
                    int[] results = (int[])object;
                    if (!(results.length == 0) && results[0] == 0) {
                        this.$promise.resolve(PermissionsModule.access$getGRANTED$p(this.this$0));
                    } else {
                        Object object2 = args[1];
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.facebook.react.modules.core.PermissionAwareActivity");
                        PermissionAwareActivity callbackActivity = (PermissionAwareActivity)object2;
                        if (callbackActivity.shouldShowRequestPermissionRationale(this.$permission)) {
                            this.$promise.resolve(PermissionsModule.access$getDENIED$p(this.this$0));
                        } else {
                            this.$promise.resolve(PermissionsModule.access$getNEVER_ASK_AGAIN$p(this.this$0));
                        }
                    }
                }
            });
            String[] stringArray = new String[]{permission};
            activity.requestPermissions(stringArray, this.requestCode, this);
            int n = this.requestCode;
            this.requestCode = n + 1;
        }
        catch (IllegalStateException e) {
            promise.reject(ERROR_INVALID_ACTIVITY, e);
        }
    }

    @Override
    public void requestMultiplePermissions(@NotNull ReadableArray permissions, @NotNull Promise promise) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)promise, (String)"promise");
        WritableNativeMap grantedPermissions = new WritableNativeMap();
        ArrayList<String> permissionsToCheck = new ArrayList<String>();
        int checkedPermissionsCount = 0;
        Context context = this.getReactApplicationContext().getBaseContext();
        int n = permissions.size();
        for (int i = 0; i < n; ++i) {
            String perm;
            if (permissions.getString(i) == null) continue;
            if (context.checkSelfPermission(perm) == 0) {
                grantedPermissions.putString(perm, this.GRANTED);
                ++checkedPermissionsCount;
                continue;
            }
            permissionsToCheck.add(perm);
        }
        if (permissions.size() == checkedPermissionsCount) {
            promise.resolve(grantedPermissions);
            return;
        }
        try {
            PermissionAwareActivity activity = this.getPermissionAwareActivity();
            this.callbacks.put(this.requestCode, (Object)new Callback(permissionsToCheck, grantedPermissions, this, promise){
                final /* synthetic */ ArrayList<String> $permissionsToCheck;
                final /* synthetic */ WritableNativeMap $grantedPermissions;
                final /* synthetic */ PermissionsModule this$0;
                final /* synthetic */ Promise $promise;
                {
                    this.$permissionsToCheck = $permissionsToCheck;
                    this.$grantedPermissions = $grantedPermissions;
                    this.this$0 = $receiver;
                    this.$promise = $promise;
                }

                public void invoke(Object ... args) {
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    Object object = args[0];
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.IntArray");
                    int[] results = (int[])object;
                    Object object2 = args[1];
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.facebook.react.modules.core.PermissionAwareActivity");
                    PermissionAwareActivity callbackActivity = (PermissionAwareActivity)object2;
                    int n = ((Collection)this.$permissionsToCheck).size();
                    for (int j = 0; j < n; ++j) {
                        String permission;
                        Intrinsics.checkNotNullExpressionValue((Object)this.$permissionsToCheck.get(j), (String)"get(...)");
                        if (results.length > j && results[j] == 0) {
                            this.$grantedPermissions.putString(permission, PermissionsModule.access$getGRANTED$p(this.this$0));
                            continue;
                        }
                        if (callbackActivity.shouldShowRequestPermissionRationale(permission)) {
                            this.$grantedPermissions.putString(permission, PermissionsModule.access$getDENIED$p(this.this$0));
                            continue;
                        }
                        this.$grantedPermissions.putString(permission, PermissionsModule.access$getNEVER_ASK_AGAIN$p(this.this$0));
                    }
                    this.$promise.resolve(this.$grantedPermissions);
                }
            });
            Collection $this$toTypedArray$iv22 = permissionsToCheck;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv22;
            activity.requestPermissions(thisCollection$iv.toArray(new String[0]), this.requestCode, this);
            int $this$toTypedArray$iv22 = this.requestCode;
            this.requestCode = $this$toTypedArray$iv22 + 1;
        }
        catch (IllegalStateException e) {
            promise.reject(ERROR_INVALID_ACTIVITY, e);
        }
    }

    @Override
    public boolean onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        try {
            Callback callback = (Callback)this.callbacks.get(requestCode);
            if (callback != null) {
                Object[] objectArray = new Object[]{grantResults, this.getPermissionAwareActivity()};
                callback.invoke(objectArray);
                this.callbacks.remove(requestCode);
            } else {
                Object[] objectArray = new Object[]{requestCode};
                FLog.w((String)"PermissionsModule", (String)"Unable to find callback with requestCode %d", (Object[])objectArray);
            }
            bl = this.callbacks.size() == 0;
        }
        catch (IllegalStateException e) {
            FLog.e((String)"PermissionsModule", (Throwable)e, (String)"Unexpected invocation of `onRequestPermissionsResult` with invalid current activity", (Object[])new Object[0]);
            bl = false;
        }
        return bl;
    }

    private final PermissionAwareActivity getPermissionAwareActivity() {
        Activity activity = this.getReactApplicationContext().getCurrentActivity();
        if (activity == null) {
            boolean bl = false;
            String string2 = "Tried to use permissions API while not attached to an Activity.";
            throw new IllegalStateException(string2.toString());
        }
        if (!(activity instanceof PermissionAwareActivity)) {
            boolean bl = false;
            String string3 = "Tried to use permissions API but the host Activity doesn't implement PermissionAwareActivity.";
            throw new IllegalStateException(string3.toString());
        }
        return (PermissionAwareActivity)activity;
    }

    public static final /* synthetic */ String access$getGRANTED$p(PermissionsModule $this) {
        return $this.GRANTED;
    }

    public static final /* synthetic */ String access$getDENIED$p(PermissionsModule $this) {
        return $this.DENIED;
    }

    public static final /* synthetic */ String access$getNEVER_ASK_AGAIN$p(PermissionsModule $this) {
        return $this.NEVER_ASK_AGAIN;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/modules/permissions/PermissionsModule$Companion;", "", "<init>", "()V", "NAME", "", "ERROR_INVALID_ACTIVITY", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

