/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.module.annotations.ReactModule;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB%\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003J\b\u0010\r\u001a\u0004\u0018\u00010\u0006R\u001b\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00038G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/bridge/ModuleSpec;", "", "provider", "Ljavax/inject/Provider;", "Lcom/facebook/react/bridge/NativeModule;", "name", "", "<init>", "(Ljavax/inject/Provider;Ljava/lang/String;)V", "()Ljavax/inject/Provider;", "moduleName", "()Ljava/lang/String;", "getProvider", "getName", "Companion", "ReactAndroid_debug"})
public final class ModuleSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Provider<? extends NativeModule> provider;
    @Nullable
    private final String name;
    @NotNull
    private static final String TAG = "ModuleSpec";

    private ModuleSpec(Provider<? extends NativeModule> provider, String name) {
        this.provider = provider;
        this.name = name;
    }

    /* synthetic */ ModuleSpec(Provider provider, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this((Provider<? extends NativeModule>)provider, string2);
    }

    @JvmName(name="provider")
    @NotNull
    public final Provider<? extends NativeModule> provider() {
        return this.provider;
    }

    @JvmName(name="moduleName")
    @Nullable
    public final String moduleName() {
        return this.name;
    }

    @NotNull
    public final Provider<? extends NativeModule> getProvider() {
        return this.provider;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @JvmStatic
    @NotNull
    public static final ModuleSpec viewManagerSpec(@NotNull Provider<? extends NativeModule> provider) {
        return Companion.viewManagerSpec(provider);
    }

    @JvmStatic
    @NotNull
    public static final ModuleSpec nativeModuleSpec(@NotNull Class<? extends NativeModule> type, @NotNull Provider<? extends NativeModule> provider) {
        return Companion.nativeModuleSpec(type, provider);
    }

    @JvmStatic
    @NotNull
    public static final ModuleSpec nativeModuleSpec(@NotNull String className, @NotNull Provider<? extends NativeModule> provider) {
        return Companion.nativeModuleSpec(className, provider);
    }

    public /* synthetic */ ModuleSpec(Provider provider, String name, DefaultConstructorMarker $constructor_marker) {
        this((Provider<? extends NativeModule>)provider, name);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0007J(\u0010\u000b\u001a\u00020\u00072\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r2\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0007J \u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00052\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/bridge/ModuleSpec$Companion;", "", "<init>", "()V", "TAG", "", "viewManagerSpec", "Lcom/facebook/react/bridge/ModuleSpec;", "provider", "Ljavax/inject/Provider;", "Lcom/facebook/react/bridge/NativeModule;", "nativeModuleSpec", "type", "Ljava/lang/Class;", "className", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ModuleSpec viewManagerSpec(@NotNull Provider<? extends NativeModule> provider) {
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            return new ModuleSpec(provider, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final ModuleSpec nativeModuleSpec(@NotNull Class<? extends NativeModule> type, @NotNull Provider<? extends NativeModule> provider) {
            ModuleSpec moduleSpec;
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            ReactModule annotation = type.getAnnotation(ReactModule.class);
            if (annotation == null) {
                FLog.w((String)ModuleSpec.TAG, (String)("Could not find @ReactModule annotation on " + type.getName() + ". Creating the module eagerly to get the name. Consider adding the annotation."));
                Object object = provider.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                NativeModule nativeModule = (NativeModule)object;
                moduleSpec = new ModuleSpec(provider, nativeModule.getName(), null);
            } else {
                moduleSpec = new ModuleSpec(provider, annotation.name(), null);
            }
            return moduleSpec;
        }

        @JvmStatic
        @NotNull
        public final ModuleSpec nativeModuleSpec(@NotNull String className, @NotNull Provider<? extends NativeModule> provider) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter(provider, (String)"provider");
            return new ModuleSpec(provider, className, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

