/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.jni.HybridData;
import com.facebook.react.BaseReactPackage;
import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.CxxModuleWrapper;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.internal.turbomodule.core.TurboModuleManagerDelegate;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0002\"#B\u001f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB'\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u0005H\u0016J\b\u0010!\u001a\u00020\u0015H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/facebook/react/ReactPackageTurboModuleManagerDelegate;", "Lcom/facebook/react/internal/turbomodule/core/TurboModuleManagerDelegate;", "reactApplicationContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "packages", "", "Lcom/facebook/react/ReactPackage;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;Ljava/util/List;)V", "hybridData", "Lcom/facebook/jni/HybridData;", "(Lcom/facebook/react/bridge/ReactApplicationContext;Ljava/util/List;Lcom/facebook/jni/HybridData;)V", "moduleProviders", "", "Lcom/facebook/react/ReactPackageTurboModuleManagerDelegate$ModuleProvider;", "packageModuleInfos", "", "", "", "Lcom/facebook/react/module/model/ReactModuleInfo;", "shouldEnableLegacyModuleInterop", "", "initialize", "", "unstable_shouldEnableLegacyModuleInterop", "getModule", "Lcom/facebook/react/turbomodule/core/interfaces/TurboModule;", "moduleName", "unstable_isModuleRegistered", "unstable_isLegacyModuleRegistered", "getLegacyModule", "Lcom/facebook/react/bridge/NativeModule;", "getEagerInitModuleNames", "shouldSupportLegacyPackages", "ModuleProvider", "Builder", "ReactAndroid_debug"})
public abstract class ReactPackageTurboModuleManagerDelegate
extends TurboModuleManagerDelegate {
    @NotNull
    private final List<ModuleProvider> moduleProviders;
    @NotNull
    private final Map<ModuleProvider, Map<String, ReactModuleInfo>> packageModuleInfos;
    private final boolean shouldEnableLegacyModuleInterop;

    protected ReactPackageTurboModuleManagerDelegate(@NotNull ReactApplicationContext reactApplicationContext, @NotNull List<? extends ReactPackage> packages) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        this.moduleProviders = new ArrayList();
        this.packageModuleInfos = new LinkedHashMap();
        this.shouldEnableLegacyModuleInterop = ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture() && ReactNativeNewArchitectureFeatureFlags.useTurboModuleInterop();
        this.initialize(reactApplicationContext, packages);
    }

    protected ReactPackageTurboModuleManagerDelegate(@NotNull ReactApplicationContext reactApplicationContext, @NotNull List<? extends ReactPackage> packages, @NotNull HybridData hybridData) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        Intrinsics.checkNotNullParameter((Object)hybridData, (String)"hybridData");
        super(hybridData);
        this.moduleProviders = new ArrayList();
        this.packageModuleInfos = new LinkedHashMap();
        this.shouldEnableLegacyModuleInterop = ReactNativeNewArchitectureFeatureFlags.enableBridgelessArchitecture() && ReactNativeNewArchitectureFeatureFlags.useTurboModuleInterop();
        this.initialize(reactApplicationContext, packages);
    }

    private final void initialize(ReactApplicationContext reactApplicationContext, List<? extends ReactPackage> packages) {
        ReactApplicationContext applicationContext = reactApplicationContext;
        for (ReactPackage reactPackage : packages) {
            Object moduleProvider;
            if (reactPackage instanceof BaseReactPackage) {
                ModuleProvider moduleProvider2 = arg_0 -> ReactPackageTurboModuleManagerDelegate.initialize$lambda$0(reactPackage, applicationContext, arg_0);
                this.moduleProviders.add(moduleProvider2);
                this.packageModuleInfos.put(moduleProvider2, ((BaseReactPackage)reactPackage).getReactModuleInfoProvider().getReactModuleInfos());
                continue;
            }
            if (this.shouldSupportLegacyPackages() && reactPackage instanceof LazyReactPackage) {
                ReactPackage lazyPkg = reactPackage;
                List<ModuleSpec> moduleSpecs = ((LazyReactPackage)lazyPkg).internal_getNativeModules$ReactAndroid_debug(reactApplicationContext);
                Map moduleSpecProviderMap = new LinkedHashMap();
                for (ModuleSpec moduleSpec : moduleSpecs) {
                    moduleSpecProviderMap.put(moduleSpec.getName(), moduleSpec.getProvider());
                }
                moduleProvider = arg_0 -> ReactPackageTurboModuleManagerDelegate.initialize$lambda$1(moduleSpecProviderMap, arg_0);
                this.moduleProviders.add((ModuleProvider)moduleProvider);
                this.packageModuleInfos.put((ModuleProvider)moduleProvider, ((LazyReactPackage)lazyPkg).getReactModuleInfoProvider().getReactModuleInfos());
                continue;
            }
            if (!this.shouldSupportLegacyPackages()) continue;
            List<NativeModule> nativeModules = reactPackage.createNativeModules(reactApplicationContext);
            Map moduleMap = new LinkedHashMap();
            Map reactModuleInfoMap = new LinkedHashMap();
            for (NativeModule module : nativeModules) {
                ReactModuleInfo reactModuleInfo;
                Class<?> moduleClass = module.getClass();
                ReactModule reactModule = moduleClass.getAnnotation(ReactModule.class);
                Object object = reactModule;
                if (object == null || (object = object.name()) == null) {
                    String string2 = module.getName();
                    object = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                }
                Object moduleName = object;
                if (reactModule != null) {
                    String string3 = moduleClass.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    reactModuleInfo = new ReactModuleInfo((String)moduleName, string3, reactModule.canOverrideExistingModule(), true, reactModule.isCxxModule(), ReactModuleInfo.Companion.classIsTurboModule(moduleClass));
                } else {
                    String string4 = moduleClass.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                    reactModuleInfo = new ReactModuleInfo((String)moduleName, string4, module.canOverrideExistingModule(), true, CxxModuleWrapper.class.isAssignableFrom(moduleClass), ReactModuleInfo.Companion.classIsTurboModule(moduleClass));
                }
                ReactModuleInfo moduleInfo = reactModuleInfo;
                reactModuleInfoMap.put(moduleName, moduleInfo);
                moduleMap.put(moduleName, module);
            }
            moduleProvider = arg_0 -> ReactPackageTurboModuleManagerDelegate.initialize$lambda$2(moduleMap, arg_0);
            this.moduleProviders.add((ModuleProvider)moduleProvider);
            this.packageModuleInfos.put((ModuleProvider)moduleProvider, reactModuleInfoMap);
        }
    }

    @Override
    public boolean unstable_shouldEnableLegacyModuleInterop() {
        return this.shouldEnableLegacyModuleInterop;
    }

    @Override
    @Nullable
    public TurboModule getModule(@NotNull String moduleName) {
        boolean isLegacyModule;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        NativeModule resolvedModule = null;
        for (ModuleProvider moduleProvider : this.moduleProviders) {
            NativeModule module;
            ReactModuleInfo moduleInfo;
            Map<String, ReactModuleInfo> map = this.packageModuleInfos.get(moduleProvider);
            ReactModuleInfo reactModuleInfo = moduleInfo = map != null ? map.get(moduleName) : null;
            boolean bl = reactModuleInfo != null ? reactModuleInfo.isTurboModule() : false;
            if (!bl || resolvedModule != null && !moduleInfo.canOverrideExistingModule() || (module = moduleProvider.getModule(moduleName)) == null) continue;
            resolvedModule = module;
        }
        boolean bl = isLegacyModule = !(resolvedModule instanceof TurboModule);
        if (isLegacyModule) {
            return null;
        }
        NativeModule nativeModule = resolvedModule;
        Intrinsics.checkNotNull(nativeModule, (String)"null cannot be cast to non-null type com.facebook.react.turbomodule.core.interfaces.TurboModule");
        return (TurboModule)((Object)nativeModule);
    }

    @Override
    public boolean unstable_isModuleRegistered(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        for (ModuleProvider moduleProvider : this.moduleProviders) {
            ReactModuleInfo moduleInfo;
            Map<String, ReactModuleInfo> map = this.packageModuleInfos.get(moduleProvider);
            ReactModuleInfo reactModuleInfo = moduleInfo = map != null ? map.get(moduleName) : null;
            boolean bl = reactModuleInfo != null ? reactModuleInfo.isTurboModule() : false;
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean unstable_isLegacyModuleRegistered(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        for (ModuleProvider moduleProvider : this.moduleProviders) {
            ReactModuleInfo moduleInfo;
            Map<String, ReactModuleInfo> map = this.packageModuleInfos.get(moduleProvider);
            ReactModuleInfo reactModuleInfo = moduleInfo = map != null ? map.get(moduleName) : null;
            boolean bl = reactModuleInfo != null ? !reactModuleInfo.isTurboModule() : false;
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public NativeModule getLegacyModule(@NotNull String moduleName) {
        boolean isLegacyModule;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        if (!this.unstable_shouldEnableLegacyModuleInterop()) {
            return null;
        }
        NativeModule resolvedModule = null;
        for (ModuleProvider moduleProvider : this.moduleProviders) {
            NativeModule module;
            ReactModuleInfo moduleInfo;
            Map<String, ReactModuleInfo> map = this.packageModuleInfos.get(moduleProvider);
            ReactModuleInfo reactModuleInfo = moduleInfo = map != null ? map.get(moduleName) : null;
            boolean bl = reactModuleInfo != null ? !reactModuleInfo.isTurboModule() : false;
            if (!bl || resolvedModule != null && !moduleInfo.canOverrideExistingModule() || (module = moduleProvider.getModule(moduleName)) == null) continue;
            resolvedModule = module;
        }
        boolean bl = isLegacyModule = !(resolvedModule instanceof TurboModule);
        if (!isLegacyModule) {
            return null;
        }
        return resolvedModule;
    }

    @Override
    @NotNull
    public List<String> getEagerInitModuleNames() {
        List list;
        List $this$getEagerInitModuleNames_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (ModuleProvider moduleProvider : this.moduleProviders) {
            Map<String, ReactModuleInfo> map = this.packageModuleInfos.get(moduleProvider);
            if (map == null || (map = map.values()) == null) {
                map = CollectionsKt.emptyList();
            }
            Iterator iterator2 = map.iterator();
            while (iterator2.hasNext()) {
                ReactModuleInfo moduleInfo = (ReactModuleInfo)iterator2.next();
                if (!moduleInfo.isTurboModule() || !moduleInfo.needsEagerInit()) continue;
                $this$getEagerInitModuleNames_u24lambda_u243.add(moduleInfo.name());
            }
        }
        return CollectionsKt.build((List)list);
    }

    private final boolean shouldSupportLegacyPackages() {
        return this.unstable_shouldEnableLegacyModuleInterop();
    }

    private static final NativeModule initialize$lambda$0(ReactPackage $reactPackage, ReactApplicationContext $applicationContext, String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return ((BaseReactPackage)$reactPackage).getModule(moduleName, $applicationContext);
    }

    private static final NativeModule initialize$lambda$1(Map $moduleSpecProviderMap, String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Provider provider = (Provider)$moduleSpecProviderMap.get(moduleName);
        return provider != null ? (NativeModule)provider.get() : null;
    }

    private static final NativeModule initialize$lambda$2(Map $moduleMap, String module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return (NativeModule)$moduleMap.get(module);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u00020\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0010\u0010\n\u001a\u00020\u00002\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H$J\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/ReactPackageTurboModuleManagerDelegate$Builder;", "", "<init>", "()V", "packages", "", "Lcom/facebook/react/ReactPackage;", "context", "Lcom/facebook/react/bridge/ReactApplicationContext;", "setPackages", "setReactApplicationContext", "build", "Lcom/facebook/react/ReactPackageTurboModuleManagerDelegate;", "ReactAndroid_debug"})
    public static abstract class Builder {
        @Nullable
        private List<? extends ReactPackage> packages;
        @Nullable
        private ReactApplicationContext context;

        @NotNull
        public final Builder setPackages(@NotNull List<? extends ReactPackage> packages) {
            Intrinsics.checkNotNullParameter(packages, (String)"packages");
            this.packages = CollectionsKt.toList((Iterable)packages);
            return this;
        }

        @NotNull
        public final Builder setReactApplicationContext(@Nullable ReactApplicationContext context) {
            this.context = context;
            return this;
        }

        @NotNull
        protected abstract ReactPackageTurboModuleManagerDelegate build(@NotNull ReactApplicationContext var1, @NotNull List<? extends ReactPackage> var2);

        @NotNull
        public final ReactPackageTurboModuleManagerDelegate build() {
            ReactApplicationContext reactApplicationContext = this.context;
            if (reactApplicationContext == null) {
                boolean bl = false;
                String string2 = "The ReactApplicationContext must be provided to create ReactPackageTurboModuleManagerDelegate";
                throw new IllegalArgumentException(string2.toString());
            }
            ReactApplicationContext nonNullContext = reactApplicationContext;
            List<? extends ReactPackage> list = this.packages;
            if (list == null) {
                boolean bl = false;
                String string3 = "A set of ReactPackages must be provided to create ReactPackageTurboModuleManagerDelegate";
                throw new IllegalArgumentException(string3.toString());
            }
            List<? extends ReactPackage> nonNullPackages = list;
            return this.build(nonNullContext, nonNullPackages);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/ReactPackageTurboModuleManagerDelegate$ModuleProvider;", "", "getModule", "Lcom/facebook/react/bridge/NativeModule;", "moduleName", "", "ReactAndroid_debug"})
    public static interface ModuleProvider {
        @Nullable
        public NativeModule getModule(@NotNull String var1);
    }
}

