/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.util.Linkify;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.TintContextWrapper;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ExploreByTouchHelper;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.internal.SystraceSection;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.uimanager.style.Overflow;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ReactTextViewAccessibilityDelegate;
import com.facebook.react.views.text.TextLayoutManager;
import com.facebook.react.views.text.internal.span.ReactTagSpan;
import com.facebook.react.views.text.internal.span.TextInlineImageSpan;
import com.facebook.react.views.text.internal.span.TextInlineViewPlaceholderSpan;
import com.facebook.yoga.YogaMeasureMode;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactTextView
extends AppCompatTextView
implements ReactCompoundView {
    private static final ViewGroup.LayoutParams EMPTY_LAYOUT_PARAMS = new ViewGroup.LayoutParams(0, 0);
    private static final int DEFAULT_GRAVITY = 0x800033;
    private boolean mContainsImages;
    private int mNumberOfLines;
    @Nullable
    private TextUtils.TruncateAt mEllipsizeLocation;
    private boolean mAdjustsFontSizeToFit;
    private float mFontSize;
    private float mMinimumFontSize;
    private float mLetterSpacing;
    private int mLinkifyMaskType;
    private boolean mTextIsSelectable;
    private boolean mShouldAdjustSpannableFontSize;
    private Overflow mOverflow = Overflow.VISIBLE;
    @Nullable
    private Spannable mSpanned;

    public ReactTextView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.mNumberOfLines = Integer.MAX_VALUE;
        this.mAdjustsFontSizeToFit = false;
        this.mLinkifyMaskType = 0;
        this.mTextIsSelectable = false;
        this.mShouldAdjustSpannableFontSize = false;
        this.mEllipsizeLocation = TextUtils.TruncateAt.END;
        this.mFontSize = Float.NaN;
        this.mMinimumFontSize = Float.NaN;
        this.mLetterSpacing = 0.0f;
        this.mOverflow = Overflow.VISIBLE;
        this.mSpanned = null;
    }

    void recycleView() {
        this.initView();
        if (this.getParent() != null) {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        BackgroundStyleApplicator.reset((View)this);
        this.setBreakStrategy(0);
        this.setMovementMethod(this.getDefaultMovementMethod());
        if (Build.VERSION.SDK_INT >= 26) {
            this.setJustificationMode(0);
        }
        this.setLayoutParams(EMPTY_LAYOUT_PARAMS);
        super.setText(null);
        this.applyTextAttributes();
        this.setGravity(0x800033);
        this.setNumberOfLines(this.mNumberOfLines);
        this.setAdjustFontSizeToFit(this.mAdjustsFontSizeToFit);
        this.setLinkifyMask(this.mLinkifyMaskType);
        this.setTextIsSelectable(this.mTextIsSelectable);
        this.setIncludeFontPadding(true);
        this.setEnabled(true);
        this.setLinkifyMask(0);
        this.setEllipsizeLocation(this.mEllipsizeLocation);
        this.setEnabled(true);
        if (Build.VERSION.SDK_INT >= 26) {
            this.setFocusable(16);
        }
        this.setHyphenationFrequency(0);
        this.updateView();
    }

    private static WritableMap inlineViewJson(int visibility, int index, int left, int top, int right, int bottom) {
        WritableMap json = Arguments.createMap();
        if (visibility == 8) {
            json.putString("visibility", "gone");
            json.putInt("index", index);
        } else if (visibility == 0) {
            json.putString("visibility", "visible");
            json.putInt("index", index);
            json.putDouble("left", PixelUtil.toDIPFromPixel(left));
            json.putDouble("top", PixelUtil.toDIPFromPixel(top));
            json.putDouble("right", PixelUtil.toDIPFromPixel(right));
            json.putDouble("bottom", PixelUtil.toDIPFromPixel(bottom));
        } else {
            json.putString("visibility", "unknown");
            json.putInt("index", index);
        }
        return json;
    }

    private ReactContext getReactContext() {
        Context context = this.getContext();
        return context instanceof TintContextWrapper ? (ReactContext)((TintContextWrapper)context).getBaseContext() : (ReactContext)context;
    }

    protected void onLayout(boolean changed, int textViewLeft, int textViewTop, int textViewRight, int textViewBottom) {
        int reactTag = this.getId();
        if (!(this.getText() instanceof Spanned) || ViewUtil.getUIManagerType(reactTag) == 2 || ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            return;
        }
        ReactContext reactContext = this.getReactContext();
        UIManagerModule uiManager = (UIManagerModule)Assertions.assertNotNull((Object)reactContext.getNativeModule(UIManagerModule.class));
        Spanned text = (Spanned)this.getText();
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return;
        }
        TextInlineViewPlaceholderSpan[] placeholders = (TextInlineViewPlaceholderSpan[])text.getSpans(0, text.length(), TextInlineViewPlaceholderSpan.class);
        int textViewWidth = textViewRight - textViewLeft;
        int textViewHeight = textViewBottom - textViewTop;
        for (TextInlineViewPlaceholderSpan placeholder : placeholders) {
            int placeholderHorizontalPosition;
            boolean isRtlParagraph;
            boolean isLineTruncated;
            View child = uiManager.resolveView(placeholder.getReactTag());
            int start = text.getSpanStart((Object)placeholder);
            int line = layout2.getLineForOffset(start);
            boolean bl = isLineTruncated = layout2.getEllipsisCount(line) > 0;
            if (isLineTruncated && start >= layout2.getLineStart(line) + layout2.getEllipsisStart(line) || line >= this.mNumberOfLines || start >= layout2.getLineEnd(line)) {
                child.setVisibility(8);
                continue;
            }
            int width = placeholder.getWidth();
            int height = placeholder.getHeight();
            boolean isRtlChar = layout2.isRtlCharAt(start);
            boolean bl2 = isRtlParagraph = layout2.getParagraphDirection(line) == -1;
            if (start == text.length() - 1) {
                boolean endsWithNewLine = text.length() > 0 && text.charAt(layout2.getLineEnd(line) - 1) == '\n';
                float lineWidth = endsWithNewLine ? layout2.getLineMax(line) : layout2.getLineWidth(line);
                placeholderHorizontalPosition = isRtlParagraph ? textViewWidth - (int)lineWidth : (int)layout2.getLineRight(line) - width;
            } else {
                boolean characterAndParagraphDirectionMatch = isRtlParagraph == isRtlChar;
                int n = placeholderHorizontalPosition = characterAndParagraphDirectionMatch ? (int)layout2.getPrimaryHorizontal(start) : (int)layout2.getSecondaryHorizontal(start);
                if (isRtlParagraph) {
                    placeholderHorizontalPosition = textViewWidth - ((int)layout2.getLineRight(line) - placeholderHorizontalPosition);
                }
                if (isRtlChar) {
                    placeholderHorizontalPosition -= width;
                }
            }
            int leftRelativeToTextView = isRtlChar ? placeholderHorizontalPosition + this.getTotalPaddingRight() : placeholderHorizontalPosition + this.getTotalPaddingLeft();
            int left = textViewLeft + leftRelativeToTextView;
            int topRelativeToTextView = this.getTotalPaddingTop() + layout2.getLineBaseline(line) - height;
            int top = textViewTop + topRelativeToTextView;
            boolean isFullyClipped = textViewWidth <= leftRelativeToTextView || textViewHeight <= topRelativeToTextView;
            int layoutVisibility = isFullyClipped ? 8 : 0;
            int layoutLeft = left;
            int layoutTop = top;
            int layoutRight = left + width;
            int layoutBottom = top + height;
            child.setVisibility(layoutVisibility);
            child.layout(layoutLeft, layoutTop, layoutRight, layoutBottom);
        }
    }

    protected void onDraw(Canvas canvas) {
        try (SystraceSection s = new SystraceSection("ReactTextView.onDraw");){
            Spannable spanned = this.getSpanned();
            if (this.mAdjustsFontSizeToFit && spanned != null && this.mShouldAdjustSpannableFontSize) {
                this.mShouldAdjustSpannableFontSize = false;
                TextLayoutManager.adjustSpannableFontToFit(spanned, this.getWidth(), YogaMeasureMode.EXACTLY, this.getHeight(), YogaMeasureMode.EXACTLY, this.mMinimumFontSize, this.mNumberOfLines, this.getIncludeFontPadding(), this.getBreakStrategy(), this.getHyphenationFrequency(), Layout.Alignment.ALIGN_NORMAL, Build.VERSION.SDK_INT < 26 ? -1 : this.getJustificationMode(), this.getPaint());
                this.setText((CharSequence)spanned);
            }
            if (this.mOverflow != Overflow.VISIBLE) {
                BackgroundStyleApplicator.clipToPaddingBox((View)this, canvas);
            }
            super.onDraw(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        try (SystraceSection s = new SystraceSection("ReactTextView.onMeasure");){
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void setText(ReactTextUpdate update) {
        try (SystraceSection s = new SystraceSection("ReactTextView.setText(ReactTextUpdate)");){
            int nextTextAlign;
            this.mContainsImages = update.containsImages();
            if (this.getLayoutParams() == null) {
                this.setLayoutParams(EMPTY_LAYOUT_PARAMS);
            }
            Spannable spannable = update.getText();
            if (this.mLinkifyMaskType > 0) {
                Linkify.addLinks((Spannable)spannable, (int)this.mLinkifyMaskType);
                this.setMovementMethod(LinkMovementMethod.getInstance());
            }
            this.setText((CharSequence)spannable);
            float paddingLeft = update.getPaddingLeft();
            float paddingTop = update.getPaddingTop();
            float paddingRight = update.getPaddingRight();
            float paddingBottom = update.getPaddingBottom();
            if (paddingLeft != -1.0f && paddingTop != -1.0f && paddingRight != -1.0f && paddingBottom != -1.0f) {
                this.setPadding((int)Math.floor(paddingLeft), (int)Math.floor(paddingTop), (int)Math.floor(paddingRight), (int)Math.floor(paddingBottom));
            }
            if ((nextTextAlign = update.getTextAlign()) != this.getGravityHorizontal()) {
                this.setGravityHorizontal(nextTextAlign);
            }
            if (this.getBreakStrategy() != update.getTextBreakStrategy()) {
                this.setBreakStrategy(update.getTextBreakStrategy());
            }
            if (Build.VERSION.SDK_INT >= 26 && this.getJustificationMode() != update.getJustificationMode()) {
                this.setJustificationMode(update.getJustificationMode());
            }
            this.requestLayout();
        }
    }

    @Override
    public int reactTagForTouch(float touchX, float touchY) {
        CharSequence text = this.getText();
        int target = this.getId();
        int x = (int)touchX;
        int y = (int)touchY;
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return target;
        }
        int line = layout2.getLineForVertical(y);
        int lineStartX = (int)layout2.getLineLeft(line);
        int lineEndX = (int)layout2.getLineRight(line);
        if (text instanceof Spanned && x >= lineStartX && x <= lineEndX) {
            Spanned spannedText = (Spanned)text;
            int index = -1;
            try {
                index = layout2.getOffsetForHorizontal(line, (float)x);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                FLog.e((String)"ReactNative", (String)("Crash in HorizontalMeasurementProvider: " + e.getMessage()));
                return target;
            }
            ReactTagSpan[] spans = (ReactTagSpan[])spannedText.getSpans(index, index, ReactTagSpan.class);
            if (spans != null) {
                int targetSpanTextLength = text.length();
                for (int i = 0; i < spans.length; ++i) {
                    int spanStart = spannedText.getSpanStart((Object)spans[i]);
                    int spanEnd = spannedText.getSpanEnd((Object)spans[i]);
                    if (spanEnd < index || spanEnd - spanStart > targetSpanTextLength) continue;
                    target = spans[i].getReactTag();
                    targetSpanTextLength = spanEnd - spanStart;
                }
            }
        }
        return target;
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable2) continue;
                return true;
            }
        }
        return super.verifyDrawable(drawable2);
    }

    public void invalidateDrawable(Drawable drawable2) {
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable2) continue;
                this.invalidate();
            }
        }
        super.invalidateDrawable(drawable2);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onDetachedFromWindow();
            }
        }
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onStartTemporaryDetach();
            }
        }
    }

    public void setTextIsSelectable(boolean selectable) {
        this.mTextIsSelectable = selectable;
        super.setTextIsSelectable(selectable);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTextIsSelectable) {
            this.setTextIsSelectable(false);
            this.setTextIsSelectable(true);
        } else {
            this.setTextIsSelectable(false);
        }
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onAttachedToWindow();
            }
        }
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Spanned text = (Spanned)this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onFinishTemporaryDetach();
            }
        }
    }

    public boolean hasOverlappingRendering() {
        return false;
    }

    int getGravityHorizontal() {
        return this.getGravity() & 0x800007;
    }

    void setGravityHorizontal(int gravityHorizontal) {
        if (gravityHorizontal == 0) {
            gravityHorizontal = 0x800003;
        }
        this.setGravity(this.getGravity() & 0xFFFFFFF8 & 0xFF7FFFF8 | gravityHorizontal);
    }

    void setGravityVertical(int gravityVertical) {
        if (gravityVertical == 0) {
            gravityVertical = 48;
        }
        this.setGravity(this.getGravity() & 0xFFFFFF8F | gravityVertical);
    }

    public void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines == 0 ? Integer.MAX_VALUE : numberOfLines;
        this.setMaxLines(this.mNumberOfLines);
        this.mShouldAdjustSpannableFontSize = true;
    }

    public void setAdjustFontSizeToFit(boolean adjustsFontSizeToFit) {
        this.mAdjustsFontSizeToFit = adjustsFontSizeToFit;
    }

    public void setFontSize(float fontSize) {
        this.mFontSize = this.mAdjustsFontSizeToFit ? (float)Math.ceil(PixelUtil.toPixelFromSP(fontSize)) : (float)Math.ceil(PixelUtil.toPixelFromDIP(fontSize));
        this.applyTextAttributes();
    }

    public void setMinimumFontSize(float minimumFontSize) {
        this.mMinimumFontSize = minimumFontSize;
        this.mShouldAdjustSpannableFontSize = true;
    }

    public void setIncludeFontPadding(boolean includepad) {
        super.setIncludeFontPadding(includepad);
        this.mShouldAdjustSpannableFontSize = true;
    }

    public void setBreakStrategy(int breakStrategy) {
        super.setBreakStrategy(breakStrategy);
        this.mShouldAdjustSpannableFontSize = true;
    }

    public void setHyphenationFrequency(int hyphenationFrequency) {
        super.setHyphenationFrequency(hyphenationFrequency);
        this.mShouldAdjustSpannableFontSize = true;
    }

    public void setLetterSpacing(float letterSpacing) {
        if (Float.isNaN(letterSpacing)) {
            return;
        }
        float letterSpacingPixels = PixelUtil.toPixelFromDIP(letterSpacing);
        this.mLetterSpacing = letterSpacingPixels / this.mFontSize;
        this.applyTextAttributes();
    }

    public void setEllipsizeLocation(@Nullable TextUtils.TruncateAt ellipsizeLocation) {
        this.mEllipsizeLocation = ellipsizeLocation;
    }

    public void updateView() {
        TextUtils.TruncateAt ellipsizeLocation = this.mNumberOfLines == Integer.MAX_VALUE || this.mAdjustsFontSizeToFit ? null : this.mEllipsizeLocation;
        this.setEllipsize(ellipsizeLocation);
    }

    public void setBackgroundColor(int color) {
        BackgroundStyleApplicator.setBackgroundColor((View)this, color);
    }

    public void setBorderWidth(int position, float width) {
        BackgroundStyleApplicator.setBorderWidth((View)this, LogicalEdge.values()[position], Float.valueOf(PixelUtil.toDIPFromPixel(width)));
    }

    public void setBorderColor(int position, @Nullable Integer color) {
        BackgroundStyleApplicator.setBorderColor((View)this, LogicalEdge.values()[position], color);
    }

    public void setBorderRadius(float borderRadius) {
        this.setBorderRadius(borderRadius, BorderRadiusProp.BORDER_RADIUS.ordinal());
    }

    public void setBorderRadius(float borderRadius, int position) {
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(PixelUtil.toDIPFromPixel(borderRadius), LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)this, BorderRadiusProp.values()[position], radius);
    }

    public void setBorderStyle(@Nullable String style2) {
        BackgroundStyleApplicator.setBorderStyle((View)this, style2 == null ? null : BorderStyle.fromString(style2));
    }

    public void setSpanned(Spannable spanned) {
        this.mSpanned = spanned;
        this.mShouldAdjustSpannableFontSize = true;
    }

    @Nullable
    public Spannable getSpanned() {
        return this.mSpanned;
    }

    public void setLinkifyMask(int mask) {
        this.mLinkifyMaskType = mask;
    }

    protected boolean dispatchHoverEvent(MotionEvent event) {
        AccessibilityDelegateCompat delegate;
        if (ViewCompat.hasAccessibilityDelegate((View)this) && (delegate = ViewCompat.getAccessibilityDelegate((View)this)) instanceof ExploreByTouchHelper) {
            return ((ExploreByTouchHelper)delegate).dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
        }
        return super.dispatchHoverEvent(event);
    }

    public final void onFocusChanged(boolean gainFocus, int direction, @Nullable Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        AccessibilityDelegateCompat accessibilityDelegateCompat = ViewCompat.getAccessibilityDelegate((View)this);
        if (accessibilityDelegateCompat != null && accessibilityDelegateCompat instanceof ReactTextViewAccessibilityDelegate && this.getMovementMethod() == null) {
            ((ReactTextViewAccessibilityDelegate)accessibilityDelegateCompat).onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        AccessibilityDelegateCompat accessibilityDelegateCompat = ViewCompat.getAccessibilityDelegate((View)this);
        return accessibilityDelegateCompat != null && this.getMovementMethod() == null && accessibilityDelegateCompat instanceof ReactTextViewAccessibilityDelegate && ((ReactTextViewAccessibilityDelegate)accessibilityDelegateCompat).dispatchKeyEvent(event) || super.dispatchKeyEvent(event);
    }

    private void applyTextAttributes() {
        if (!Float.isNaN(this.mFontSize)) {
            this.setTextSize(0, this.mFontSize);
        }
        if (!Float.isNaN(this.mLetterSpacing)) {
            super.setLetterSpacing(this.mLetterSpacing);
        }
    }

    public void setOverflow(@Nullable String overflow) {
        Overflow parsedOverflow;
        this.mOverflow = overflow == null ? Overflow.VISIBLE : ((parsedOverflow = Overflow.fromString(overflow)) == null ? Overflow.VISIBLE : parsedOverflow);
        this.invalidate();
    }
}

