/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.webkit.CookieManager;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactContext;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J=\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\bH\u0096\u0002J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\bH\u0016J\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000fJ\u001c\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\nJ\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002R\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/modules/network/ForwardingCookieHandler;", "Ljava/net/CookieHandler;", "<init>", "()V", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "(Lcom/facebook/react/bridge/ReactContext;)V", "get", "", "", "", "uri", "Ljava/net/URI;", "headers", "put", "", "clearCookies", "callback", "Lcom/facebook/react/bridge/Callback;", "destroy", "addCookies", "url", "cookies", "addCookieAsync", "cookie", "cookieManager", "Landroid/webkit/CookieManager;", "getCookieManager", "()Landroid/webkit/CookieManager;", "Companion", "ReactAndroid_debug"})
public final class ForwardingCookieHandler
extends CookieHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private CookieManager cookieManager;
    @NotNull
    private static final String VERSION_ZERO_HEADER = "Set-cookie";
    @NotNull
    private static final String VERSION_ONE_HEADER = "Set-cookie2";
    @NotNull
    private static final String COOKIE_HEADER = "Cookie";

    public ForwardingCookieHandler() {
    }

    @Deprecated(message="Use the default constructor", replaceWith=@ReplaceWith(expression="ForwardingCookieHandler()", imports={}))
    public ForwardingCookieHandler(@NotNull ReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        this();
    }

    @NotNull
    public Map<String, List<String>> get(@NotNull URI uri, @NotNull Map<String, ? extends List<String>> headers) throws IOException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        CookieManager cookieManager = this.getCookieManager();
        String cookies = cookieManager != null ? cookieManager.getCookie(uri.toString()) : null;
        CharSequence charSequence = cookies;
        if (charSequence == null || charSequence.length() == 0) {
            return MapsKt.emptyMap();
        }
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)COOKIE_HEADER, (Object)CollectionsKt.listOf((Object)cookies)));
    }

    public void put(@NotNull URI uri, @NotNull Map<String, ? extends List<String>> headers) throws IOException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        String string2 = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String url = string2;
        for (Map.Entry<String, ? extends List<String>> entry : headers.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            if (!ForwardingCookieHandler.Companion.isCookieHeader(key)) continue;
            this.addCookies(url, value);
        }
    }

    public final void clearCookies(@NotNull Callback callback) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            CookieManager cookieManager = this.getCookieManager();
            if (cookieManager == null) break block0;
            cookieManager.removeAllCookies(arg_0 -> ForwardingCookieHandler.clearCookies$lambda$0(callback, arg_0));
        }
    }

    public final void destroy() {
    }

    public final void addCookies(@NotNull String url, @NotNull List<String> cookies) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
            for (String cookie : cookies) {
                this.addCookieAsync(url, cookie);
            }
            CookieManager cookieManager = this.getCookieManager();
            if (cookieManager == null) break block1;
            cookieManager.flush();
        }
    }

    private final void addCookieAsync(String url, String cookie) {
        block0: {
            CookieManager cookieManager = this.getCookieManager();
            if (cookieManager == null) break block0;
            cookieManager.setCookie(url, cookie, null);
        }
    }

    private final CookieManager getCookieManager() {
        if (this.cookieManager == null) {
            try {
                this.cookieManager = CookieManager.getInstance();
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return this.cookieManager;
    }

    private static final void clearCookies$lambda$0(Callback $callback, Boolean value) {
        Object[] objectArray = new Object[]{value};
        $callback.invoke(objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/modules/network/ForwardingCookieHandler$Companion;", "", "<init>", "()V", "VERSION_ZERO_HEADER", "", "VERSION_ONE_HEADER", "COOKIE_HEADER", "isCookieHeader", "", "name", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        private final boolean isCookieHeader(String name) {
            return StringsKt.equals((String)name, (String)ForwardingCookieHandler.VERSION_ZERO_HEADER, (boolean)true) || StringsKt.equals((String)name, (String)ForwardingCookieHandler.VERSION_ONE_HEADER, (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

