/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.Nullable;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CallbackImpl;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromArray;
import com.facebook.react.bridge.JSInstance;
import com.facebook.react.bridge.JavaModuleWrapper;
import com.facebook.react.bridge.NativeArgumentsParseException;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.PromiseImpl;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UnexpectedNativeTypeException;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.systrace.SystraceMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class JavaMethodWrapper
implements JavaModuleWrapper.NativeMethod {
    private static final ArgumentExtractor<Boolean> ARGUMENT_EXTRACTOR_BOOLEAN;
    private static final ArgumentExtractor<Double> ARGUMENT_EXTRACTOR_DOUBLE;
    private static final ArgumentExtractor<Float> ARGUMENT_EXTRACTOR_FLOAT;
    private static final ArgumentExtractor<Integer> ARGUMENT_EXTRACTOR_INTEGER;
    private static final ArgumentExtractor<String> ARGUMENT_EXTRACTOR_STRING;
    private static final ArgumentExtractor<ReadableArray> ARGUMENT_EXTRACTOR_ARRAY;
    private static final ArgumentExtractor<Dynamic> ARGUMENT_EXTRACTOR_DYNAMIC;
    private static final ArgumentExtractor<ReadableMap> ARGUMENT_EXTRACTOR_MAP;
    private static final ArgumentExtractor<Callback> ARGUMENT_EXTRACTOR_CALLBACK;
    private static final ArgumentExtractor<Promise> ARGUMENT_EXTRACTOR_PROMISE;
    private static final boolean DEBUG;
    private final Method mMethod;
    private final Class[] mParameterTypes;
    private final int mParamLength;
    private final JavaModuleWrapper mModuleWrapper;
    private String mType = "async";
    private boolean mArgumentsProcessed = false;
    @Nullable
    private ArgumentExtractor[] mArgumentExtractors;
    @Nullable
    private String mSignature;
    @Nullable
    private Object[] mArguments;
    @Nullable
    private int mJSArgumentsNeeded;

    private static char paramTypeToChar(Class paramClass) {
        char tryCommon = JavaMethodWrapper.commonTypeToChar(paramClass);
        if (tryCommon != '\u0000') {
            return tryCommon;
        }
        if (paramClass == Callback.class) {
            return 'X';
        }
        if (paramClass == Promise.class) {
            return 'P';
        }
        if (paramClass == ReadableMap.class) {
            return 'M';
        }
        if (paramClass == ReadableArray.class) {
            return 'A';
        }
        if (paramClass == Dynamic.class) {
            return 'Y';
        }
        throw new RuntimeException("Got unknown param class: " + paramClass.getSimpleName());
    }

    private static char returnTypeToChar(Class returnClass) {
        char tryCommon = JavaMethodWrapper.commonTypeToChar(returnClass);
        if (tryCommon != '\u0000') {
            return tryCommon;
        }
        if (returnClass == Void.TYPE) {
            return 'v';
        }
        if (returnClass == WritableMap.class) {
            return 'M';
        }
        if (returnClass == WritableArray.class) {
            return 'A';
        }
        throw new RuntimeException("Got unknown return class: " + returnClass.getSimpleName());
    }

    private static char commonTypeToChar(Class typeClass) {
        if (typeClass == Boolean.TYPE) {
            return 'z';
        }
        if (typeClass == Boolean.class) {
            return 'Z';
        }
        if (typeClass == Integer.TYPE) {
            return 'i';
        }
        if (typeClass == Integer.class) {
            return 'I';
        }
        if (typeClass == Double.TYPE) {
            return 'd';
        }
        if (typeClass == Double.class) {
            return 'D';
        }
        if (typeClass == Float.TYPE) {
            return 'f';
        }
        if (typeClass == Float.class) {
            return 'F';
        }
        if (typeClass == String.class) {
            return 'S';
        }
        return '\u0000';
    }

    public JavaMethodWrapper(JavaModuleWrapper module, Method method, boolean isSync) {
        this.mModuleWrapper = module;
        this.mMethod = method;
        this.mMethod.setAccessible(true);
        this.mParameterTypes = this.mMethod.getParameterTypes();
        this.mParamLength = this.mParameterTypes.length;
        if (isSync) {
            this.mType = "sync";
        } else if (this.mParamLength > 0 && this.mParameterTypes[this.mParamLength - 1] == Promise.class) {
            this.mType = "promise";
        }
    }

    private void processArguments() {
        if (this.mArgumentsProcessed) {
            return;
        }
        SystraceMessage.beginSection(0L, "processArguments").arg("method", this.mModuleWrapper.getName() + "." + this.mMethod.getName()).flush();
        try {
            this.mArgumentsProcessed = true;
            this.mArgumentExtractors = this.buildArgumentExtractors(this.mParameterTypes);
            this.mSignature = this.buildSignature(this.mMethod, this.mParameterTypes, this.mType.equals("sync"));
            this.mArguments = new Object[this.mParameterTypes.length];
            this.mJSArgumentsNeeded = this.calculateJSArgumentsNeeded();
        }
        finally {
            SystraceMessage.endSection(0L).flush();
        }
    }

    public Method getMethod() {
        return this.mMethod;
    }

    public String getSignature() {
        if (!this.mArgumentsProcessed) {
            this.processArguments();
        }
        return (String)Assertions.assertNotNull((Object)this.mSignature);
    }

    private String buildSignature(Method method, Class[] paramTypes, boolean isSync) {
        StringBuilder builder = new StringBuilder(paramTypes.length + 2);
        if (isSync) {
            builder.append(JavaMethodWrapper.returnTypeToChar(method.getReturnType()));
            builder.append('.');
        } else {
            builder.append("v.");
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            Class paramClass = paramTypes[i];
            if (paramClass == Promise.class) {
                Assertions.assertCondition((i == paramTypes.length - 1 ? 1 : 0) != 0, (String)"Promise must be used as last parameter only");
            }
            builder.append(JavaMethodWrapper.paramTypeToChar(paramClass));
        }
        return builder.toString();
    }

    private ArgumentExtractor[] buildArgumentExtractors(Class[] paramTypes) {
        ArgumentExtractor[] argumentExtractors = new ArgumentExtractor[paramTypes.length];
        for (int i = 0; i < paramTypes.length; i += argumentExtractors[i].getJSArgumentsNeeded()) {
            Class argumentClass = paramTypes[i];
            if (argumentClass == Boolean.class || argumentClass == Boolean.TYPE) {
                argumentExtractors[i] = ARGUMENT_EXTRACTOR_BOOLEAN;
                continue;
            }
            if (argumentClass == Integer.class || argumentClass == Integer.TYPE) {
                argumentExtractors[i] = ARGUMENT_EXTRACTOR_INTEGER;
                continue;
            }
            if (argumentClass == Double.class || argumentClass == Double.TYPE) {
                argumentExtractors[i] = ARGUMENT_EXTRACTOR_DOUBLE;
                continue;
            }
            if (argumentClass == Float.class || argumentClass == Float.TYPE) {
                argumentExtractors[i] = ARGUMENT_EXTRACTOR_FLOAT;
                continue;
            }
            if (argumentClass == String.class) {
                argumentExtractors[i] = ARGUMENT_EXTRACTOR_STRING;
                continue;
            }
            if (argumentClass == Callback.class) {
                argumentExtractors[i] = ARGUMENT_EXTRACTOR_CALLBACK;
                continue;
            }
            if (argumentClass == Promise.class) {
                argumentExtractors[i] = ARGUMENT_EXTRACTOR_PROMISE;
                Assertions.assertCondition((i == paramTypes.length - 1 ? 1 : 0) != 0, (String)"Promise must be used as last parameter only");
                continue;
            }
            if (argumentClass == ReadableMap.class) {
                argumentExtractors[i] = ARGUMENT_EXTRACTOR_MAP;
                continue;
            }
            if (argumentClass == ReadableArray.class) {
                argumentExtractors[i] = ARGUMENT_EXTRACTOR_ARRAY;
                continue;
            }
            if (argumentClass == Dynamic.class) {
                argumentExtractors[i] = ARGUMENT_EXTRACTOR_DYNAMIC;
                continue;
            }
            throw new RuntimeException("Got unknown argument class: " + argumentClass.getSimpleName());
        }
        return argumentExtractors;
    }

    private int calculateJSArgumentsNeeded() {
        int n = 0;
        for (ArgumentExtractor extractor : (ArgumentExtractor[])Assertions.assertNotNull((Object)this.mArgumentExtractors)) {
            n += extractor.getJSArgumentsNeeded();
        }
        return n;
    }

    private String getAffectedRange(int startIndex, int jsArgumentsNeeded) {
        return jsArgumentsNeeded > 1 ? "" + startIndex + "-" + (startIndex + jsArgumentsNeeded - 1) : "" + startIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(JSInstance jsInstance, ReadableArray parameters) {
        String traceName = this.mModuleWrapper.getName() + "." + this.mMethod.getName();
        SystraceMessage.beginSection(0L, "callJavaModuleMethod").arg("method", traceName).flush();
        if (DEBUG) {
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.BRIDGE_CALLS, "JS->Java: %s.%s()", this.mModuleWrapper.getName(), this.mMethod.getName());
        }
        try {
            int i;
            if (!this.mArgumentsProcessed) {
                this.processArguments();
            }
            if (this.mArguments == null || this.mArgumentExtractors == null) {
                throw new Error("processArguments failed");
            }
            if (this.mJSArgumentsNeeded != parameters.size()) {
                throw new NativeArgumentsParseException(traceName + " got " + parameters.size() + " arguments, expected " + this.mJSArgumentsNeeded);
            }
            int jsArgumentsConsumed = 0;
            try {
                for (i = 0; i < this.mArgumentExtractors.length; ++i) {
                    this.mArguments[i] = this.mArgumentExtractors[i].extractArgument(jsInstance, parameters, jsArgumentsConsumed);
                    jsArgumentsConsumed += this.mArgumentExtractors[i].getJSArgumentsNeeded();
                }
            }
            catch (UnexpectedNativeTypeException | NullPointerException e) {
                throw new NativeArgumentsParseException(e.getMessage() + " (constructing arguments for " + traceName + " at argument index " + this.getAffectedRange(jsArgumentsConsumed, this.mArgumentExtractors[i].getJSArgumentsNeeded()) + ")", e);
            }
            try {
                this.mMethod.invoke((Object)this.mModuleWrapper.getModule(), this.mArguments);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(JavaMethodWrapper.createInvokeExceptionMessage(traceName), e);
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ite.getCause();
                }
                throw new RuntimeException(JavaMethodWrapper.createInvokeExceptionMessage(traceName), ite);
            }
        }
        finally {
            SystraceMessage.endSection(0L).flush();
        }
    }

    private static String createInvokeExceptionMessage(String traceName) {
        return "Could not invoke " + traceName;
    }

    @Override
    public String getType() {
        return this.mType;
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("JavaMethodWrapper", LegacyArchitectureLogLevel.WARNING);
        ARGUMENT_EXTRACTOR_BOOLEAN = new ArgumentExtractor<Boolean>(){

            @Override
            public Boolean extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                return jsArguments.getBoolean(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_DOUBLE = new ArgumentExtractor<Double>(){

            @Override
            public Double extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                return jsArguments.getDouble(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_FLOAT = new ArgumentExtractor<Float>(){

            @Override
            public Float extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                return Float.valueOf((float)jsArguments.getDouble(atIndex));
            }
        };
        ARGUMENT_EXTRACTOR_INTEGER = new ArgumentExtractor<Integer>(){

            @Override
            public Integer extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                return (int)jsArguments.getDouble(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_STRING = new ArgumentExtractor<String>(){

            @Override
            public String extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                return jsArguments.getString(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_ARRAY = new ArgumentExtractor<ReadableArray>(){

            @Override
            public ReadableArray extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                return jsArguments.getArray(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_DYNAMIC = new ArgumentExtractor<Dynamic>(){

            @Override
            public Dynamic extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                return DynamicFromArray.create(jsArguments, atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_MAP = new ArgumentExtractor<ReadableMap>(){

            @Override
            public ReadableMap extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                return jsArguments.getMap(atIndex);
            }
        };
        ARGUMENT_EXTRACTOR_CALLBACK = new ArgumentExtractor<Callback>(){

            @Override
            @Nullable
            public Callback extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                if (jsArguments.isNull(atIndex)) {
                    return null;
                }
                int id2 = (int)jsArguments.getDouble(atIndex);
                return new CallbackImpl(jsInstance, id2);
            }
        };
        ARGUMENT_EXTRACTOR_PROMISE = new ArgumentExtractor<Promise>(){

            @Override
            public int getJSArgumentsNeeded() {
                return 2;
            }

            @Override
            public Promise extractArgument(JSInstance jsInstance, ReadableArray jsArguments, int atIndex) {
                Callback resolve = ARGUMENT_EXTRACTOR_CALLBACK.extractArgument(jsInstance, jsArguments, atIndex);
                Callback reject = ARGUMENT_EXTRACTOR_CALLBACK.extractArgument(jsInstance, jsArguments, atIndex + 1);
                return new PromiseImpl(resolve, reject);
            }
        };
        DEBUG = PrinterHolder.getPrinter().shouldDisplayLogMessage(ReactDebugOverlayTags.BRIDGE_CALLS);
    }

    private static abstract class ArgumentExtractor<T> {
        private ArgumentExtractor() {
        }

        public int getJSArgumentsNeeded() {
            return 1;
        }

        @Nullable
        public abstract T extractArgument(JSInstance var1, ReadableArray var2, int var3);
    }
}

