/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0007\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/bridge/JSONArguments;", "", "<init>", "()V", "fromJSONObject", "Lcom/facebook/react/bridge/ReadableMap;", "obj", "Lorg/json/JSONObject;", "fromJSONObjectString", "objStr", "", "fromJSONArray", "Lcom/facebook/react/bridge/ReadableArray;", "arr", "Lorg/json/JSONArray;", "fromJSONArrayString", "arrStr", "ReactAndroid_debug"})
public final class JSONArguments {
    @NotNull
    public static final JSONArguments INSTANCE = new JSONArguments();

    private JSONArguments() {
    }

    @JvmStatic
    @NotNull
    public static final ReadableMap fromJSONObject(@NotNull JSONObject obj) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        WritableMap writableMap = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
        WritableMap result = writableMap;
        Iterator keys = obj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = obj.get(key);
            Object object = value;
            if (object instanceof JSONObject) {
                Intrinsics.checkNotNull((Object)key);
                result.putMap(key, JSONArguments.fromJSONObject((JSONObject)value));
                continue;
            }
            if (object instanceof JSONArray) {
                Intrinsics.checkNotNull((Object)key);
                result.putArray(key, JSONArguments.fromJSONArray((JSONArray)value));
                continue;
            }
            if (object instanceof String) {
                Intrinsics.checkNotNull((Object)key);
                result.putString(key, (String)value);
                continue;
            }
            if (object instanceof Boolean) {
                Intrinsics.checkNotNull((Object)key);
                result.putBoolean(key, (Boolean)value);
                continue;
            }
            if (object instanceof Integer) {
                Intrinsics.checkNotNull((Object)key);
                result.putInt(key, ((Number)value).intValue());
                continue;
            }
            if (object instanceof Double) {
                Intrinsics.checkNotNull((Object)key);
                result.putDouble(key, ((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Long) {
                Intrinsics.checkNotNull((Object)key);
                result.putInt(key, (int)((Number)value).longValue());
                continue;
            }
            if (obj.isNull(key)) {
                Intrinsics.checkNotNull((Object)key);
                result.putNull(key);
                continue;
            }
            throw new JSONException("Unexpected value when parsing JSON object. key: " + key);
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final ReadableMap fromJSONObjectString(@NotNull String objStr) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)objStr, (String)"objStr");
        return JSONArguments.fromJSONObject(new JSONObject(objStr));
    }

    @JvmStatic
    @NotNull
    public static final ReadableArray fromJSONArray(@NotNull JSONArray arr) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        WritableArray writableArray = Arguments.createArray();
        Intrinsics.checkNotNullExpressionValue((Object)writableArray, (String)"createArray(...)");
        WritableArray result = writableArray;
        int n = arr.length();
        for (int i = 0; i < n; ++i) {
            Object value = arr.get(i);
            Object object = value;
            if (object instanceof JSONObject) {
                result.pushMap(JSONArguments.fromJSONObject((JSONObject)value));
                continue;
            }
            if (object instanceof JSONArray) {
                result.pushArray(JSONArguments.fromJSONArray((JSONArray)value));
                continue;
            }
            if (object instanceof String) {
                result.pushString((String)value);
                continue;
            }
            if (object instanceof Boolean) {
                result.pushBoolean((Boolean)value);
                continue;
            }
            if (object instanceof Integer) {
                result.pushInt(((Number)value).intValue());
                continue;
            }
            if (object instanceof Double) {
                result.pushDouble(((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Long) {
                result.pushInt((int)((Number)value).longValue());
                continue;
            }
            if (arr.isNull(i)) {
                result.pushNull();
                continue;
            }
            throw new JSONException("Unexpected value when parsing JSON array. index: " + i);
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final ReadableArray fromJSONArrayString(@NotNull String arrStr) throws JSONException {
        Intrinsics.checkNotNullParameter((Object)arrStr, (String)"arrStr");
        return JSONArguments.fromJSONArray(new JSONArray(arrStr));
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("JSONArguments", LegacyArchitectureLogLevel.WARNING);
    }
}

